/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ReflectionCache;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementSignatureProvider {
    public static ExtensionPointName<ElementSignatureProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.elementSignatureProvider");

    @Nullable
    public abstract String getSignature(PsiElement var1);

    @Nullable
    public PsiElement restoreBySignature(PsiFile file, String signature) {
        PsiFile parent;
        int semicolonIndex = signature.indexOf(59);
        if (semicolonIndex >= 0) {
            String parentSignature = signature.substring(semicolonIndex + 1);
            parent = this.restoreBySignature(file, parentSignature);
            if (parent == null) {
                return null;
            }
            signature = signature.substring(0, semicolonIndex);
        } else {
            parent = file;
        }
        StringTokenizer tokenizer = new StringTokenizer(signature, "#");
        String type = tokenizer.nextToken();
        return this.restoreBySignatureTokens(file, (PsiElement)parent, type, tokenizer);
    }

    @Nullable
    protected PsiElement restoreBySignatureTokens(PsiFile file, PsiElement parent, String type, StringTokenizer tokenizer) {
        return null;
    }

    protected static <T extends PsiNamedElement> int getChildIndex(T element, PsiElement parent, String name, Class<T> hisClass) {
        PsiElement[] children = parent.getChildren();
        int index = 0;
        for (PsiElement child : children) {
            PsiNamedElement namedChild;
            String childName;
            if (!ReflectionCache.isAssignable(hisClass, child.getClass()) || !Comparing.equal((String)name, (String)(childName = (namedChild = (PsiNamedElement)child).getName()))) continue;
            if (namedChild.equals(element)) {
                return index;
            }
            ++index;
        }
        return index;
    }

    @Nullable
    protected static <T extends PsiNamedElement> T restoreElementInternal(@NotNull PsiElement parent, String name, int index, Class<T> hisClass) {
        PsiElement[] children;
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/folding/impl/ElementSignatureProvider.restoreElementInternal must not be null");
        }
        for (PsiElement child : children = parent.getChildren()) {
            PsiNamedElement namedChild;
            String childName;
            if (!ReflectionCache.isAssignable(hisClass, child.getClass()) || !Comparing.equal((String)name, (String)(childName = (namedChild = (PsiNamedElement)child).getName()))) continue;
            if (index == 0) {
                return (T)namedChild;
            }
            --index;
        }
        return null;
    }
}

