/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.text.StringTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class DocumentFoldingInfo
implements JDOMExternalizable,
CodeFoldingState {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.DocumentFoldingInfo");
    private final Project myProject;
    private final VirtualFile myFile;
    private final ArrayList<Object> myPsiElementsOrRangeMarkers = new ArrayList();
    private final ArrayList<Boolean> myExpandedStates = new ArrayList();
    private final Map<RangeMarker, String> myPlaceholderTexts = new HashMap<RangeMarker, String>();
    private static final String DEFAULT_PLACEHOLDER = "...";
    @NonNls
    private static final String ELEMENT_TAG = "element";
    @NonNls
    private static final String SIGNATURE_ATT = "signature";
    @NonNls
    private static final String EXPANDED_ATT = "expanded";
    @NonNls
    private static final String MARKER_TAG = "marker";
    @NonNls
    private static final String DATE_ATT = "date";
    @NonNls
    private static final String PLACEHOLDER_ATT = "placeholder";

    public DocumentFoldingInfo(Project project, Document document) {
        this.myProject = project;
        this.myFile = FileDocumentManager.getInstance().getFile(document);
    }

    public void loadFromEditor(Editor editor) {
        FoldRegion[] foldRegions;
        this.clear();
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        EditorFoldingInfo info = EditorFoldingInfo.get(editor);
        for (FoldRegion region : foldRegions = editor.getFoldingModel().getAllFoldRegions()) {
            boolean expanded;
            PsiElement element = info.getPsiElement(region);
            boolean collapseByDefault = element != null && FoldingPolicy.isCollapseByDefault(element) && !FoldingUtil.caretInsideRange(editor, new TextRange(region.getStartOffset(), region.getEndOffset()));
            if (collapseByDefault == !(expanded = region.isExpanded()) && element != null) continue;
            if (element != null) {
                this.myPsiElementsOrRangeMarkers.add(element);
            } else if (region.isValid()) {
                this.myPsiElementsOrRangeMarkers.add(region);
                String placeholderText = region.getPlaceholderText();
                this.myPlaceholderTexts.put((RangeMarker)region, placeholderText);
            }
            this.myExpandedStates.add(expanded ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    void setToEditor(Editor editor) {
        LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (psiManager.isDisposed()) {
            return;
        }
        if (!this.myFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(this.myFile);
        if (psiFile == null) {
            return;
        }
        Map<PsiElement, FoldingDescriptor> ranges = null;
        for (int i = 0; i < this.myPsiElementsOrRangeMarkers.size(); ++i) {
            Object o = this.myPsiElementsOrRangeMarkers.get(i);
            if (o instanceof PsiElement) {
                TextRange range;
                FoldRegion region;
                FoldingDescriptor descriptor;
                PsiElement element = (PsiElement)o;
                if (!element.isValid()) continue;
                if (ranges == null) {
                    ranges = DocumentFoldingInfo.buildRanges(editor, psiFile);
                }
                if ((descriptor = (FoldingDescriptor)ranges.get(element)) == null || (region = FoldingUtil.findFoldRegion(editor, (range = descriptor.getRange()).getStartOffset(), range.getEndOffset())) == null) continue;
                boolean state = this.myExpandedStates.get(i);
                region.setExpanded(state);
                continue;
            }
            if (o instanceof RangeMarker) {
                RangeMarker marker = (RangeMarker)o;
                if (!marker.isValid()) continue;
                FoldRegion region = FoldingUtil.findFoldRegion(editor, marker.getStartOffset(), marker.getEndOffset());
                if (region == null) {
                    String placeHolderText = this.myPlaceholderTexts.get(marker);
                    region = ((FoldingModelEx)editor.getFoldingModel()).createFoldRegion(marker.getStartOffset(), marker.getEndOffset(), placeHolderText, null);
                    if (!editor.getFoldingModel().addFoldRegion(region)) {
                        return;
                    }
                }
                boolean state = this.myExpandedStates.get(i);
                region.setExpanded(state);
                continue;
            }
            LOG.error("o = " + o);
        }
    }

    private static Map<PsiElement, FoldingDescriptor> buildRanges(Editor editor, PsiFile psiFile) {
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(psiFile.getLanguage());
        ASTNode node = psiFile.getNode();
        if (node == null) {
            return Collections.emptyMap();
        }
        FoldingDescriptor[] descriptors = LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psiFile, (Document)editor.getDocument(), (boolean)true);
        HashMap<PsiElement, FoldingDescriptor> ranges = new HashMap<PsiElement, FoldingDescriptor>();
        for (FoldingDescriptor descriptor : descriptors) {
            ASTNode ast = descriptor.getElement();
            PsiElement psi = ast.getPsi();
            if (psi == null) continue;
            ranges.put(psi, descriptor);
        }
        return ranges;
    }

    public void clear() {
        this.myPsiElementsOrRangeMarkers.clear();
        this.myExpandedStates.clear();
        this.myPlaceholderTexts.clear();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        if (this.myPsiElementsOrRangeMarkers.isEmpty()) {
            throw new WriteExternalException();
        }
        String date = null;
        for (int i = 0; i < this.myPsiElementsOrRangeMarkers.size(); ++i) {
            Object o = this.myPsiElementsOrRangeMarkers.get(i);
            Boolean state = this.myExpandedStates.get(i);
            if (o instanceof PsiElement) {
                String signature;
                PsiElement psiElement = (PsiElement)o;
                if (!psiElement.isValid() || (signature = FoldingPolicy.getSignature(psiElement)) == null) continue;
                PsiElement restoredElement = FoldingPolicy.restoreBySignature(psiElement.getContainingFile(), signature);
                if (!psiElement.equals(restoredElement)) {
                    restoredElement = FoldingPolicy.restoreBySignature(psiElement.getContainingFile(), signature);
                    LOG.error("element:" + psiElement + ", signature:" + signature + ", file:" + psiElement.getContainingFile());
                }
                Element e = new Element(ELEMENT_TAG);
                e.setAttribute(SIGNATURE_ATT, signature);
                e.setAttribute(EXPANDED_ATT, state.toString());
                element.addContent(e);
                continue;
            }
            RangeMarker marker = (RangeMarker)o;
            Element e = new Element(MARKER_TAG);
            if (date == null) {
                date = this.getTimeStamp();
            }
            if ("".equals(date)) continue;
            e.setAttribute(DATE_ATT, date);
            e.setAttribute(EXPANDED_ATT, state.toString());
            String signature = Integer.valueOf(marker.getStartOffset()) + ":" + Integer.valueOf(marker.getEndOffset());
            e.setAttribute(SIGNATURE_ATT, signature);
            String placeHolderText = this.myPlaceholderTexts.get(marker);
            e.setAttribute(PLACEHOLDER_ATT, placeHolderText);
            element.addContent(e);
        }
    }

    public void readExternal(Element element) {
        this.myPsiElementsOrRangeMarkers.clear();
        this.myExpandedStates.clear();
        if (!this.myFile.isValid()) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
        if (document == null) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null || !psiFile.getViewProvider().isPhysical()) {
            return;
        }
        String date = null;
        for (Object o : element.getChildren()) {
            Element e = (Element)o;
            if (ELEMENT_TAG.equals(e.getName())) {
                PsiElement restoredElement;
                String signature = e.getAttributeValue(SIGNATURE_ATT);
                if (signature == null || (restoredElement = FoldingPolicy.restoreBySignature(psiFile, signature)) == null) continue;
                this.myPsiElementsOrRangeMarkers.add(restoredElement);
                this.myExpandedStates.add(Boolean.valueOf(e.getAttributeValue(EXPANDED_ATT)));
                continue;
            }
            if (MARKER_TAG.equals(e.getName())) {
                if (date == null) {
                    date = this.getTimeStamp();
                }
                if ("".equals(date) || !date.equals(e.getAttributeValue(DATE_ATT)) || FileDocumentManager.getInstance().isDocumentUnsaved(document)) continue;
                StringTokenizer tokenizer = new StringTokenizer(e.getAttributeValue(SIGNATURE_ATT), ":");
                try {
                    int start = Integer.valueOf(tokenizer.nextToken());
                    int end = Integer.valueOf(tokenizer.nextToken());
                    if (start < 0 || end >= document.getTextLength() || start > end) continue;
                    RangeMarker marker = document.createRangeMarker(start, end);
                    this.myPsiElementsOrRangeMarkers.add(marker);
                    this.myExpandedStates.add(Boolean.valueOf(e.getAttributeValue(EXPANDED_ATT)));
                    String placeHolderText = e.getAttributeValue(PLACEHOLDER_ATT);
                    if (placeHolderText == null) {
                        placeHolderText = DEFAULT_PLACEHOLDER;
                    }
                    this.myPlaceholderTexts.put(marker, placeHolderText);
                }
                catch (NoSuchElementException exc) {
                    LOG.error((Throwable)exc);
                }
                continue;
            }
            throw new IllegalStateException("unknown tag: " + e.getName());
        }
    }

    private String getTimeStamp() {
        if (!this.myFile.isValid()) {
            return "";
        }
        return Long.toString(this.myFile.getTimeStamp());
    }
}

