/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import java.util.ArrayList;
import java.util.List;

public class IfStatementSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiIfStatement;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        result.addAll(IfStatementSelectioner.expandToWholeLine(editorText, e.getTextRange(), false));
        PsiIfStatement statement = (PsiIfStatement)e;
        PsiKeyword elseKeyword = statement.getElseElement();
        if (elseKeyword != null) {
            PsiIfStatement elseIf;
            PsiKeyword element;
            result.addAll(IfStatementSelectioner.expandToWholeLine(editorText, new TextRange(elseKeyword.getTextRange().getStartOffset(), statement.getTextRange().getEndOffset()), false));
            PsiStatement branch = statement.getElseBranch();
            if (branch instanceof PsiIfStatement && (element = (elseIf = (PsiIfStatement)branch).getElseElement()) != null) {
                result.addAll(IfStatementSelectioner.expandToWholeLine(editorText, new TextRange(elseKeyword.getTextRange().getStartOffset(), elseIf.getThenBranch().getTextRange().getEndOffset()), false));
            }
        }
        return result;
    }
}

