/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;

public class MissingReturnExpressionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof PsiReturnStatement) {
            PsiMethod method;
            PsiType returnType;
            PsiReturnStatement retStatement = (PsiReturnStatement)psiElement;
            if (retStatement.getReturnValue() != null && this.startLine(editor, (PsiElement)retStatement) == this.startLine(editor, (PsiElement)retStatement.getReturnValue())) {
                return;
            }
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiClassInitializer.class, PsiMethod.class});
            if (parent instanceof PsiMethod && (returnType = (method = (PsiMethod)parent).getReturnType()) != null && returnType != PsiType.VOID) {
                int startOffset = retStatement.getTextRange().getStartOffset();
                if (retStatement.getReturnValue() != null) {
                    editor.getDocument().insertString(startOffset + "return".length(), (CharSequence)";");
                }
                processor.registerUnresolvedError(startOffset + "return".length());
            }
        }
    }

    private int startLine(Editor editor, PsiElement psiElement) {
        return editor.getDocument().getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

