/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.JavaTypedHandler;
import com.intellij.codeInsight.editorActions.JavaTypedHandlerUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;

public class JavaBackspaceHandler
extends BackspaceHandlerDelegate {
    private boolean myToDeleteGt;

    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset() - 1;
        this.myToDeleteGt = c == '<' && file instanceof PsiJavaFile && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && JavaTypedHandler.isAfterClassLikeIdentifierOrDot(offset, editor);
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (editor.getDocument().getTextLength() <= offset) {
            return false;
        }
        char c1 = chars.charAt(offset);
        if (c == '<' && this.myToDeleteGt) {
            if (c1 != '>') {
                return true;
            }
            JavaBackspaceHandler.handleLTDeletion(editor, offset);
            return true;
        }
        return false;
    }

    private static void handleLTDeletion(Editor editor, int offset) {
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        while (iterator.getStart() > 0 && !JavaTypedHandlerUtil.isTokenInvalidInsideReference(iterator.getTokenType())) {
            iterator.retreat();
        }
        if (JavaTypedHandlerUtil.isTokenInvalidInsideReference(iterator.getTokenType())) {
            iterator.advance();
        }
        int balance = 0;
        while (!iterator.atEnd() && balance >= 0) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == JavaTokenType.LT) {
                ++balance;
            } else if (tokenType == JavaTokenType.GT) {
                --balance;
            } else if (JavaTypedHandlerUtil.isTokenInvalidInsideReference(tokenType)) break;
            iterator.advance();
        }
        if (balance < 0) {
            editor.getDocument().deleteString(offset, offset + 1);
        }
    }
}

