/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInsight.daemon.quickFix.RenameFileReferenceIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FileReferenceQuickFixProvider {
    private FileReferenceQuickFixProvider() {
    }

    public static List<? extends LocalQuickFix> registerQuickFix(HighlightInfo info, FileReference reference) {
        boolean isdirectory;
        PsiFileSystemItem psiElement;
        FileReferenceSet fileReferenceSet = reference.getFileReferenceSet();
        int index = reference.getIndex();
        if (index < 0) {
            return Collections.emptyList();
        }
        String newFileName = reference.getCanonicalText();
        if (newFileName.length() == 0 || newFileName.indexOf(92) != -1 || newFileName.indexOf(42) != -1 || newFileName.indexOf(63) != -1 || SystemInfo.isWindows && newFileName.indexOf(58) != -1) {
            return Collections.emptyList();
        }
        PsiFileSystemItem context = null;
        if (index > 0) {
            context = fileReferenceSet.getReference(index - 1).resolve();
        } else {
            Collection<PsiFileSystemItem> defaultContexts = fileReferenceSet.getDefaultContexts();
            if (defaultContexts.isEmpty()) {
                return Collections.emptyList();
            }
            for (PsiFileSystemItem defaultContext : defaultContexts) {
                VirtualFile virtualFile;
                if (defaultContext == null || (virtualFile = defaultContext.getVirtualFile()) == null || !defaultContext.isDirectory() || !virtualFile.isInLocalFileSystem()) continue;
                context = defaultContext;
                break;
            }
            if (context == null && ApplicationManager.getApplication().isUnitTestMode()) {
                context = defaultContexts.iterator().next();
            }
        }
        if (context == null) {
            return Collections.emptyList();
        }
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        PsiDirectory directory = context.getManager().findDirectory(virtualFile);
        if (directory == null) {
            return Collections.emptyList();
        }
        if (fileReferenceSet.isCaseSensitive() && (psiElement = reference.innerSingleResolve(false)) instanceof PsiNamedElement) {
            String existingElementName = ((PsiNamedElement)psiElement).getName();
            RenameFileReferenceIntentionAction renameRefAction = new RenameFileReferenceIntentionAction(existingElementName, reference);
            QuickFixAction.registerQuickFixAction(info, renameRefAction);
            RenameFileFix renameFileFix = new RenameFileFix(newFileName);
            QuickFixAction.registerQuickFixAction(info, renameFileFix);
            return Arrays.asList(renameRefAction, renameFileFix);
        }
        if (!reference.isLast()) {
            try {
                directory.checkCreateSubdirectory(newFileName);
            }
            catch (IncorrectOperationException ex) {
                return Collections.emptyList();
            }
            isdirectory = true;
        } else {
            FileType ft = FileTypeManager.getInstance().getFileTypeByFileName(newFileName);
            if (ft instanceof UnknownFileType) {
                return Collections.emptyList();
            }
            try {
                directory.checkCreateFile(newFileName);
            }
            catch (IncorrectOperationException ex) {
                return Collections.emptyList();
            }
            isdirectory = false;
        }
        CreateFileFix action = new CreateFileFix(isdirectory, newFileName, directory);
        QuickFixAction.registerQuickFixAction(info, action);
        return Arrays.asList(action);
    }
}

