/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import gnu.trove.THashMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VariableAccessFromInnerClassFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.VariableAccessFromInnerClassFix");
    private final PsiVariable myVariable;
    private final PsiClass myClass;
    private final int myFixType;
    private static final int MAKE_FINAL = 0;
    private static final int MAKE_ARRAY = 1;
    private static final int COPY_TO_FINAL = 2;
    private static final Key<Map<PsiVariable, Boolean>>[] VARS = new Key[]{Key.create((String)"VARS_TO_MAKE_FINAL"), Key.create((String)"VARS_TO_TRANSFORM"), Key.create((String)"???")};

    public VariableAccessFromInnerClassFix(PsiVariable variable, PsiClass aClass) {
        this.myVariable = variable;
        this.myClass = aClass;
        this.myFixType = VariableAccessFromInnerClassFix.getQuickFixType(variable);
        if (this.myFixType == -1) {
            return;
        }
        this.getVariablesToFix().add(variable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getText() {
        String string;
        String message;
        switch (this.myFixType) {
            case 0: {
                message = "make.final.text";
                break;
            }
            case 1: {
                message = "make.final.transform.to.one.element.array";
                break;
            }
            case 2: {
                String string2 = QuickFixBundle.message("make.final.copy.to.temp", this.myVariable.getName());
                string = string2;
                if (string2 != null) return string;
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix.getText must not return null");
            }
            default: {
                LOG.error("invalid type " + this.myFixType);
                return "";
            }
        }
        Collection<PsiVariable> vars = this.getVariablesToFix();
        String varNames = vars.size() == 1 ? "'" + this.myVariable.getName() + "'" : "variables";
        String string3 = QuickFixBundle.message(message, varNames);
        string = string3;
        if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix.getText must not return null");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("make.final.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix.isAvailable must not be null");
        }
        return this.myClass != null && this.myClass.isValid() && this.myClass.getManager().isInProject((PsiElement)this.myClass) && this.myVariable != null && this.myVariable.isValid() && this.myFixType != -1 && !this.getVariablesToFix().isEmpty() && !VariableAccessFromInnerClassFix.inOwnInitializer(this.myVariable, this.myClass);
    }

    private static boolean inOwnInitializer(PsiVariable variable, PsiClass aClass) {
        return PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)aClass, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.preparePsiElementsForWrite(new PsiElement[]{this.myClass, this.myVariable})) {
            return;
        }
        try {
            switch (this.myFixType) {
                case 0: {
                    this.makeFinal();
                    return;
                }
                case 1: {
                    this.makeArray();
                    return;
                }
                case 2: {
                    this.copyToFinal();
                    return;
                }
            }
            return;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        finally {
            this.getVariablesToFix().clear();
        }
    }

    private void makeArray() {
        for (PsiVariable var : this.getVariablesToFix()) {
            this.makeArray(var);
        }
    }

    @NotNull
    private Collection<PsiVariable> getVariablesToFix() {
        Map vars = (Map)this.myClass.getUserData(VARS[this.myFixType]);
        if (vars == null) {
            vars = new ConcurrentWeakHashMap(1);
            this.myClass.putUserData(VARS[this.myFixType], (Object)vars);
        }
        final Map finalVars = vars;
        AbstractCollection<PsiVariable> abstractCollection = new AbstractCollection<PsiVariable>(){

            @Override
            public boolean add(PsiVariable psiVariable) {
                return finalVars.put(psiVariable, Boolean.TRUE) == null;
            }

            @Override
            public Iterator<PsiVariable> iterator() {
                return finalVars.keySet().iterator();
            }

            @Override
            public int size() {
                return finalVars.size();
            }
        };
        if (abstractCollection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassFix.getVariablesToFix must not return null");
        }
        return abstractCollection;
    }

    private void makeFinal() {
        for (PsiVariable var : this.getVariablesToFix()) {
            if (!var.isValid()) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)true);
        }
    }

    private void makeArray(PsiVariable variable) throws IncorrectOperationException {
        PsiDeclarationStatement variableDeclarationStatement;
        PsiType type = variable.getType();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).getElementFactory();
        PsiArrayType newType = type.createArrayType();
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            String expression = "[1]";
            while (type instanceof PsiArrayType) {
                expression = expression + "[1]";
                type = ((PsiArrayType)type).getComponentType();
            }
            PsiExpression init = factory.createExpressionFromText("new " + type.getCanonicalText() + expression, (PsiElement)variable);
            variableDeclarationStatement = factory.createVariableDeclarationStatement(variable.getName(), (PsiType)newType, init);
        } else {
            PsiExpression init = factory.createExpressionFromText(" { " + initializer.getText() + " }", (PsiElement)variable);
            variableDeclarationStatement = factory.createVariableDeclarationStatement(variable.getName(), (PsiType)newType, init);
        }
        PsiVariable newVariable = (PsiVariable)variableDeclarationStatement.getDeclaredElements()[0];
        PsiUtil.setModifierProperty((PsiModifierListOwner)newVariable, (String)"final", (boolean)true);
        PsiExpression newExpression = factory.createExpressionFromText(variable.getName() + "[0]", (PsiElement)variable);
        PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (outerCodeBlock == null) {
            return;
        }
        ArrayList<PsiReferenceExpression> outerReferences = new ArrayList<PsiReferenceExpression>();
        VariableAccessFromInnerClassFix.collectReferences(outerCodeBlock, variable, outerReferences);
        VariableAccessFromInnerClassFix.replaceReferences(outerReferences, (PsiElement)newExpression);
        variable.replace((PsiElement)newVariable);
    }

    private void copyToFinal() throws IncorrectOperationException {
        PsiManager psiManager = this.myClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        PsiExpression initializer = factory.createExpressionFromText(this.myVariable.getName(), (PsiElement)this.myClass);
        String newName = VariableAccessFromInnerClassFix.suggestNewName(psiManager.getProject(), this.myVariable);
        PsiType type = this.myVariable.getType();
        PsiDeclarationStatement copyDecl = factory.createVariableDeclarationStatement(newName, type, initializer);
        PsiVariable newVariable = (PsiVariable)copyDecl.getDeclaredElements()[0];
        PsiUtil.setModifierProperty((PsiModifierListOwner)newVariable, (String)"final", (boolean)true);
        PsiElement statement = this.getStatementToInsertBefore();
        if (statement == null) {
            return;
        }
        statement.getParent().addBefore((PsiElement)copyDecl, statement);
        PsiExpression newExpression = factory.createExpressionFromText(newName, (PsiElement)this.myVariable);
        VariableAccessFromInnerClassFix.replaceReferences((PsiElement)this.myClass, this.myVariable, (PsiElement)newExpression);
    }

    private PsiElement getStatementToInsertBefore() {
        PsiElement declarationScope;
        PsiElement psiElement = declarationScope = this.myVariable instanceof PsiParameter ? ((PsiParameter)this.myVariable).getDeclarationScope() : PsiUtil.getVariableCodeBlock((PsiVariable)this.myVariable, null);
        if (declarationScope == null) {
            return null;
        }
        PsiClass statement = this.myClass;
        block0: while (true) {
            if ((statement = PsiUtil.getEnclosingStatement((PsiElement)statement)) == null || statement.getParent() == null) {
                return null;
            }
            for (PsiClass element = statement; element != declarationScope && !(element instanceof PsiFile); element = element.getParent()) {
                if (!(element instanceof PsiClass)) continue;
                statement = statement.getParent();
                continue block0;
            }
            break;
        }
        return statement;
    }

    private static String suggestNewName(Project project, PsiVariable variable) {
        String name = variable.getName();
        if (name.length() > 1 && Character.isDigit(name.charAt(name.length() - 1))) {
            name = name.substring(0, name.length() - 1);
        }
        name = "final" + StringUtil.capitalize((String)StringUtil.trimStart((String)name, (String)"final"));
        return JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(name, (PsiElement)variable, true);
    }

    private static void replaceReferences(PsiElement context, final PsiVariable variable, final PsiElement newExpression) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.resolve() == variable) {
                    try {
                        expression.replace(newExpression);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
                super.visitReferenceExpression(expression);
            }
        });
    }

    private static void replaceReferences(List<PsiReferenceExpression> references, PsiElement newExpression) throws IncorrectOperationException {
        for (PsiReferenceExpression reference : references) {
            reference.replace(newExpression);
        }
    }

    private static void collectReferences(PsiElement context, final PsiVariable variable, final List<PsiReferenceExpression> references) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.resolve() == variable) {
                    references.add(expression);
                }
                super.visitReferenceExpression(expression);
            }
        });
    }

    private static int getQuickFixType(PsiVariable variable) {
        PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (outerCodeBlock == null) {
            return -1;
        }
        ArrayList<PsiReferenceExpression> outerReferences = new ArrayList<PsiReferenceExpression>();
        VariableAccessFromInnerClassFix.collectReferences(outerCodeBlock, variable, outerReferences);
        int type = 0;
        for (PsiReferenceExpression expression : outerReferences) {
            PsiClass innerClass = HighlightControlFlowUtil.getInnerClassVariableReferencedFrom(variable, (PsiElement)expression);
            if (innerClass == null) continue;
            int thisType = 0;
            if (VariableAccessFromInnerClassFix.writtenInside(variable, (PsiElement)innerClass)) {
                if (variable instanceof PsiParameter) {
                    return -1;
                }
                thisType = 1;
            }
            if (thisType == 0 && !VariableAccessFromInnerClassFix.canBeFinal(variable, outerReferences)) {
                thisType = 2;
            }
            type = Math.max(type, thisType);
        }
        return type;
    }

    private static boolean canBeFinal(PsiVariable variable, List<PsiReferenceExpression> references) {
        THashMap uninitializedVarProblems = new THashMap();
        THashMap finalVarProblems = new THashMap();
        for (PsiReferenceExpression expression : references) {
            if (ControlFlowUtil.isVariableAssignedInLoop(expression, (PsiElement)variable)) {
                return false;
            }
            HighlightInfo highlightInfo = HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(expression, variable, (Map<PsiElement, Collection<PsiReferenceExpression>>)uninitializedVarProblems);
            if (highlightInfo != null) {
                return false;
            }
            highlightInfo = HighlightControlFlowUtil.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable, expression, (Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>>)finalVarProblems);
            if (highlightInfo == null) continue;
            return false;
        }
        return true;
    }

    private static boolean writtenInside(PsiVariable variable, PsiElement element) {
        PsiElement[] children;
        if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            if (lExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)lExpression).resolve() == variable) {
                return true;
            }
        } else if (PsiUtil.isIncrementDecrementOperation((PsiElement)element)) {
            PsiExpression operand;
            PsiExpression psiExpression = operand = element instanceof PsiPostfixExpression ? ((PsiPostfixExpression)element).getOperand() : ((PsiPrefixExpression)element).getOperand();
            if (operand instanceof PsiReferenceExpression && ((PsiReferenceExpression)operand).resolve() == variable) {
                return true;
            }
        }
        for (PsiElement child : children = element.getChildren()) {
            if (!VariableAccessFromInnerClassFix.writtenInside(variable, child)) continue;
            return true;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

