/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import org.jetbrains.annotations.NotNull;

public class SuperMethodReturnFix
implements IntentionAction {
    private final PsiType mySuperMethodType;
    private final PsiMethod mySuperMethod;

    public SuperMethodReturnFix(PsiMethod superMethod, PsiType superMethodType) {
        this.mySuperMethodType = superMethodType;
        this.mySuperMethod = superMethod;
    }

    @NotNull
    public String getText() {
        String name = PsiFormatUtil.formatMethod((PsiMethod)this.mySuperMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
        String string = QuickFixBundle.message("fix.super.method.return.type.text", name, HighlightUtil.formatType(this.mySuperMethodType));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.super.method.return.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix.isAvailable must not be null");
        }
        return this.mySuperMethod != null && this.mySuperMethod.isValid() && this.mySuperMethod.getManager().isInProject((PsiElement)this.mySuperMethod) && this.mySuperMethodType != null && this.mySuperMethodType.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.mySuperMethod.getContainingFile())) {
            return;
        }
        ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, this.mySuperMethod, false, null, this.mySuperMethod.getName(), this.mySuperMethodType, ParameterInfoImpl.fromMethod(this.mySuperMethod));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor.run();
        } else {
            processor.run();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

