/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.SideEffectWarningDialog;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoveUnusedVariableFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix");
    private final PsiVariable myVariable;
    private static final Set<String> ourSideEffectFreeClasses = new THashSet();

    public RemoveUnusedVariableFix(PsiVariable variable) {
        this.myVariable = variable;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message(this.myVariable instanceof PsiField ? "remove.unused.field" : "remove.unused.variable", this.myVariable.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.unused.variable.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix.isAvailable must not be null");
        }
        return this.myVariable != null && this.myVariable.isValid() && this.myVariable.getManager().isInProject((PsiElement)this.myVariable);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myVariable.getContainingFile())) {
            return;
        }
        this.removeVariableAndReferencingStatements(editor);
    }

    private static void deleteReferences(PsiVariable variable, List<PsiElement> references, int mode) throws IncorrectOperationException {
        for (PsiElement expression : references) {
            RemoveUnusedVariableFix.processUsage(expression, variable, null, mode);
        }
    }

    private static void collectReferences(@NotNull PsiElement context, final PsiVariable variable, final List<PsiElement> references) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableFix.collectReferences must not be null");
        }
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.resolve() == variable) {
                    references.add(expression);
                }
                super.visitReferenceExpression(expression);
            }
        });
    }

    private void removeVariableAndReferencingStatements(Editor editor) {
        final ArrayList<PsiElement> references = new ArrayList<PsiElement>();
        ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
        boolean[] canCopeWithSideEffects = new boolean[]{true};
        try {
            PsiClass context;
            Object object = context = this.myVariable instanceof PsiField ? ((PsiField)this.myVariable).getContainingClass() : PsiUtil.getVariableCodeBlock((PsiVariable)this.myVariable, null);
            if (context != null) {
                RemoveUnusedVariableFix.collectReferences((PsiElement)context, this.myVariable, references);
            }
            references.add((PsiElement)this.myVariable);
            for (PsiElement element : references) {
                Boolean result = RemoveUnusedVariableFix.processUsage(element, this.myVariable, sideEffects, 0);
                if (result == null) {
                    return;
                }
                canCopeWithSideEffects[0] = canCopeWithSideEffects[0] & result;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        final int deleteMode = RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, this.myVariable, editor, canCopeWithSideEffects[0]);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    RemoveUnusedVariableFix.deleteReferences(RemoveUnusedVariableFix.this.myVariable, references, deleteMode);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public static int showSideEffectsWarning(List<PsiElement> sideEffects, PsiVariable variable, Editor editor, boolean canCopeWithSideEffects, @NonNls String beforeText, @NonNls String afterText) {
        if (sideEffects.isEmpty()) {
            return 2;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return canCopeWithSideEffects ? 1 : 2;
        }
        Project project = editor.getProject();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        PsiElement[] elements = sideEffects.toArray(new PsiElement[sideEffects.size()]);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlights(editor, elements, attributes, true, null);
        SideEffectWarningDialog dialog = new SideEffectWarningDialog(project, false, variable, beforeText, afterText, canCopeWithSideEffects);
        dialog.show();
        return dialog.getExitCode();
    }

    private static int showSideEffectsWarning(List<PsiElement> sideEffects, PsiVariable variable, Editor editor, boolean canCopeWithSideEffects) {
        String text = sideEffects.isEmpty() ? "" : sideEffects.get(0).getText();
        return RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, variable, editor, canCopeWithSideEffects, text, text);
    }

    private static Boolean processUsage(PsiElement element, PsiVariable variable, List<PsiElement> sideEffects, int deleteMode) throws IncorrectOperationException {
        if (!element.isValid()) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory();
        while (element != null) {
            if (element instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression expression = (PsiAssignmentExpression)element;
                PsiExpression lExpression = expression.getLExpression();
                if (!(lExpression instanceof PsiReferenceExpression) || variable != ((PsiReferenceExpression)lExpression).resolve()) {
                    return null;
                }
                PsiExpression rExpression = expression.getRExpression();
                if ((rExpression = PsiUtil.deparenthesizeExpression((PsiExpression)rExpression)) == null) {
                    return true;
                }
                boolean sideEffectFound = RemoveUnusedVariableFix.checkSideEffects((PsiElement)rExpression, variable, sideEffects);
                if (!(element.getParent() instanceof PsiExpressionStatement) || PsiUtil.isStatement((PsiElement)rExpression)) {
                    if (deleteMode == 1 || deleteMode == 2 && !(element.getParent() instanceof PsiExpressionStatement)) {
                        element = RemoveUnusedVariableFix.replaceElementWithExpression(rExpression, factory, element);
                        while (element.getParent() instanceof PsiParenthesizedExpression) {
                            element = element.getParent().replace(element);
                        }
                        ArrayList<PsiElement> references = new ArrayList<PsiElement>();
                        RemoveUnusedVariableFix.collectReferences(element, variable, references);
                        RemoveUnusedVariableFix.deleteReferences(variable, references, deleteMode);
                    } else if (deleteMode == 2) {
                        RemoveUnusedVariableFix.deleteWholeStatement(element, factory);
                    }
                    return true;
                }
                if (deleteMode != 0) {
                    RemoveUnusedVariableFix.deleteWholeStatement(element, factory);
                }
                return !sideEffectFound;
            }
            if (element instanceof PsiExpressionStatement && deleteMode != 0) {
                element.delete();
                break;
            }
            if (element instanceof PsiVariable && element == variable) {
                PsiExpression expression = variable.getInitializer();
                if (expression != null) {
                    expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression);
                }
                boolean sideEffectsFound = RemoveUnusedVariableFix.checkSideEffects((PsiElement)expression, variable, sideEffects);
                if (expression != null && PsiUtil.isStatement((PsiElement)expression) && variable instanceof PsiLocalVariable && (!(variable.getParent() instanceof PsiDeclarationStatement) || ((PsiDeclarationStatement)variable.getParent()).getDeclaredElements().length <= 1)) {
                    if (deleteMode == 1) {
                        element = element.replace(RemoveUnusedVariableFix.createStatementIfNeeded(expression, factory, element));
                        ArrayList<PsiElement> references = new ArrayList<PsiElement>();
                        RemoveUnusedVariableFix.collectReferences(element, variable, references);
                        RemoveUnusedVariableFix.deleteReferences(variable, references, deleteMode);
                    } else if (deleteMode == 2) {
                        element.delete();
                    }
                    return true;
                }
                if (deleteMode != 0) {
                    if (element instanceof PsiField) {
                        ((PsiField)element).normalizeDeclaration();
                    }
                    element.delete();
                }
                return !sideEffectsFound;
            }
            element = element.getParent();
        }
        return true;
    }

    private static void deleteWholeStatement(PsiElement element, PsiElementFactory factory) throws IncorrectOperationException {
        if (element.getParent() instanceof PsiExpressionStatement) {
            PsiExpressionStatement parent = (PsiExpressionStatement)element.getParent();
            if (parent.getParent() instanceof PsiCodeBlock) {
                parent.delete();
            } else {
                parent.replace(RemoveUnusedVariableFix.createStatementIfNeeded(null, factory, element));
            }
        } else {
            element.delete();
        }
    }

    private static PsiElement createStatementIfNeeded(PsiExpression expression, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        if (!(element.getParent() instanceof PsiExpressionStatement) && !(element.getParent() instanceof PsiDeclarationStatement)) {
            return expression;
        }
        return factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
    }

    private static PsiElement replaceElementWithExpression(PsiExpression expression, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        PsiElement elementToReplace = element;
        PsiExpression expressionToReplaceWith = expression;
        if (element.getParent() instanceof PsiExpressionStatement) {
            elementToReplace = element.getParent();
            expressionToReplaceWith = factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
        } else if (element.getParent() instanceof PsiDeclarationStatement) {
            expressionToReplaceWith = factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
        }
        return elementToReplace.replace((PsiElement)expressionToReplaceWith);
    }

    public static boolean checkSideEffects(PsiElement element, PsiVariable variable, List<PsiElement> sideEffects) {
        PsiElement[] children;
        PsiNewExpression newExpression;
        if (sideEffects == null || element == null) {
            return false;
        }
        if (element instanceof PsiMethodCallExpression) {
            sideEffects.add(element);
            return true;
        }
        if (element instanceof PsiNewExpression && (newExpression = (PsiNewExpression)element).getArrayDimensions().length == 0 && newExpression.getArrayInitializer() == null && !RemoveUnusedVariableFix.isSideEffectFreeConstructor(newExpression)) {
            sideEffects.add(element);
            return true;
        }
        if (element instanceof PsiAssignmentExpression && (!(((PsiAssignmentExpression)element).getLExpression() instanceof PsiReferenceExpression) || ((PsiReferenceExpression)((PsiAssignmentExpression)element).getLExpression()).resolve() != variable)) {
            sideEffects.add(element);
            return true;
        }
        for (PsiElement child : children = element.getChildren()) {
            RemoveUnusedVariableFix.checkSideEffects(child, variable, sideEffects);
        }
        return !sideEffects.isEmpty();
    }

    private static boolean isSideEffectFreeConstructor(PsiNewExpression newExpression) {
        PsiClass throwableClass;
        String packageName;
        String qualifiedName;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        PsiClass aClass = classReference == null ? null : (PsiClass)classReference.resolve();
        String string = qualifiedName = aClass == null ? null : aClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (ourSideEffectFreeClasses.contains(qualifiedName)) {
            return true;
        }
        PsiFile file = aClass.getContainingFile();
        PsiDirectory directory = file.getContainingDirectory();
        PsiPackage classPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String string2 = packageName = classPackage == null ? null : classPackage.getQualifiedName();
        return ("java.lang".equals(packageName) || "java.io".equals(packageName)) && (throwableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope())) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)throwableClass, (boolean)true);
    }

    public boolean startInWriteAction() {
        return false;
    }

    static {
        ourSideEffectFreeClasses.add(Object.class.getName());
        ourSideEffectFreeClasses.add(Short.class.getName());
        ourSideEffectFreeClasses.add(Character.class.getName());
        ourSideEffectFreeClasses.add(Byte.class.getName());
        ourSideEffectFreeClasses.add(Integer.class.getName());
        ourSideEffectFreeClasses.add(Long.class.getName());
        ourSideEffectFreeClasses.add(Float.class.getName());
        ourSideEffectFreeClasses.add(Double.class.getName());
        ourSideEffectFreeClasses.add(String.class.getName());
        ourSideEffectFreeClasses.add(StringBuffer.class.getName());
        ourSideEffectFreeClasses.add(Boolean.class.getName());
        ourSideEffectFreeClasses.add(ArrayList.class.getName());
        ourSideEffectFreeClasses.add(Date.class.getName());
        ourSideEffectFreeClasses.add(HashMap.class.getName());
        ourSideEffectFreeClasses.add(HashSet.class.getName());
        ourSideEffectFreeClasses.add(Hashtable.class.getName());
        ourSideEffectFreeClasses.add(LinkedHashMap.class.getName());
        ourSideEffectFreeClasses.add(LinkedHashSet.class.getName());
        ourSideEffectFreeClasses.add(LinkedList.class.getName());
        ourSideEffectFreeClasses.add(Stack.class.getName());
        ourSideEffectFreeClasses.add(TreeMap.class.getName());
        ourSideEffectFreeClasses.add(TreeSet.class.getName());
        ourSideEffectFreeClasses.add(Vector.class.getName());
        ourSideEffectFreeClasses.add(WeakHashMap.class.getName());
    }
}

