/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveRedundantElseAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.RemoveRedundantElseAction");

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("remove.redundant.else.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.redundant.else.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction.isAvailable must not be null");
        }
        if (element instanceof PsiKeyword && element.getParent() instanceof PsiIfStatement && "else".equals(element.getText())) {
            PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
            if (ifStatement.getElseBranch() == null) {
                return false;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return false;
            }
            PsiElement block = PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiCodeBlock.class);
            if (block != null) {
                try {
                    ControlFlow controlFlow = ControlFlowFactory.getInstance(project).getControlFlow(block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                    int startOffset = controlFlow.getStartOffset((PsiElement)thenBranch);
                    int endOffset = controlFlow.getEndOffset((PsiElement)thenBranch);
                    return startOffset != -1 && endOffset != -1 && !ControlFlowUtil.canCompleteNormally(controlFlow, startOffset, endOffset);
                }
                catch (AnalysisCanceledException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
        PsiIfStatement ifStatement = (PsiIfStatement)elementAt.getParent();
        LOG.assertTrue(ifStatement != null && ifStatement.getElseBranch() != null);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch instanceof PsiBlockStatement) {
            PsiStatement[] statements = ((PsiBlockStatement)elseBranch).getCodeBlock().getStatements();
            if (statements.length > 0) {
                ifStatement.getParent().addRangeAfter((PsiElement)statements[0], (PsiElement)statements[statements.length - 1], (PsiElement)ifStatement);
            }
        } else {
            ifStatement.getParent().addAfter((PsiElement)elseBranch, (PsiElement)ifStatement);
        }
        ifStatement.getElseBranch().delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

