/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveQualifierFix
implements IntentionAction {
    private final PsiExpression myQualifier;
    private final PsiReferenceExpression myExpression;
    private final PsiClass myResolved;

    public RemoveQualifierFix(PsiExpression qualifier, PsiReferenceExpression expression, PsiClass resolved) {
        this.myQualifier = qualifier;
        this.myExpression = expression;
        this.myResolved = resolved;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("remove.qualifier.action.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix.isAvailable must not be null");
        }
        return this.myQualifier != null && this.myQualifier.isValid() && this.myQualifier.getManager().isInProject((PsiElement)this.myQualifier) && this.myExpression != null && this.myExpression.isValid() && this.myResolved != null && this.myResolved.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/RemoveQualifierFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        this.myQualifier.delete();
        this.myExpression.bindToElement((PsiElement)this.myResolved);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

