/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MoveBoundClassToFrontFix
extends ExtendsListFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MoveBoundClassToFrontFix");

    public MoveBoundClassToFrontFix(PsiClass aClass, PsiClassType classToExtendFrom) {
        super(aClass, classToExtendFrom, true);
    }

    @Override
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("move.bound.class.to.front.fix.text", HighlightUtil.formatClass(this.myClassToExtendFrom), HighlightUtil.formatClass(this.myClass));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MoveBoundClassToFrontFix.getText must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.class.in.extend.list.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MoveBoundClassToFrontFix.getFamilyName must not return null");
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MoveBoundClassToFrontFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myClass.getContainingFile())) {
            return;
        }
        PsiReferenceList extendsList = this.myClass.getExtendsList();
        if (extendsList == null) {
            return;
        }
        try {
            this.modifyList(extendsList, false, -1);
            this.modifyList(extendsList, true, 0);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        UndoUtil.markPsiFileForUndo((PsiFile)file);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MoveBoundClassToFrontFix.isAvailable must not be null");
        }
        return this.myClass != null && this.myClass.isValid() && this.myClass.getManager().isInProject((PsiElement)this.myClass) && this.myClassToExtendFrom != null && this.myClassToExtendFrom.isValid();
    }
}

