/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BringVariableIntoScopeFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.BringVariableIntoScopeFix");
    private final PsiReferenceExpression myUnresolvedReference;
    private PsiLocalVariable myOutOfScopeVariable;

    public BringVariableIntoScopeFix(PsiReferenceExpression unresolvedReference) {
        this.myUnresolvedReference = unresolvedReference;
    }

    @NotNull
    public String getText() {
        PsiLocalVariable variable = this.myOutOfScopeVariable;
        String varText = variable == null ? "" : PsiFormatUtil.formatVariable((PsiVariable)variable, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        String string = QuickFixBundle.message("bring.variable.to.scope.text", varText);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/BringVariableIntoScopeFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("bring.variable.to.scope.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/BringVariableIntoScopeFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/BringVariableIntoScopeFix.isAvailable must not be null");
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (this.myUnresolvedReference.isQualified()) {
            return false;
        }
        final String referenceName = this.myUnresolvedReference.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        PsiManager manager = file.getManager();
        if (!this.myUnresolvedReference.isValid() || !manager.isInProject((PsiElement)this.myUnresolvedReference)) {
            return false;
        }
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)this.myUnresolvedReference, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class});
        if (!(container instanceof PsiCodeBlock)) {
            return false;
        }
        this.myOutOfScopeVariable = null;
        while (container.getParent() instanceof PsiStatement || container.getParent() instanceof PsiCatchSection) {
            container = container.getParent();
        }
        container.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitExpression(PsiExpression expression) {
            }

            public void visitLocalVariable(PsiLocalVariable variable) {
                if (referenceName.equals(variable.getName())) {
                    if (BringVariableIntoScopeFix.this.myOutOfScopeVariable == null) {
                        BringVariableIntoScopeFix.this.myOutOfScopeVariable = variable;
                    } else {
                        BringVariableIntoScopeFix.this.myOutOfScopeVariable = null;
                    }
                }
            }
        });
        return this.myOutOfScopeVariable != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiLocalVariable child;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/BringVariableIntoScopeFix.invoke must not be null");
        }
        LOG.assertTrue(this.myOutOfScopeVariable != null);
        PsiManager manager = file.getManager();
        PsiUtil.setModifierProperty((PsiModifierListOwner)this.myOutOfScopeVariable, (String)"final", (boolean)false);
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)this.myOutOfScopeVariable, (PsiElement)this.myUnresolvedReference);
        LOG.assertTrue(commonParent != null);
        Object object = child = this.myOutOfScopeVariable.getTextRange().getStartOffset() < this.myUnresolvedReference.getTextRange().getStartOffset() ? this.myOutOfScopeVariable : this.myUnresolvedReference;
        while (child.getParent() != commonParent) {
            child = child.getParent();
        }
        PsiDeclarationStatement newDeclaration = (PsiDeclarationStatement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createStatementFromText("int i = 0", null);
        PsiVariable variable = (PsiVariable)newDeclaration.getDeclaredElements()[0].replace((PsiElement)this.myOutOfScopeVariable);
        if (variable.getInitializer() != null) {
            variable.getInitializer().delete();
        }
        while (!(child instanceof PsiStatement) || !(child.getParent() instanceof PsiCodeBlock)) {
            child = child.getParent();
            commonParent = commonParent.getParent();
        }
        LOG.assertTrue(commonParent != null);
        PsiDeclarationStatement added = (PsiDeclarationStatement)commonParent.addBefore((PsiElement)newDeclaration, (PsiElement)child);
        PsiLocalVariable addedVar = (PsiLocalVariable)added.getDeclaredElements()[0];
        manager.getCodeStyleManager().reformat(commonParent);
        PsiExpression initializer = this.myOutOfScopeVariable.getInitializer();
        if (initializer != null) {
            PsiExpressionStatement assignment = (PsiExpressionStatement)JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createStatementFromText(this.myOutOfScopeVariable.getName() + "= e;", null);
            ((PsiAssignmentExpression)assignment.getExpression()).getRExpression().replace((PsiElement)initializer);
            assignment = (PsiExpressionStatement)manager.getCodeStyleManager().reformat((PsiElement)assignment);
            PsiDeclarationStatement declStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myOutOfScopeVariable, PsiDeclarationStatement.class);
            LOG.assertTrue(declStatement != null);
            PsiElement parent = declStatement.getParent();
            if (parent instanceof PsiForStatement) {
                declStatement.replace((PsiElement)assignment);
            } else {
                parent.addAfter((PsiElement)assignment, (PsiElement)declStatement);
            }
        }
        if (this.myOutOfScopeVariable.isValid()) {
            this.myOutOfScopeVariable.delete();
        }
        if (HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(this.myUnresolvedReference, (PsiVariable)addedVar, (Map<PsiElement, Collection<PsiReferenceExpression>>)new THashMap()) != null) {
            BringVariableIntoScopeFix.initialize(addedVar);
        }
        DaemonCodeAnalyzer.getInstance((Project)project).updateVisibleHighlighters(editor);
    }

    private static void initialize(PsiLocalVariable variable) throws IncorrectOperationException {
        PsiType type = variable.getType();
        String init = PsiTypesUtil.getDefaultValueOfType((PsiType)type);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory();
        PsiExpression initializer = factory.createExpressionFromText(init, (PsiElement)variable);
        variable.setInitializer(initializer);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

