/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AddMethodFix
extends IntentionAndQuickFixAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddMethodFix");
    private final PsiClass myClass;
    private final PsiMethod myMethod;
    private String myText;
    private final List<String> myExceptions;

    public AddMethodFix(@NotNull PsiMethod method, @NotNull PsiClass implClass) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix.<init> must not be null");
        }
        if (implClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix.<init> must not be null");
        }
        this.myExceptions = new ArrayList<String>();
        this.myMethod = method;
        this.myClass = implClass;
        this.setText(QuickFixBundle.message("add.method.text", method.getName(), implClass.getName()));
    }

    public AddMethodFix(@NonNls @NotNull String methodText, @NotNull PsiClass implClass, String ... exceptions) {
        if (methodText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix.<init> must not be null");
        }
        if (implClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix.<init> must not be null");
        }
        if (exceptions == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix.<init> must not be null");
        }
        this(AddMethodFix.createMethod(methodText, implClass), implClass);
        this.myExceptions.addAll(Arrays.asList(exceptions));
    }

    private static PsiMethod createMethod(String methodText, PsiClass implClass) {
        try {
            return JavaPsiFacade.getInstance((Project)implClass.getProject()).getElementFactory().createMethodFromText(methodText, (PsiElement)implClass);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiMethod reformat(Project project, PsiMethod result) throws IncorrectOperationException {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        result = (PsiMethod)codeStyleManager.reformat((PsiElement)result);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        result = (PsiMethod)javaCodeStyleManager.shortenClassReferences((PsiElement)result);
        return result;
    }

    protected void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix.setText must not be null");
        }
        this.myText = text;
    }

    @NotNull
    public String getName() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.method.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/AddMethodFix.isAvailable must not be null");
        }
        return this.myMethod != null && this.myMethod.isValid() && this.myClass != null && this.myClass.isValid() && this.myClass.getManager().isInProject((PsiElement)this.myClass) && this.myText != null && MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (PsiMethod)this.myMethod, (boolean)false) == null;
    }

    public void applyFix(Project project, PsiFile file, Editor editor) {
        PsiCodeBlock body;
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myClass.getContainingFile())) {
            return;
        }
        if (this.myClass.isInterface() && (body = this.myMethod.getBody()) != null) {
            body.delete();
        }
        for (String exception : this.myExceptions) {
            PsiUtil.addException((PsiMethod)this.myMethod, (String)exception);
        }
        PsiMethod method = (PsiMethod)this.myClass.add((PsiElement)this.myMethod);
        method = (PsiMethod)method.replace((PsiElement)AddMethodFix.reformat(project, method));
        if (editor != null) {
            GenerateMembersUtil.positionCaret(editor, (PsiElement)method, true);
        }
    }
}

