/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.PerThreadMap;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHighlightVisitor
extends PsiElementVisitor
implements HighlightVisitor,
DumbAware {
    private final AnnotationHolderImpl myAnnotationHolder = new AnnotationHolderImpl();
    private HighlightInfoHolder myHolder;
    public static final ExtensionPointName<HighlightErrorFilter> FILTER_EP_NAME = ExtensionPointName.create((String)"com.intellij.highlightErrorFilter");
    private final HighlightErrorFilter[] myErrorFilters;
    private final Project myProject;
    private static final PerThreadMap<Annotator, Language> cachedAnnotators = new PerThreadMap<Annotator, Language>(){

        @Override
        @NotNull
        public Collection<Annotator> initialValue(@NotNull Language key) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/DefaultHighlightVisitor$1.initialValue must not be null");
            }
            List list = LanguageAnnotators.INSTANCE.allForLanguage(key);
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/DefaultHighlightVisitor$1.initialValue must not return null");
            }
            return list;
        }
    };

    public DefaultHighlightVisitor(Project project) {
        this.myProject = project;
        this.myErrorFilters = (HighlightErrorFilter[])Extensions.getExtensions(FILTER_EP_NAME, (AreaInstance)project);
    }

    @Override
    public boolean suitableForFile(PsiFile file) {
        return true;
    }

    @Override
    public void visit(PsiElement element, HighlightInfoHolder holder) {
        this.myHolder = holder;
        assert (!this.myAnnotationHolder.hasAnnotations()) : this.myAnnotationHolder;
        element.accept((PsiElementVisitor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(Runnable action, boolean updateWholeFile, PsiFile file) {
        try {
            action.run();
        }
        finally {
            this.myAnnotationHolder.clear();
            this.myHolder = null;
        }
        return true;
    }

    @Override
    public HighlightVisitor clone() {
        return new DefaultHighlightVisitor(this.myProject);
    }

    @Override
    public int order() {
        return 2;
    }

    public void visitElement(PsiElement element) {
        this.runAnnotators(element);
    }

    private void runAnnotators(PsiElement element) {
        List<Annotator> annotators = cachedAnnotators.get(element.getLanguage());
        if (!annotators.isEmpty()) {
            boolean dumb = DumbService.getInstance((Project)this.myProject).isDumb();
            for (int i = 0; i < annotators.size(); ++i) {
                Annotator annotator = annotators.get(i);
                if (dumb && !(annotator instanceof DumbAware)) continue;
                annotator.annotate(element, (AnnotationHolder)this.myAnnotationHolder);
            }
            if (this.myAnnotationHolder.hasAnnotations()) {
                Iterator i$ = this.myAnnotationHolder.iterator();
                while (i$.hasNext()) {
                    Annotation annotation = (Annotation)i$.next();
                    this.myHolder.add(HighlightInfo.fromAnnotation(annotation));
                }
                this.myAnnotationHolder.clear();
            }
        }
    }

    public void visitErrorElement(PsiErrorElement element) {
        for (HighlightErrorFilter errorFilter : this.myErrorFilters) {
            if (errorFilter.shouldHighlightErrorElement(element)) continue;
            return;
        }
        HighlightInfo info = DefaultHighlightVisitor.createErrorElementInfo(element);
        this.myHolder.add(info);
    }

    public static HighlightInfo createErrorElementInfo(PsiErrorElement element) {
        HighlightInfo info;
        String text;
        TextRange range = element.getTextRange();
        if (!range.isEmpty()) {
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, range, element.getErrorDescription());
            for (ErrorQuickFixProvider provider : (ErrorQuickFixProvider[])Extensions.getExtensions(ErrorQuickFixProvider.EP_NAME)) {
                provider.registerErrorQuickFix(element, highlightInfo);
            }
            return highlightInfo;
        }
        int offset = range.getStartOffset();
        PsiFile containingFile = element.getContainingFile();
        int fileLength = containingFile.getTextLength();
        FileViewProvider viewProvider = containingFile.getViewProvider();
        PsiElement elementAtOffset = viewProvider.findElementAt(offset, viewProvider.getBaseLanguage());
        String string = text = elementAtOffset == null ? null : elementAtOffset.getText();
        if (offset < fileLength && text != null && !StringUtil.startsWithChar((CharSequence)text, (char)'\n') && !StringUtil.startsWithChar((CharSequence)text, (char)'\r')) {
            info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, offset, offset + 1, element.getErrorDescription());
        } else {
            int end;
            int start;
            if (offset > 0) {
                start = offset;
                end = offset;
            } else {
                start = offset;
                end = offset < fileLength ? offset + 1 : offset;
            }
            info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)element, start, end, element.getErrorDescription(), element.getErrorDescription(), true, null);
        }
        return info;
    }

    static {
        LanguageAnnotators.INSTANCE.addListener((ExtensionPointListener)new ExtensionPointListener<Annotator>(){

            public void extensionAdded(Annotator extension, @Nullable PluginDescriptor pluginDescriptor) {
                cachedAnnotators.clear();
            }

            public void extensionRemoved(Annotator extension, @Nullable PluginDescriptor pluginDescriptor) {
                cachedAnnotators.clear();
            }
        });
    }
}

