/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.WolfHighlightingPass;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private long myPsiModificationCount;

    public WolfPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, new int[]{7}, false, 9);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("WolfPassFactory" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/WolfPassFactory.getComponentName must not return null");
        }
        return "WolfPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/WolfPassFactory.createHighlightingPass must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/WolfPassFactory.createHighlightingPass must not be null");
        }
        final long psiModificationCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        if (psiModificationCount == this.myPsiModificationCount) {
            return null;
        }
        return new WolfHighlightingPass(this.myProject, editor.getDocument(), file){

            @Override
            protected void applyInformationWithProgress() {
                super.applyInformationWithProgress();
                WolfPassFactory.this.myPsiModificationCount = psiModificationCount;
            }
        };
    }
}

