/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkersPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public LineMarkersPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{10}, new int[]{4}, false, 11);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("LineMarkersPassFactory" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/LineMarkersPassFactory.getComponentName must not return null");
        }
        return "LineMarkersPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPassFactory.createHighlightingPass must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/LineMarkersPassFactory.createHighlightingPass must not be null");
        }
        TextRange textRange = LineMarkersPassFactory.calculateRangeToProcessForSyntaxPass(editor);
        if (textRange == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(this.myProject, editor.getDocument(), GeneralHighlightingPass.IN_PROGRESS_ICON, GeneralHighlightingPass.PRESENTABLE_NAME);
        }
        return new LineMarkersPass(this.myProject, file, editor.getDocument(), textRange.getStartOffset(), textRange.getEndOffset(), true);
    }

    @Nullable
    static TextRange calculateRangeToProcessForSyntaxPass(Editor editor) {
        return FileStatusMap.getDirtyTextRange(editor, 4);
    }
}

