/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.CodeFoldingPass;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

class InjectedCodeFoldingPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final Key<Boolean> THE_FIRST_TIME_KEY = Key.create((String)"FirstInjectedFoldingPass");
    private Runnable myRunnable;
    private final Editor myEditor;
    private final PsiFile myFile;

    InjectedCodeFoldingPass(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/InjectedCodeFoldingPass.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/InjectedCodeFoldingPass.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/InjectedCodeFoldingPass.<init> must not be null");
        }
        super(project, editor.getDocument(), false);
        this.myEditor = editor;
        this.myFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCollectInformation(ProgressIndicator progress) {
        boolean firstTime = CodeFoldingPass.isFirstTime(this.myFile, this.myEditor, THE_FIRST_TIME_KEY);
        Runnable runnable = FoldingUpdate.updateInjectedFoldRegions(this.myEditor, this.myFile, firstTime);
        InjectedCodeFoldingPass injectedCodeFoldingPass = this;
        synchronized (injectedCodeFoldingPass) {
            this.myRunnable = runnable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doApplyInformationToEditor() {
        Runnable runnable;
        InjectedCodeFoldingPass injectedCodeFoldingPass = this;
        synchronized (injectedCodeFoldingPass) {
            runnable = this.myRunnable;
        }
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            CodeFoldingPass.clearFirstTimeFlag(this.myFile, this.myEditor, THE_FIRST_TIME_KEY);
        }
    }
}

