/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlighingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nullable;

public class HectorComponent
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.editor.impl.HectorComponent");
    private WeakReference<JBPopup> myHectorRef;
    private final ArrayList<HectorComponentPanel> myAdditionalPanels;
    private final Map<Language, JSlider> mySliders;
    private final PsiFile myFile;
    private final String myTitle = EditorBundle.message((String)"hector.highlighting.level.title", (Object[])new Object[0]);

    public HectorComponent(PsiFile file) {
        super(new GridBagLayout());
        boolean addLabel;
        this.myFile = file;
        this.mySliders = new HashMap<Language, JSlider>();
        Project project = this.myFile.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = this.myFile.getContainingFile().getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        boolean notInLibrary = !fileIndex.isInLibrarySource(virtualFile) && !fileIndex.isInLibraryClasses(virtualFile) || fileIndex.isInContent(virtualFile);
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set languages = viewProvider.getLanguages();
        for (Language language : languages) {
            final Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            sliderLabels.put(1, new JLabel(EditorBundle.message((String)"hector.none.slider.label", (Object[])new Object[0])));
            sliderLabels.put(2, new JLabel(EditorBundle.message((String)"hector.syntax.slider.label", (Object[])new Object[0])));
            if (notInLibrary) {
                sliderLabels.put(3, new JLabel(EditorBundle.message((String)"hector.inspections.slider.label", (Object[])new Object[0])));
            }
            final JSlider slider = new JSlider(1, 1, notInLibrary ? 3 : 2, 1);
            slider.setLabelTable(sliderLabels);
            boolean value = true;
            UIUtil.setSliderIsFilled((JSlider)slider, (boolean)true);
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = slider.getValue();
                    Enumeration enumeration = sliderLabels.keys();
                    while (enumeration.hasMoreElements()) {
                        Integer key = (Integer)enumeration.nextElement();
                        ((JLabel)sliderLabels.get(key)).setForeground(key <= value ? Color.black : new Color(100, 100, 100));
                    }
                }
            });
            PsiFile psiRoot = viewProvider.getPsi(language);
            slider.setValue(HectorComponent.getValue(HighlightLevelUtil.shouldHighlight((PsiElement)psiRoot), HighlightLevelUtil.shouldInspect((PsiElement)psiRoot)));
            this.mySliders.put(language, slider);
        }
        DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)this.myFile.getProject());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)this.myTitle));
        boolean bl = addLabel = this.mySliders.size() > 1;
        if (addLabel) {
            this.layoutVertical(panel);
        } else {
            this.layoutHorizontal(panel);
        }
        gc.gridx = 0;
        gc.gridy = 2;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)panel, gc);
        gc.gridy = -1;
        gc.weighty = 0.0;
        HyperlinkLabel configurator = new HyperlinkLabel("Configure inspections");
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 13;
        this.add((Component)configurator, gc);
        configurator.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                JBPopup hector = HectorComponent.this.getOldHector();
                if (hector != null) {
                    hector.cancel();
                }
                if (!DaemonCodeAnalyzer.getInstance((Project)HectorComponent.this.myFile.getProject()).isHighlightingAvailable(HectorComponent.this.myFile)) {
                    return;
                }
                Project project = HectorComponent.this.myFile.getProject();
                ErrorsConfigurable errorsConfigurable = ErrorsConfigurable.SERVICE.getInstance(project);
                assert (errorsConfigurable != null);
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)errorsConfigurable);
            }
        });
        gc.anchor = 17;
        this.myAdditionalPanels = new ArrayList();
        for (HectorComponentPanelsProvider provider : (HectorComponentPanelsProvider[])Extensions.getExtensions((ExtensionPointName)HectorComponentPanelsProvider.EP_NAME, (AreaInstance)project)) {
            HectorComponentPanel componentPanel = provider.createConfigurable(file);
            if (componentPanel == null) continue;
            this.myAdditionalPanels.add(componentPanel);
            this.add((Component)componentPanel.createComponent(), gc);
            componentPanel.reset();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        int width = this.getFontMetrics(this.getFont()).stringWidth(this.myTitle) + 60;
        if (preferredSize.width < width) {
            preferredSize.width = width;
        }
        return preferredSize;
    }

    private void layoutHorizontal(JPanel panel) {
        for (JSlider slider : this.mySliders.values()) {
            slider.setOrientation(0);
            slider.setPreferredSize(new Dimension(200, 40));
            panel.add((Component)slider, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private void layoutVertical(JPanel panel) {
        for (Language language : this.mySliders.keySet()) {
            JSlider slider = this.mySliders.get(language);
            JPanel borderPanel = new JPanel(new BorderLayout());
            slider.setPreferredSize(new Dimension(80, 100));
            borderPanel.add((Component)new JLabel(language.getID()), "North");
            borderPanel.add((Component)slider, "Center");
            panel.add((Component)borderPanel, new GridBagConstraints(-1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void showComponent(RelativePoint point) {
        JBPopup hector = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, (JComponent)this).setRequestFocus(true).setMovable(true).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                for (HectorComponentPanel additionalPanel : HectorComponent.this.myAdditionalPanels) {
                    if (additionalPanel.canClose()) continue;
                    return Boolean.FALSE;
                }
                HectorComponent.this.onClose();
                return Boolean.TRUE;
            }
        }).createPopup();
        JBPopup oldHector = this.getOldHector();
        if (oldHector != null) {
            oldHector.cancel();
        } else {
            this.myHectorRef = new WeakReference<JBPopup>(hector);
            hector.show(point);
        }
    }

    @Nullable
    private JBPopup getOldHector() {
        if (this.myHectorRef == null) {
            return null;
        }
        JBPopup hector = (JBPopup)this.myHectorRef.get();
        if (hector == null || !hector.isVisible()) {
            this.myHectorRef = null;
            return null;
        }
        return hector;
    }

    private void onClose() {
        if (this.isModified()) {
            for (HectorComponentPanel panel : this.myAdditionalPanels) {
                try {
                    panel.apply();
                }
                catch (ConfigurationException configurationException) {}
            }
            this.forceDaemonRestart();
            InspectionProjectProfileManager.getInstance(this.myFile.getProject()).updateStatusBar();
        }
    }

    private void forceDaemonRestart() {
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        for (Language language : this.mySliders.keySet()) {
            JSlider slider = this.mySliders.get(language);
            PsiFile root = viewProvider.getPsi(language);
            int value = slider.getValue();
            if (value == 1) {
                HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlighingSetting.SKIP_HIGHLIGHTING);
                continue;
            }
            if (value == 2) {
                HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlighingSetting.SKIP_INSPECTION);
                continue;
            }
            HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlighingSetting.FORCE_HIGHLIGHTING);
        }
        DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)this.myFile.getProject());
        analyzer.restart();
    }

    private boolean isModified() {
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        for (Language language : this.mySliders.keySet()) {
            JSlider slider = this.mySliders.get(language);
            PsiFile root = viewProvider.getPsi(language);
            if (HectorComponent.getValue(HighlightLevelUtil.shouldHighlight((PsiElement)root), HighlightLevelUtil.shouldInspect((PsiElement)root)) == slider.getValue()) continue;
            return true;
        }
        for (HectorComponentPanel panel : this.myAdditionalPanels) {
            if (!panel.isModified()) continue;
            return true;
        }
        return false;
    }

    private static int getValue(boolean isSyntaxHighlightingEnabled, boolean isInspectionsHighlightingEnabled) {
        if (!isSyntaxHighlightingEnabled && !isInspectionsHighlightingEnabled) {
            return 1;
        }
        if (isSyntaxHighlightingEnabled && !isInspectionsHighlightingEnabled) {
            return 2;
        }
        return 3;
    }
}

