/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeEditor.JavaEditorFileSwapper;
import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.PathUIUtils;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.GuiUtils;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class AttachSourcesNotificationProvider
implements EditorNotifications.Provider<EditorNotificationPanel> {
    private static final ExtensionPointName<AttachSourcesProvider> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.attachSourcesProvider");
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"add sources to class");
    private final Project myProject;

    public AttachSourcesNotificationProvider(Project project, final EditorNotifications notifications) {
        this.myProject = project;
        this.myProject.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                notifications.updateAllNotifications();
            }
        });
    }

    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(final VirtualFile file) {
        if (file.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        final Library library = this.findLibrary(file);
        if (library == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        final String fqn = JavaEditorFileSwapper.getFQN(psiFile);
        if (fqn == null) {
            return null;
        }
        if (JavaEditorFileSwapper.findSourceFile(this.myProject, file) != null) {
            return null;
        }
        final EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(ProjectBundle.message((String)"library.sources.not.found", (Object[])new Object[0]));
        final AttachSourcesProvider.AttachSourcesAction defaultAction = this.createDefaultAction(library, file);
        TreeSet<AttachSourcesProvider.AttachSourcesAction> actions = new TreeSet<AttachSourcesProvider.AttachSourcesAction>(new Comparator<AttachSourcesProvider.AttachSourcesAction>(){

            @Override
            public int compare(AttachSourcesProvider.AttachSourcesAction o1, AttachSourcesProvider.AttachSourcesAction o2) {
                if (o1 == defaultAction) {
                    return 1;
                }
                if (o2 == defaultAction) {
                    return -1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        actions.add(defaultAction);
        for (AttachSourcesProvider each : (AttachSourcesProvider[])Extensions.getExtensions(EXTENSION_POINT_NAME)) {
            actions.addAll(each.getActions(library, psiFile));
        }
        for (final AttachSourcesProvider.AttachSourcesAction each : actions) {
            panel.createActionLabel(GuiUtils.getTextWithoutMnemonicEscaping((String)each.getName()), new Runnable(){

                @Override
                public void run() {
                    if (library != AttachSourcesNotificationProvider.this.findLibrary(file)) {
                        Messages.showErrorDialog((Project)AttachSourcesNotificationProvider.this.myProject, (String)("Cannot find library for " + StringUtil.getShortName((String)fqn)), (String)"Error");
                        return;
                    }
                    panel.setText(each.getBusyText());
                    Runnable onFinish = new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    panel.setText(ProjectBundle.message((String)"library.sources.not.found", (Object[])new Object[0]));
                                }
                            });
                        }
                    };
                    ActionCallback callback = each.perform();
                    callback.doWhenRejected(onFinish);
                    callback.doWhenDone(onFinish);
                }
            });
        }
        return panel;
    }

    private AttachSourcesProvider.AttachSourcesAction createDefaultAction(final Library library, final VirtualFile file) {
        return new AttachSourcesProvider.AttachSourcesAction(){

            public String getName() {
                return ProjectBundle.message((String)"module.libraries.attach.sources.button", (Object[])new Object[0]);
            }

            public String getBusyText() {
                return ProjectBundle.message((String)"library.attach.sources.action.busy.text", (Object[])new Object[0]);
            }

            public ActionCallback perform() {
                FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, true, false, true, true);
                descriptor.setTitle(ProjectBundle.message((String)"library.attach.sources.action", (Object[])new Object[0]));
                descriptor.setDescription(ProjectBundle.message((String)"library.attach.sources.description", (Object[])new Object[0]));
                VirtualFile[] roots = library.getFiles(OrderRootType.CLASSES);
                VirtualFile[] candidates = FileChooser.chooseFiles((Project)AttachSourcesNotificationProvider.this.myProject, (FileChooserDescriptor)descriptor, roots.length == 0 ? null : roots[0]);
                final VirtualFile[] files = PathUIUtils.scanAndSelectDetectedJavaSourceRoots(AttachSourcesNotificationProvider.this.myProject, candidates);
                if (files.length == 0) {
                    return new ActionCallback.Rejected();
                }
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Library library = AttachSourcesNotificationProvider.this.findLibrary(file);
                        assert (library != null);
                        Library.ModifiableModel model = library.getModifiableModel();
                        for (VirtualFile virtualFile : files) {
                            model.addRoot(virtualFile, OrderRootType.SOURCES);
                        }
                        model.commit();
                    }
                });
                return new ActionCallback.Done();
            }
        };
    }

    @Nullable
    private Library findLibrary(VirtualFile file) {
        List entries = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getOrderEntriesForFile(file);
        for (OrderEntry entry : entries) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            return ((LibraryOrderEntry)entry).getLibrary();
        }
        return null;
    }
}

