/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.DummyIdentifierPatcher;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.completion.FileCopyPatcher;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.completion.XmlCompletionData;
import com.intellij.codeInsight.lookup.InsertHandlerDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlCompletionContributor
extends CompletionContributor {
    public static final Key<Boolean> WORD_COMPLETION_COMPATIBLE = Key.create((String)"WORD_COMPLETION_COMPATIBLE");
    @NonNls
    public static final String TAG_NAME_COMPLETION_FEATURE = "tag.name.completion";
    private static final InsertHandlerDecorator<LookupElement> QUOTE_EATER = new InsertHandlerDecorator<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
            char completionChar = context.getCompletionChar();
            if (completionChar == '\'' || completionChar == '\"') {
                char c;
                context.setAddCompletionChar(false);
                item.getDelegate().handleInsert(context);
                Editor editor = context.getEditor();
                Document document = editor.getDocument();
                int tailOffset = editor.getCaretModel().getOffset();
                if (document.getTextLength() > tailOffset && ((c = document.getCharsSequence().charAt(tailOffset)) == completionChar || completionChar == '\'')) {
                    editor.getCaretModel().moveToOffset(tailOffset + 1);
                }
            } else {
                item.getDelegate().handleInsert(context);
            }
        }
    };

    public XmlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)XmlPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttributeValue()), (CompletionProvider)new CompletionProvider<CompletionParameters>(false){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/XmlCompletionContributor$2.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/XmlCompletionContributor$2.addCompletions must not be null");
                }
                final XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlAttributeValue.class, (boolean)false);
                if (attributeValue == null) {
                    return;
                }
                THashSet usedWords = new THashSet();
                final Ref addWordVariants = Ref.create((Object)true);
                result.runRemainingContributors(parameters, (Consumer)new Consumer<LookupElement>((Set)usedWords, result){
                    final /* synthetic */ Set val$usedWords;
                    final /* synthetic */ CompletionResultSet val$result;
                    {
                        this.val$usedWords = set;
                        this.val$result = completionResultSet;
                    }

                    public void consume(LookupElement element) {
                        if (element.getUserData(WORD_COMPLETION_COMPATIBLE) == null) {
                            addWordVariants.set((Object)false);
                        }
                        this.val$usedWords.add(element.getLookupString());
                        this.val$result.addElement((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)element, (InsertHandler)QUOTE_EATER));
                    }
                });
                if (((Boolean)addWordVariants.get()).booleanValue()) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            addWordVariants.set((Object)(attributeValue.getReferences().length == 0 ? 1 : 0));
                        }
                    });
                }
                if (((Boolean)addWordVariants.get()).booleanValue()) {
                    WordCompletionContributor.addWordCompletionVariants(result, parameters, (Set<String>)usedWords);
                }
            }
        });
    }

    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        block8: {
            super.fillCompletionVariants(parameters, result);
            if (result.isStopped()) {
                return;
            }
            PsiElement element = parameters.getPosition();
            if (parameters.getCompletionType() != CompletionType.CLASS_NAME) break block8;
            if (!XmlCompletionContributor.isXmlNameCompletion(parameters)) {
                return;
            }
            result.stopHere();
            if (!(element.getParent() instanceof XmlTag)) {
                return;
            }
            final XmlTag parent = (XmlTag)element.getParent();
            String namespace = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return parent.getNamespace();
                }
            });
            XmlElementDescriptor parentDescriptor = (XmlElementDescriptor)ApplicationManager.getApplication().runReadAction((Computable)new Computable<XmlElementDescriptor>(){

                public XmlElementDescriptor compute() {
                    return parent.getDescriptor();
                }
            });
            String prefix = result.getPrefixMatcher().getPrefix();
            int pos = prefix.indexOf(58);
            String namespacePrefix = pos > 0 ? prefix.substring(0, pos) : null;
            PsiReference reference = (PsiReference)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiReference>(){

                public PsiReference compute() {
                    return parent.getReference();
                }
            });
            if (reference != null && namespace.length() > 0 && parentDescriptor != null && !(parentDescriptor instanceof AnyXmlElementDescriptor)) {
                HashSet<LookupElement> set = new HashSet<LookupElement>();
                new XmlCompletionData().completeReference(reference, set, element, parameters.getOriginalFile(), parameters.getOffset());
                for (LookupElement item : set) {
                    result.addElement(item);
                }
            } else {
                CompletionResultSet newResult = result.withPrefixMatcher(pos >= 0 ? prefix.substring(pos + 1) : prefix);
                final XmlFile file = (XmlFile)parameters.getOriginalFile();
                List names = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<Pair<String, String>>>(){

                    public List<Pair<String, String>> compute() {
                        return XmlExtension.getExtension((PsiFile)file).getAvailableTagNames(file, parent);
                    }
                });
                for (Pair pair : names) {
                    final String name = (String)pair.getFirst();
                    final String ns = (String)pair.getSecond();
                    LookupItem<String> item = new LookupItem<String>(name, name){

                        @Override
                        public int hashCode() {
                            int hashCode = name.hashCode() * 239;
                            return ns == null ? hashCode : hashCode + ns.hashCode();
                        }
                    };
                    ExtendedTagInsertHandler insertHandler = new ExtendedTagInsertHandler(name, ns, namespacePrefix);
                    item.setInsertHandler(insertHandler);
                    if (!StringUtil.isEmpty((String)ns)) {
                        item.setAttribute(LookupItem.TAIL_TEXT_ATTR, (Object)(" (" + ns + ")"));
                        item.setAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR, (Object)"");
                    }
                    newResult.addElement((LookupElement)item);
                }
            }
        }
    }

    private static boolean isXmlNameCompletion(CompletionParameters parameters) {
        ASTNode node = parameters.getPosition().getNode();
        return node != null && node.getElementType() == XmlTokenType.XML_NAME;
    }

    public String advertise(@NotNull CompletionParameters parameters) {
        String shortcut;
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/XmlCompletionContributor.advertise must not be null");
        }
        if (XmlCompletionContributor.isXmlNameCompletion(parameters) && parameters.getCompletionType() == CompletionType.BASIC && FeatureUsageTracker.getInstance().isToBeShown(TAG_NAME_COMPLETION_FEATURE, parameters.getPosition().getProject()) && (shortcut = XmlCompletionContributor.getActionShortcut((String)"ClassNameCompletion")) != null) {
            return XmlBundle.message((String)"tag.name.completion.hint", (Object[])new Object[]{shortcut});
        }
        return super.advertise(parameters);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/XmlCompletionContributor.beforeCompletion must not be null");
        }
        int offset = context.getStartOffset();
        XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)offset, XmlAttributeValue.class, (boolean)true);
        if (attributeValue != null && offset == attributeValue.getTextRange().getStartOffset()) {
            context.setFileCopyPatcher((FileCopyPatcher)new DummyIdentifierPatcher(""));
        }
    }
}

