/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class RecursionWeigher
extends CompletionWeigher {
    public Result weigh(@NotNull LookupElement element, CompletionLocation location) {
        boolean isDelegate;
        PsiReferenceExpression reference;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/RecursionWeigher.weigh must not be null");
        }
        if (location.getCompletionType() != CompletionType.BASIC && location.getCompletionType() != CompletionType.SMART) {
            return Result.normal;
        }
        Object object = element.getObject();
        if (!(object instanceof PsiModifierListOwner) && !(object instanceof PsiExpression)) {
            return Result.normal;
        }
        PsiMethod positionMethod = (PsiMethod)JavaCompletionUtil.POSITION_METHOD.getValue((UserDataHolder)location);
        if (positionMethod == null) {
            return Result.normal;
        }
        PsiElement position = location.getCompletionParameters().getPosition();
        ElementFilter filter = JavaCompletionUtil.recursionFilter(position);
        if (filter != null && !filter.isAcceptable(object, position)) {
            return Result.recursive;
        }
        PsiMethodCallExpression expression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        PsiReferenceExpression psiReferenceExpression = reference = expression != null ? expression.getMethodExpression() : (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceExpression.class);
        if (reference == null) {
            return Result.normal;
        }
        PsiExpression qualifier = reference.getQualifierExpression();
        boolean bl = isDelegate = qualifier != null && !(qualifier instanceof PsiThisExpression);
        if (RecursionWeigher.isPassingObjectToItself(object, qualifier, isDelegate)) {
            return Result.passingObjectToItself;
        }
        if (expression != null) {
            PsiType itemType;
            ExpectedTypeInfo[] expectedInfos = (ExpectedTypeInfo[])JavaCompletionUtil.EXPECTED_TYPES.getValue((UserDataHolder)location);
            if (expectedInfos != null && (itemType = JavaCompletionUtil.getLookupElementType(element)) != null) {
                for (ExpectedTypeInfo expectedInfo : expectedInfos) {
                    if (!positionMethod.equals(expectedInfo.getCalledMethod()) || !expectedInfo.getType().isAssignableFrom(itemType)) continue;
                    return isDelegate ? Result.delegation : Result.recursive;
                }
            }
            return Result.normal;
        }
        if (object instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)object;
            if (PsiTreeUtil.isAncestor((PsiElement)reference, (PsiElement)position, (boolean)false) && Comparing.equal((String)method.getName(), (String)positionMethod.getName()) && method.getParameterList().getParametersCount() == positionMethod.getParameterList().getParametersCount() && RecursionWeigher.findDeepestSuper(method).equals(RecursionWeigher.findDeepestSuper(positionMethod))) {
                return isDelegate ? Result.delegation : Result.recursive;
            }
        }
        return Result.normal;
    }

    private static boolean isPassingObjectToItself(Object object, PsiExpression qualifier, boolean delegate) {
        if (object instanceof PsiThisExpression) {
            return !delegate || qualifier instanceof PsiSuperExpression;
        }
        return qualifier instanceof PsiReferenceExpression && object.equals(((PsiReferenceExpression)qualifier).advancedResolve(true).getElement());
    }

    @NotNull
    private static PsiMethod findDeepestSuper(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/RecursionWeigher.findDeepestSuper must not be null");
        }
        PsiMethod first = (PsiMethod)DeepestSuperMethodsSearch.search((PsiMethod)method).findFirst();
        PsiMethod psiMethod = first == null ? method : first;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/RecursionWeigher.findDeepestSuper must not return null");
        }
        return psiMethod;
    }

    private static enum Result {
        recursive,
        passingObjectToItself,
        normal,
        delegation;

    }
}

