/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public class PreferExpectedTypeWeigher
extends CompletionWeigher {
    public MyResult weigh(@NotNull LookupElement item, CompletionLocation location) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/PreferExpectedTypeWeigher.weigh must not be null");
        }
        if (location.getCompletionType() != CompletionType.BASIC) {
            return MyResult.normal;
        }
        if (item.getObject() instanceof PsiClass) {
            return MyResult.normal;
        }
        ExpectedTypeInfo[] expectedInfos = (ExpectedTypeInfo[])JavaCompletionUtil.EXPECTED_TYPES.getValue((UserDataHolder)location);
        if (expectedInfos == null) {
            return MyResult.normal;
        }
        PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
        if (itemType == null || !itemType.isValid()) {
            return MyResult.normal;
        }
        for (ExpectedTypeInfo expectedInfo : expectedInfos) {
            PsiType defaultType = expectedInfo.getDefaultType();
            PsiType expectedType = expectedInfo.getType();
            if (!expectedType.isValid()) {
                return MyResult.normal;
            }
            if (defaultType != expectedType && defaultType.isAssignableFrom(itemType)) {
                return MyResult.ofDefaultType;
            }
            if (!expectedType.isAssignableFrom(itemType)) continue;
            return MyResult.expected;
        }
        return MyResult.normal;
    }

    private static enum MyResult {
        normal,
        expected,
        ofDefaultType;

    }
}

