/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.DefaultInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JavaPsiClassReferenceElement
extends LookupItem<Object> {
    public static final InsertHandler<JavaPsiClassReferenceElement> JAVA_CLASS_INSERT_HANDLER = new InsertHandler<JavaPsiClassReferenceElement>(){

        public void handleInsert(InsertionContext context, JavaPsiClassReferenceElement item) {
            PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiJavaCodeReferenceElement.class, (boolean)false);
            PsiElement prevElement = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)element);
            if (prevElement != null && prevElement.getParent() instanceof PsiNewExpression) {
                ExpectedTypeInfo[] infos = ExpectedTypesProvider.getInstance(context.getProject()).getExpectedTypes((PsiExpression)prevElement.getParent(), true);
                boolean flag = true;
                PsiTypeParameter[] typeParameters = item.getObject().getTypeParameters();
                for (ExpectedTypeInfo info : infos) {
                    PsiType type = info.getType();
                    if (info.isArrayTypeInfo()) {
                        flag = false;
                        break;
                    }
                    if (typeParameters.length <= 0 || !(type instanceof PsiClassType) || ((PsiClassType)type).isRaw()) continue;
                    flag = false;
                }
                if (flag) {
                    item.setAttribute(LookupItem.NEW_OBJECT_ATTR, "");
                    item.setAttribute(LookupItem.DONT_CHECK_FOR_INNERS, "");
                }
            }
            new DefaultInsertHandler().handleInsert(context, (LookupElement)item);
        }
    };
    private final PsiAnchor myClass;
    private final String myQualifiedName;

    public JavaPsiClassReferenceElement(PsiClass psiClass) {
        super(psiClass.getName(), psiClass.getName());
        this.myClass = PsiAnchor.create((PsiElement)psiClass);
        this.myQualifiedName = psiClass.getQualifiedName();
        JavaCompletionUtil.setShowFQN(this);
        this.setInsertHandler((InsertHandler)JAVA_CLASS_INSERT_HANDLER);
    }

    @Override
    @NotNull
    public PsiClass getObject() {
        PsiClass psiClass = (PsiClass)this.myClass.retrieve();
        if (psiClass == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaPsiClassReferenceElement.getObject must not return null");
        }
        return psiClass;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaPsiClassReferenceElement)) {
            return false;
        }
        JavaPsiClassReferenceElement that = (JavaPsiClassReferenceElement)o;
        return Comparing.equal((String)this.myQualifiedName, (String)that.myQualifiedName);
    }

    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    @Override
    public int hashCode() {
        String s = this.myQualifiedName;
        return s == null ? 239 : s.hashCode();
    }
}

