/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaAwareCompletionData;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.ModifierChooser;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ContentFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.ScopeFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.classes.EnumOrAnnotationTypeFilter;
import com.intellij.psi.filters.classes.InterfaceFilter;
import com.intellij.psi.filters.element.ReferenceOnFilter;
import com.intellij.psi.filters.position.AfterElementFilter;
import com.intellij.psi.filters.position.BeforeElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.filters.position.InsideElementFilter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.filters.position.PatternFilter;
import com.intellij.psi.filters.position.StartElementFilter;
import com.intellij.psi.filters.position.SuperParentFilter;
import com.intellij.psi.filters.position.TokenTypeFilter;
import com.intellij.psi.filters.types.TypeCodeFragmentIsVoidEnabledFilter;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassLevelDeclarationStatement;
import com.intellij.psi.jsp.JspElementType;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;

public class JavaCompletionData
extends JavaAwareCompletionData {
    @NonNls
    private static final String[] ourBlockFinalizers = new String[]{"{", "}", ";", ":", "else"};
    private static final PsiElementPattern.Capture<PsiElement> AFTER_DOT = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"."});
    public static final LeftNeighbour INSTANCEOF_PLACE = new LeftNeighbour(new OrFilter(new ReferenceOnFilter(new ClassFilter(PsiVariable.class)), new TextFilter("this"), new AndFilter((ElementFilter)new TextFilter(")"), (ElementFilter)new ParentElementFilter(new AndFilter((ElementFilter)new ClassFilter(PsiTypeCastExpression.class, false), (ElementFilter)new OrFilter(new ParentElementFilter(new ClassFilter(PsiExpression.class)), new ClassFilter(PsiExpression.class))))), new AndFilter((ElementFilter)new TextFilter("]"), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiArrayAccessExpression.class)))));
    public static final PsiJavaElementPattern.Capture<PsiElement> AFTER_FINAL = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"final"})).inside(PsiDeclarationStatement.class);
    public static final LeftNeighbour AFTER_TRY_BLOCK = new LeftNeighbour(new AndFilter((ElementFilter)new TextFilter("}"), (ElementFilter)new ParentElementFilter(new AndFilter((ElementFilter)new LeftNeighbour(new TextFilter("try")), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiTryStatement.class))))));
    public static final PsiJavaElementPattern.Capture<PsiElement> INSIDE_PARAMETER_LIST = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiParameterList.class)).and((ElementPattern)new FilterPattern((ElementFilter)new LeftNeighbour(new OrFilter(new TextFilter("(", ",", "final"), new SuperParentFilter(new ClassFilter(PsiAnnotation.class))))));
    private static final AndFilter START_OF_CODE_FRAGMENT = new AndFilter((ElementFilter)new ScopeFilter(new AndFilter(new ClassFilter(JavaCodeFragment.class), new ClassFilter(PsiExpressionCodeFragment.class, false), new ClassFilter(PsiJavaCodeReferenceCodeFragment.class, false), new ClassFilter(PsiTypeCodeFragment.class, false))), (ElementFilter)new StartElementFilter());
    static final ElementFilter END_OF_BLOCK = new OrFilter(new AndFilter((ElementFilter)new LeftNeighbour(new OrFilter(new AndFilter((ElementFilter)new TextFilter(ourBlockFinalizers), (ElementFilter)new NotFilter(new SuperParentFilter(new ClassFilter(PsiAnnotation.class)))), new TextFilter("*/"), new TokenTypeFilter(JspElementType.HOLDER_TEMPLATE_DATA), new ClassFilter(OuterLanguageElement.class), new AndFilter((ElementFilter)new TextFilter(")"), (ElementFilter)new NotFilter(new OrFilter(new ParentElementFilter(new ClassFilter(PsiExpressionList.class)), new ParentElementFilter(new ClassFilter(PsiParameterList.class)), new ParentElementFilter(new ClassFilter(PsiTypeCastExpression.class))))))), (ElementFilter)new NotFilter(new TextFilter("."))), START_OF_CODE_FRAGMENT);
    static final AndFilter START_SWITCH = new AndFilter(END_OF_BLOCK, (ElementFilter)new LeftNeighbour(new AndFilter((ElementFilter)new TextFilter("{"), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiSwitchStatement.class), 2))));
    private static final ElementPattern<Object> SUPER_OR_THIS_PATTERN = PsiJavaPatterns.and((ElementPattern[])new ElementPattern[]{JavaSmartCompletionContributor.INSIDE_EXPRESSION, StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"case"})), StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(".")).afterLeaf(new String[]{"this", "super"}))), StandardPatterns.not((ElementPattern)new FilterPattern((ElementFilter)START_SWITCH))});
    protected static final AndFilter CLASS_START = new AndFilter((ElementFilter)new OrFilter(new ElementFilter[]{END_OF_BLOCK, new PatternFilter((ElementPattern)PlatformPatterns.psiElement().afterLeaf(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement().withoutText(".")).inside((ElementPattern)PlatformPatterns.psiElement(PsiModifierList.class)), PlatformPatterns.psiElement().isNull()})))}), (ElementFilter)new PatternFilter(StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"@"}))));
    private static final String[] PRIMITIVE_TYPES = new String[]{"short", "boolean", "double", "long", "int", "float", "void", "char", "byte"};
    static final ElementFilter CLASS_BODY = new OrFilter(new AfterElementFilter(new TextFilter("{")), new ScopeFilter(new ClassFilter(JspClassLevelDeclarationStatement.class)));
    public static final AndFilter DECLARATION_START = new AndFilter(new ElementFilter[]{CLASS_BODY, new OrFilter(END_OF_BLOCK, new LeftNeighbour(new OrFilter(new SuperParentFilter(new ClassFilter(PsiModifierList.class)), new AndFilter((ElementFilter)new TokenTypeFilter(JavaTokenType.GT), (ElementFilter)new SuperParentFilter(new ClassFilter(PsiTypeParameterList.class)))))), new PatternFilter(StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("@"))))});

    public JavaCompletionData() {
        this.declareCompletionSpaces();
        CompletionVariant variant = new CompletionVariant(PsiMethod.class, (ElementFilter)new PatternFilter(StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"@", "."}))));
        variant.includeScopeClass(PsiVariable.class);
        variant.includeScopeClass(PsiClass.class);
        variant.includeScopeClass(PsiFile.class);
        variant.includeScopeClass(PsiParameterList.class);
        variant.addCompletion(new ModifierChooser());
        this.registerVariant(variant);
        this.initVariantsInFileScope();
        this.initVariantsInClassScope();
        this.initVariantsInMethodScope();
        this.defineScopeEquivalence(PsiMethod.class, PsiClassInitializer.class);
        this.defineScopeEquivalence(PsiMethod.class, JavaCodeFragment.class);
    }

    private void declareCompletionSpaces() {
        this.declareFinalScope(PsiFile.class);
        CompletionVariant variant = new CompletionVariant(CLASS_BODY);
        variant.includeScopeClass(PsiClass.class, true);
        this.registerVariant(variant);
        variant = new CompletionVariant(new AndFilter((ElementFilter)new InsideElementFilter(new ClassFilter(PsiCodeBlock.class)), (ElementFilter)new NotFilter(new InsideElementFilter(new ClassFilter(JspClassLevelDeclarationStatement.class)))));
        variant.includeScopeClass(PsiMethod.class, true);
        variant.includeScopeClass(PsiClassInitializer.class, true);
        this.registerVariant(variant);
        variant = new CompletionVariant(new AfterElementFilter(new TextFilter("=")));
        variant.includeScopeClass(PsiField.class, true);
        this.registerVariant(variant);
        this.declareFinalScope(PsiLiteralExpression.class);
        this.declareFinalScope(PsiComment.class);
    }

    protected void initVariantsInFileScope() {
        CompletionVariant variant = new CompletionVariant(PsiJavaFile.class, new StartElementFilter());
        variant.addCompletion("package");
        this.registerVariant(variant);
        variant = new CompletionVariant(PsiJavaFile.class, new OrFilter(new StartElementFilter(), END_OF_BLOCK));
        variant.addCompletion("import");
        this.registerVariant(variant);
        variant = new CompletionVariant(PsiJavaFile.class, CLASS_START);
        variant.includeScopeClass(PsiClass.class);
        variant.addCompletion("class");
        variant.addCompletion("interface");
        this.registerVariant(variant);
        variant = new CompletionVariant(PsiTypeCodeFragment.class, new StartElementFilter());
        JavaCompletionData.addPrimitiveTypes(variant, TailType.NONE);
        CompletionVariant variant1 = new CompletionVariant(PsiTypeCodeFragment.class, new AndFilter((ElementFilter)new StartElementFilter(), (ElementFilter)new TypeCodeFragmentIsVoidEnabledFilter()));
        variant1.addCompletion("void", TailType.NONE);
        this.registerVariant(variant);
        this.registerVariant(variant1);
    }

    protected void initVariantsInClassScope() {
        AndFilter position = new AndFilter(new NotFilter(CLASS_BODY), new NotFilter(new AfterElementFilter(new ContentFilter(new TextFilter("extends")))), new NotFilter(new AfterElementFilter(new ContentFilter(new TextFilter("implements")))), new NotFilter(new LeftNeighbour(new LeftNeighbour(new TextFilter("<", ",")))), new NotFilter(new ScopeFilter(new EnumOrAnnotationTypeFilter())), new LeftNeighbour(new OrFilter(new ClassFilter(PsiIdentifier.class), new TextFilter(">"))));
        CompletionVariant variant = new CompletionVariant(position);
        variant.includeScopeClass(PsiClass.class, true);
        variant.addCompletion("extends");
        variant.excludeScopeClass(PsiAnonymousClass.class);
        variant.excludeScopeClass(PsiTypeParameter.class);
        this.registerVariant(variant);
        position = new AndFilter(new NotFilter(CLASS_BODY), new NotFilter(new BeforeElementFilter(new ContentFilter(new TextFilter("extends")))), new NotFilter(new AfterElementFilter(new ContentFilter(new TextFilter("implements")))), new NotFilter(new LeftNeighbour(new LeftNeighbour(new TextFilter("<", ",")))), new LeftNeighbour(new OrFilter(new ClassFilter(PsiIdentifier.class), new TextFilter(">"))), new NotFilter(new ScopeFilter(new InterfaceFilter())));
        variant = new CompletionVariant(position);
        variant.includeScopeClass(PsiClass.class, true);
        variant.addCompletion("implements");
        variant.excludeScopeClass(PsiAnonymousClass.class);
        this.registerVariant(variant);
        CompletionVariant variant2 = new CompletionVariant(PsiClass.class, DECLARATION_START);
        variant2.includeScopeClass(JspClassLevelDeclarationStatement.class);
        JavaCompletionData.addPrimitiveTypes(variant2);
        variant2.addCompletion("void");
        this.registerVariant(variant2);
        variant2 = new CompletionVariant(PsiElement.class, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement(PsiIdentifier.class).afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{",", "<"}))).withParent(PsiTypeParameterList.class))));
        variant2.addCompletion("extends", TailType.SPACE);
        this.registerVariant(variant2);
    }

    private void initVariantsInMethodScope() {
        CompletionVariant variant = new CompletionVariant((ElementPattern<? extends PsiElement>)INSIDE_PARAMETER_LIST);
        variant.includeScopeClass(PsiParameterList.class, true);
        JavaCompletionData.addPrimitiveTypes(variant);
        this.registerVariant(variant);
        LeftNeighbour position = new LeftNeighbour(new AndFilter((ElementFilter)new TextFilter(")"), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiParameterList.class))));
        CompletionVariant variant2 = new CompletionVariant(PsiMethod.class, position);
        variant2.includeScopeClass(PsiClass.class);
        variant2.addCompletion("throws");
        this.registerVariant(variant2);
        variant2 = new CompletionVariant(PsiAnnotationMethod.class, position);
        variant2.addCompletion("default");
        this.registerVariant(variant2);
        variant = new CompletionVariant(new OrFilter(END_OF_BLOCK, new LeftNeighbour(new TextFilter("final"))));
        variant.includeScopeClass(PsiCodeBlock.class, false);
        JavaCompletionData.addPrimitiveTypes(variant);
        variant.addCompletion("class");
        this.registerVariant(variant);
        variant = new CompletionVariant(PsiMethod.class, new LeftNeighbour(new AndFilter((ElementFilter)new TextFilter("("), (ElementFilter)new ParentElementFilter(new OrFilter(new ClassFilter(PsiParenthesizedExpression.class), new ClassFilter(PsiTypeCastExpression.class))))));
        JavaCompletionData.addPrimitiveTypes(variant);
        this.registerVariant(variant);
        position = INSTANCEOF_PLACE;
        variant2 = new CompletionVariant(position);
        variant2.includeScopeClass(PsiExpression.class, true);
        variant2.includeScopeClass(PsiMethod.class);
        variant2.addCompletion("instanceof");
        this.registerVariant(variant2);
        position = new PatternFilter(AFTER_FINAL);
        variant2 = new CompletionVariant(position);
        variant2.includeScopeClass(PsiDeclarationStatement.class, true);
        JavaCompletionData.addPrimitiveTypes(variant2);
        this.registerVariant(variant2);
        variant = new CompletionVariant(PsiMethod.class, END_OF_BLOCK);
        JavaCompletionData.addKeywords(variant);
        this.registerVariant(variant);
        variant = new CompletionVariant(PsiMethod.class, new LeftNeighbour(new TextFilter("return")));
        variant.addCompletion("true", TailType.NONE);
        variant.addCompletion("false", TailType.NONE);
        this.registerVariant(variant);
        position = AFTER_TRY_BLOCK;
        variant2 = new CompletionVariant(position);
        variant2.includeScopeClass(PsiCodeBlock.class, true);
        variant2.addCompletion("catch", TailTypes.CATCH_LPARENTH);
        variant2.addCompletion("finally", TailTypes.FINALLY_LBRACE);
        this.registerVariant(variant2);
        position = new LeftNeighbour(new AndFilter((ElementFilter)new TextFilter("}"), (ElementFilter)new ParentElementFilter(new AndFilter((ElementFilter)new LeftNeighbour(new NotFilter(new TextFilter("try"))), (ElementFilter)new OrFilter(new ParentElementFilter(new ClassFilter(PsiTryStatement.class)), new ParentElementFilter(new ClassFilter(PsiCatchSection.class)))))));
        variant2 = new CompletionVariant(position);
        variant2.includeScopeClass(PsiCodeBlock.class, false);
        variant2.addCompletion("catch", TailTypes.CATCH_LPARENTH);
        variant2.addCompletion("finally", TailTypes.FINALLY_LBRACE);
        this.registerVariant(variant2);
        position = new LeftNeighbour(new OrFilter(new AndFilter((ElementFilter)new TextFilter("}"), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiIfStatement.class), 3)), new AndFilter((ElementFilter)new TextFilter(";"), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiIfStatement.class), 2))));
        variant2 = new CompletionVariant(PsiMethod.class, position);
        variant2.addCompletion("else");
        this.registerVariant(variant2);
        variant = new CompletionVariant(PsiMethod.class, new LeftNeighbour(new AndFilter((ElementFilter)new TextFilter("."), (ElementFilter)new LeftNeighbour(new OrFilter(new ReferenceOnFilter(ElementClassFilter.CLASS), new TextFilter(PRIMITIVE_TYPES), new TextFilter("]"))))));
        variant.includeScopeClass(PsiAnnotationParameterList.class);
        variant.includeScopeClass(PsiVariable.class);
        variant.excludeScopeClass(PsiJavaCodeReferenceCodeFragment.class);
        variant.addCompletion("class", TailType.NONE);
        this.registerVariant(variant);
        variant = new CompletionVariant(new AndFilter(END_OF_BLOCK, (ElementFilter)new OrFilter(new ScopeFilter(new ClassFilter(PsiSwitchStatement.class)), new InsideElementFilter(new ClassFilter(PsiBlockStatement.class)))));
        variant.includeScopeClass(PsiForStatement.class, false);
        variant.includeScopeClass(PsiForeachStatement.class, false);
        variant.includeScopeClass(PsiWhileStatement.class, false);
        variant.includeScopeClass(PsiDoWhileStatement.class, false);
        variant.includeScopeClass(PsiSwitchStatement.class, false);
        variant.addCompletion("break");
        this.registerVariant(variant);
        variant = new CompletionVariant(new AndFilter(END_OF_BLOCK, (ElementFilter)new InsideElementFilter(new ClassFilter(PsiBlockStatement.class))));
        variant.includeScopeClass(PsiForeachStatement.class, false);
        variant.includeScopeClass(PsiForStatement.class, false);
        variant.includeScopeClass(PsiWhileStatement.class, false);
        variant.includeScopeClass(PsiDoWhileStatement.class, false);
        variant.addCompletion("continue");
        this.registerVariant(variant);
        variant = new CompletionVariant(new AndFilter(END_OF_BLOCK, new NotFilter(START_SWITCH), new OrFilter(new ParentElementFilter(new ClassFilter(PsiSwitchLabelStatement.class)), new LeftNeighbour(new OrFilter(new ParentElementFilter(new ClassFilter(PsiSwitchStatement.class), 2), new AndFilter((ElementFilter)new TextFilter(";", "}", ":"), (ElementFilter)new ParentElementFilter(new ClassFilter(PsiSwitchStatement.class), 3)))))));
        variant.includeScopeClass(PsiElement.class, false);
        variant.addCompletion("case", TailType.SPACE);
        variant.addCompletion("default", TailType.CASE_COLON);
        this.registerVariant(variant);
        variant = new CompletionVariant(START_SWITCH);
        variant.includeScopeClass(PsiElement.class, true);
        variant.addCompletion("case", TailType.SPACE);
        variant.addCompletion("default", TailType.CASE_COLON);
        this.registerVariant(variant);
        variant = new CompletionVariant((ElementPattern<? extends PsiElement>)PsiJavaPatterns.and((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().inside(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(PsiExpressionList.class), PlatformPatterns.psiElement(PsiExpression.class).withParent(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(PsiIfStatement.class), PlatformPatterns.psiElement(PsiLocalVariable.class)})), PlatformPatterns.psiElement(PsiAssignmentExpression.class)})), StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{".", "return"})), StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiTypeCastExpression.class)))}));
        variant.addCompletion("null", TailType.NONE);
        variant.addCompletion("true", TailType.NONE);
        variant.addCompletion("false", TailType.NONE);
        variant.includeScopeClass(PsiExpressionList.class);
        variant.includeScopeClass(PsiStatement.class);
        this.registerVariant(variant);
    }

    private static void addPrimitiveTypes(CompletionVariant variant) {
        JavaCompletionData.addPrimitiveTypes(variant, CompletionVariant.DEFAULT_TAIL_TYPE);
    }

    private static void addPrimitiveTypes(CompletionVariant variant, TailType tailType) {
        variant.addCompletion(new String[]{"short", "boolean", "double", "long", "int", "float", "char", "byte"}, tailType);
    }

    private static void addKeywords(CompletionVariant variant) {
        variant.addCompletion("switch", TailTypes.SWITCH_LPARENTH);
        variant.addCompletion("while", TailTypes.WHILE_LPARENTH);
        variant.addCompletion("for", TailTypes.FOR_LPARENTH);
        variant.addCompletion("try", TailType.createSimpleTailType((char)'{'));
        variant.addCompletion("throw", TailType.SPACE);
        variant.addCompletion("return", TailType.SPACE);
        variant.addCompletion("new", TailType.SPACE);
        variant.addCompletion("assert", TailType.SPACE);
    }

    @Override
    public void fillCompletions(CompletionParameters parameters, CompletionResultSet result) {
        PsiElement position = parameters.getPosition();
        if (SUPER_OR_THIS_PATTERN.accepts((Object)position)) {
            if (AFTER_DOT.accepts((Object)position) && !JavaCompletionData.isInsideQualifierClass(position)) {
                return;
            }
            result.addElement(BasicExpressionCompletionContributor.createKeywordLookupItem(position, "this"));
            LookupItem superItem = (LookupItem)BasicExpressionCompletionContributor.createKeywordLookupItem(position, "super");
            if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("{")).withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiMethod().constructor(true)))).accepts((Object)position)) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethod.class, (boolean)false, (Class[])new Class[]{PsiClass.class});
                assert (method != null);
                final boolean hasParams = JavaCompletionData.superConstructorHasParameters(method);
                superItem.setInsertHandler((InsertHandler)new ParenthesesInsertHandler<LookupElement>(){

                    protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
                        return hasParams;
                    }

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        super.handleInsert(context, item);
                        TailType.insertChar((Editor)context.getEditor(), (int)context.getTailOffset(), (char)';');
                    }
                });
            } else if (!AFTER_DOT.accepts((Object)position)) {
                superItem.setTailType(TailType.DOT);
            }
            result.addElement((LookupElement)superItem);
        }
    }

    private static boolean isInsideQualifierClass(PsiElement position) {
        PsiElement qualifierClass;
        PsiElement qualifier;
        if (position.getParent() instanceof PsiJavaCodeReferenceElement && (qualifier = ((PsiJavaCodeReferenceElement)position.getParent()).getQualifier()) instanceof PsiJavaCodeReferenceElement && (qualifierClass = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass) {
            PsiElement parent = position;
            PsiManager psiManager = position.getManager();
            while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)true)) != null) {
                if (!psiManager.areElementsEquivalent(parent, qualifierClass)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean superConstructorHasParameters(PsiMethod method) {
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass superClass = psiClass.getSuperClass();
        if (superClass != null) {
            for (PsiMethod psiMethod : superClass.getConstructors()) {
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper();
                if (!resolveHelper.isAccessible((PsiMember)psiMethod, (PsiElement)method, null) || psiMethod.getParameterList().getParameters().length <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

