/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class CompletionProgressIndicator
extends ProgressIndicatorBase
implements CompletionProcess {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CompletionProgressIndicator");
    private final Editor myEditor;
    private final CompletionParameters myParameters;
    private final CodeCompletionHandlerBase myHandler;
    private final LookupImpl myLookup;
    private final MergingUpdateQueue myQueue;
    private boolean myDisposed;
    private boolean myInitialized;
    private int myCount;
    private final Update myUpdate = new Update("update"){

        public void run() {
            CompletionProgressIndicator.this.updateLookup();
        }
    };
    private LightweightHint myHint;
    private final CompletionContext myContextOriginal;
    private final Semaphore myFreezeSemaphore;
    private boolean myModifiersReleased;
    private String myOldDocumentText;
    private int myOldCaret;
    private int myOldStart;
    private int myOldEnd;

    public CompletionProgressIndicator(Editor editor, CompletionParameters parameters, CodeCompletionHandlerBase handler, final CompletionContext contextOriginal, Semaphore freezeSemaphore) {
        this.myEditor = editor;
        this.myParameters = parameters;
        this.myHandler = handler;
        this.myContextOriginal = contextOriginal;
        this.myFreezeSemaphore = freezeSemaphore;
        this.myLookup = (LookupImpl)LookupManager.getInstance(editor.getProject()).createLookup(editor, LookupElement.EMPTY_ARRAY, "", new CompletionLookupArranger(parameters));
        this.myLookup.addLookupListener(new LookupAdapter(){

            @Override
            public void itemSelected(LookupEvent event) {
                CompletionProgressIndicator.this.cancel();
                CompletionProgressIndicator.this.finishCompletion();
                LookupElement item = event.getItem();
                if (item == null) {
                    return;
                }
                CompletionProgressIndicator.this.setMergeCommand();
                contextOriginal.setStartOffset(CompletionProgressIndicator.this.myEditor.getCaretModel().getOffset() - item.getLookupString().length());
                CodeCompletionHandlerBase.selectLookupItem(item, event.getCompletionChar(), contextOriginal, CompletionProgressIndicator.this.myLookup.getItems());
            }

            @Override
            public void lookupCanceled(LookupEvent event) {
                CompletionProgressIndicator.this.cancel();
                CompletionProgressIndicator.this.finishCompletion();
            }
        });
        this.myLookup.setCalculating(true);
        this.myQueue = new MergingUpdateQueue("completion lookup progress", 200, true, this.myEditor.getContentComponent());
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.registerItself();
        this.scheduleAdvertising();
        this.trackModifiers();
    }

    private void scheduleAdvertising() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (CompletionProgressIndicator.this.isOutdated()) {
                    return;
                }
                List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<CompletionContributor>>(){

                    public List<CompletionContributor> compute() {
                        if (CompletionProgressIndicator.this.isOutdated()) {
                            return Collections.emptyList();
                        }
                        return CompletionContributor.forParameters((CompletionParameters)CompletionProgressIndicator.this.myParameters);
                    }
                });
                for (final CompletionContributor contributor : list) {
                    if (CompletionProgressIndicator.this.myLookup.getAdvertisementText() != null) {
                        return;
                    }
                    if (!CompletionProgressIndicator.this.myLookup.isCalculating() && !CompletionProgressIndicator.this.myLookup.isVisible()) {
                        return;
                    }
                    String s = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                        @Nullable
                        public String compute() {
                            if (CompletionProgressIndicator.this.isOutdated()) {
                                return null;
                            }
                            return contributor.advertise(CompletionProgressIndicator.this.myParameters);
                        }
                    });
                    if (CompletionProgressIndicator.this.myLookup.getAdvertisementText() != null) {
                        return;
                    }
                    if (s == null) continue;
                    CompletionProgressIndicator.this.myLookup.setAdvertisementText(s);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (CompletionProgressIndicator.this.isOutdated() || CompletionProgressIndicator.this.myEditor.getComponent().getRootPane() == null) {
                                return;
                            }
                            CompletionProgressIndicator.this.updateLookup();
                        }
                    }, CompletionProgressIndicator.this.myQueue.getModalityState());
                    return;
                }
            }
        });
    }

    private boolean isOutdated() {
        return this.myEditor.isDisposed() || this.myDisposed;
    }

    private void trackModifiers() {
        final JComponent contentComponent = this.myEditor.getContentComponent();
        contentComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.processModifier(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.processModifier(e);
            }

            private void processModifier(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 17 || code == 157 || code == 18 || code == 16) {
                    CompletionProgressIndicator.this.myModifiersReleased = true;
                    if (CompletionProgressIndicator.this.myOldDocumentText != null) {
                        CompletionProgressIndicator.this.cleanup();
                    }
                    contentComponent.removeKeyListener(this);
                }
            }
        });
    }

    private void setMergeCommand() {
        CommandProcessor.getInstance().setCurrentCommandGroupId((Object)("Completion" + this.hashCode()));
    }

    public void showLookup() {
        this.updateLookup();
    }

    public CompletionParameters getParameters() {
        return this.myParameters;
    }

    private void registerItself() {
        CompletionServiceImpl.getCompletionService().setCurrentCompletion(this);
    }

    public void liveAfterDeath(final @Nullable LightweightHint hint) {
        if (this.myModifiersReleased || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.registerItself();
        this.myHint = hint;
        if (hint != null) {
            hint.addHintListener(new HintListener(){

                @Override
                public void hintHidden(EventObject event) {
                    hint.removeHintListener(this);
                    CompletionProgressIndicator.this.cleanup();
                }
            });
        }
        final Document document = this.myEditor.getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                document.removeDocumentListener((DocumentListener)this);
                CompletionProgressIndicator.this.cleanup();
            }
        });
        final SelectionModel selectionModel = this.myEditor.getSelectionModel();
        selectionModel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                selectionModel.removeSelectionListener((SelectionListener)this);
                CompletionProgressIndicator.this.cleanup();
            }
        });
        final CaretModel caretModel = this.myEditor.getCaretModel();
        caretModel.addCaretListener(new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                caretModel.removeCaretListener((CaretListener)this);
                CompletionProgressIndicator.this.cleanup();
            }
        });
    }

    public CodeCompletionHandlerBase getHandler() {
        return this.myHandler;
    }

    public LookupImpl getLookup() {
        return this.myLookup;
    }

    private void updateLookup() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isOutdated()) {
            return;
        }
        if (!this.myInitialized) {
            this.myInitialized = true;
            if (this.myLookup.isCalculating()) {
                AsyncProcessIcon processIcon = this.myLookup.getProcessIcon();
                processIcon.setVisible(true);
                processIcon.resume();
            }
            this.myLookup.show();
        }
        this.myLookup.refreshUi();
    }

    public int getCount() {
        return this.myCount;
    }

    private boolean isInsideIdentifier() {
        return this.myContextOriginal.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != this.myContextOriginal.getSelectionEndOffset();
    }

    public synchronized void addItem(LookupElement item) {
        if (!this.isRunning()) {
            return;
        }
        ProgressManager.checkCanceled();
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!unitTestMode) assert (!ApplicationManager.getApplication().isDispatchThread());
        this.myLookup.addItem(item);
        ++this.myCount;
        if (unitTestMode) {
            return;
        }
        if (this.myCount == 1) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                    CompletionProgressIndicator.this.myFreezeSemaphore.up();
                }
            });
        }
        this.myQueue.queue(this.myUpdate);
    }

    public void closeAndFinish() {
        if (this.myHint != null) {
            this.myHint.hide();
        }
        LookupManager.getInstance(this.myEditor.getProject()).hideActiveLookup();
    }

    private void finishCompletion() {
        assert (!this.myDisposed);
        this.myDisposed = true;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myQueue.dispose();
        this.cleanup();
    }

    public static void cleanupForNextTest() {
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (currentCompletion != null) {
            currentCompletion.finishCompletion();
        }
    }

    private void cleanup() {
        this.myHint = null;
        this.myOldDocumentText = null;
        CompletionServiceImpl.getCompletionService().setCurrentCompletion(null);
    }

    @Override
    public void stop() {
        this.myQueue.cancelAllUpdates();
        super.stop();
        this.invokeLaterIfNotDispatch(new Runnable(){

            @Override
            public void run() {
                if (CompletionProgressIndicator.this.isCanceled()) {
                    return;
                }
                if (CompletionProgressIndicator.this.myLookup.isVisible()) {
                    CompletionProgressIndicator.this.myLookup.getProcessIcon().suspend();
                    CompletionProgressIndicator.this.myLookup.getProcessIcon().setVisible(false);
                    CompletionProgressIndicator.this.updateLookup();
                }
            }
        });
    }

    private void invokeLaterIfNotDispatch(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread() || application.isUnitTestMode()) {
            runnable.run();
        } else {
            application.invokeLater(runnable, this.myQueue.getModalityState());
        }
    }

    public boolean fillInCommonPrefix(final boolean explicit) {
        if (this.isInsideIdentifier()) {
            return false;
        }
        Boolean aBoolean = (Boolean)new WriteCommandAction<Boolean>(this.myEditor.getProject(), new PsiFile[0]){

            protected void run(Result<Boolean> result) throws Throwable {
                if (!explicit) {
                    CompletionProgressIndicator.this.setMergeCommand();
                }
                try {
                    result.setResult((Object)CompletionProgressIndicator.this.myLookup.fillInCommonPrefix(explicit));
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }.execute().getResultObject();
        return aBoolean;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    public void restorePrefix() {
        this.setMergeCommand();
        if (this.myOldDocumentText != null) {
            this.myEditor.getDocument().setText((CharSequence)this.myOldDocumentText);
            this.myEditor.getSelectionModel().setSelection(this.myOldStart, this.myOldEnd);
            this.myEditor.getCaretModel().moveToOffset(this.myOldCaret);
            this.myOldDocumentText = null;
            return;
        }
        this.getLookup().restorePrefix();
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public void rememberDocumentState() {
        if (this.myModifiersReleased) {
            return;
        }
        this.myOldDocumentText = this.myEditor.getDocument().getText();
        this.myOldCaret = this.myEditor.getCaretModel().getOffset();
        this.myOldStart = this.myEditor.getSelectionModel().getSelectionStart();
        this.myOldEnd = this.myEditor.getSelectionModel().getSelectionEnd();
    }
}

