/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ReformatAndOptimizeImportsProcessor
extends AbstractLayoutCodeProcessor {
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"progress.text.reformatting.code", (Object[])new Object[0]);
    private static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]);
    private final OptimizeImportsProcessor myOptimizeImportsProcessor;
    private final ReformatCodeProcessor myReformatCodeProcessor;

    public ReformatAndOptimizeImportsProcessor(Project project) {
        super(project, COMMAND_NAME, PROGRESS_TEXT);
        this.myOptimizeImportsProcessor = new OptimizeImportsProcessor(project);
        this.myReformatCodeProcessor = new ReformatCodeProcessor(project);
    }

    public ReformatAndOptimizeImportsProcessor(Project project, Module module) {
        super(project, module, COMMAND_NAME, PROGRESS_TEXT);
        this.myOptimizeImportsProcessor = new OptimizeImportsProcessor(project, module);
        this.myReformatCodeProcessor = new ReformatCodeProcessor(project, module);
    }

    public ReformatAndOptimizeImportsProcessor(Project project, PsiFile[] files) {
        super(project, files, PROGRESS_TEXT, COMMAND_NAME, null);
        this.myOptimizeImportsProcessor = new OptimizeImportsProcessor(project);
        this.myReformatCodeProcessor = new ReformatCodeProcessor(project);
    }

    public ReformatAndOptimizeImportsProcessor(Project project, PsiDirectory directory, boolean includeSubdirs) {
        super(project, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME);
        this.myOptimizeImportsProcessor = new OptimizeImportsProcessor(project, directory, includeSubdirs);
        this.myReformatCodeProcessor = new ReformatCodeProcessor(project, directory, includeSubdirs);
    }

    public ReformatAndOptimizeImportsProcessor(Project project, PsiFile file) {
        super(project, file, PROGRESS_TEXT, COMMAND_NAME);
        this.myOptimizeImportsProcessor = new OptimizeImportsProcessor(project, file);
        this.myReformatCodeProcessor = new ReformatCodeProcessor(project, file, null);
    }

    @Override
    @NotNull
    protected Runnable preprocessFile(PsiFile file) throws IncorrectOperationException {
        final Runnable r1 = this.myReformatCodeProcessor.preprocessFile(file);
        final Runnable r2 = this.myOptimizeImportsProcessor.preprocessFile(file);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                r1.run();
                r2.run();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/actions/ReformatAndOptimizeImportsProcessor.preprocessFile must not return null");
        }
        return runnable;
    }
}

