/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.actions.LayoutCodeDialog;
import com.intellij.codeInsight.actions.LayoutProjectCodeDialog;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeAction;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;

public class OptimizeImportsAction
extends AnAction {
    @NonNls
    private static final String HELP_ID = "editing.manageImports";

    public void actionPerformed(AnActionEvent event) {
        OptimizeImportsAction.actionPerformedImpl(event.getDataContext());
    }

    public static void actionPerformedImpl(DataContext dataContext) {
        boolean includeSubdirectories;
        boolean processDirectory;
        PsiDirectory dir;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Editor editor = BaseCodeInsightAction.getInjectedEditor(project, (Editor)PlatformDataKeys.EDITOR.getData(dataContext));
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        PsiFile file = null;
        if (editor != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return;
            }
            dir = file.getContainingDirectory();
        } else {
            if (ReformatCodeAction.areFiles(files)) {
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(files);
                if (!operationStatus.hasReadonlyFiles()) {
                    new OptimizeImportsProcessor(project, ReformatCodeAction.convertToPsiFiles(files, project), null).run();
                }
                return;
            }
            Project projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
            Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
            if (projectContext != null || moduleContext != null) {
                String text = moduleContext != null ? CodeInsightBundle.message((String)"process.scope.module", (Object[])new Object[]{moduleContext.getName()}) : CodeInsightBundle.message((String)"process.scope.project", (Object[])new Object[]{projectContext.getPresentableUrl()});
                LayoutProjectCodeDialog dialog = new LayoutProjectCodeDialog(project, CodeInsightBundle.message((String)"process.optimize.imports", (Object[])new Object[0]), text, false);
                dialog.show();
                if (!dialog.isOK()) {
                    return;
                }
                if (moduleContext != null) {
                    new OptimizeImportsProcessor(project, moduleContext).run();
                } else {
                    new OptimizeImportsProcessor(projectContext).run();
                }
                return;
            }
            PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element == null) {
                return;
            }
            if (element instanceof PsiDirectoryContainer) {
                dir = ((PsiDirectoryContainer)element).getDirectories()[0];
            } else if (element instanceof PsiDirectory) {
                dir = (PsiDirectory)element;
            } else {
                file = element.getContainingFile();
                if (file == null) {
                    return;
                }
                dir = file.getContainingDirectory();
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processDirectory = false;
            includeSubdirectories = false;
        } else if (!EditorSettingsExternalizable.getInstance().getOptions().SHOW_OPIMIZE_IMPORTS_DIALOG) {
            processDirectory = false;
            includeSubdirectories = false;
        } else {
            LayoutCodeDialog dialog = new LayoutCodeDialog(project, CodeInsightBundle.message((String)"process.optimize.imports", (Object[])new Object[0]), file, dir, null, HELP_ID);
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            EditorSettingsExternalizable.getInstance().getOptions().SHOW_OPIMIZE_IMPORTS_DIALOG = !dialog.isDoNotAskMe();
            ReformatCodeAction.updateShowDialogSetting(dialog, "\"Optimize Imports\" dialog disabled");
            processDirectory = dialog.isProcessDirectory();
            includeSubdirectories = dialog.isIncludeSubdirectories();
        }
        if (processDirectory) {
            new OptimizeImportsProcessor(project, dir, includeSubdirectories).run();
        } else {
            new OptimizeImportsProcessor(project, file).run();
        }
    }

    public void update(AnActionEvent event) {
        if (!LanguageImportStatements.INSTANCE.hasAnyExtensions()) {
            event.getPresentation().setVisible(false);
            return;
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Editor editor = BaseCodeInsightAction.getInjectedEditor(project, (Editor)PlatformDataKeys.EDITOR.getData(dataContext), false);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null || !OptimizeImportsAction.isOptimizeImportsAvailable(file)) {
                presentation.setEnabled(false);
                return;
            }
        } else if (files != null && ReformatCodeAction.areFiles(files)) {
            boolean anyHasOptimizeImports = false;
            for (VirtualFile virtualFile : files) {
                PsiFile file = PsiManager.getInstance((Project)project).findFile(virtualFile);
                if (file == null) {
                    presentation.setEnabled(false);
                    return;
                }
                if (!OptimizeImportsAction.isOptimizeImportsAvailable(file)) continue;
                anyHasOptimizeImports = true;
            }
            if (!anyHasOptimizeImports) {
                presentation.setEnabled(false);
                return;
            }
        } else if ((files == null || files.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(dataContext) == null && PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext) == null) {
            PsiFile file;
            PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element == null) {
                presentation.setEnabled(false);
                return;
            }
            if (!(element instanceof PsiDirectory || (file = element.getContainingFile()) != null && OptimizeImportsAction.isOptimizeImportsAvailable(file))) {
                presentation.setEnabled(false);
                return;
            }
        }
        presentation.setEnabled(true);
    }

    private static boolean isOptimizeImportsAvailable(PsiFile file) {
        return LanguageImportStatements.INSTANCE.forFile(file) != null;
    }
}

