/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor;

import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.GlobalSearchScope;

public class JavaEditorFileSwapper
implements EditorFileSwapper {
    @Override
    public VirtualFile getFileToSwapTo(Project project, VirtualFile original) {
        return JavaEditorFileSwapper.findSourceFile(project, original);
    }

    public static VirtualFile findSourceFile(Project project, VirtualFile eachFile) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(eachFile);
        if (!(psiFile instanceof ClsFileImpl)) {
            return null;
        }
        PsiClass clsClass = JavaPsiFacade.getInstance((Project)project).findClass(JavaEditorFileSwapper.getFQN(psiFile), GlobalSearchScope.allScope((Project)project));
        if (!(clsClass instanceof ClsClassImpl)) {
            return null;
        }
        PsiClass sourceClass = ((ClsClassImpl)clsClass).getSourceMirrorClass();
        if (sourceClass == null || sourceClass == clsClass) {
            return null;
        }
        VirtualFile result = sourceClass.getContainingFile().getVirtualFile();
        assert (result != null);
        return result;
    }

    public static String getFQN(PsiFile psiFile) {
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes = ((PsiJavaFile)psiFile).getClasses();
        if (classes.length == 0) {
            return null;
        }
        String fqn = classes[0].getQualifiedName();
        if (fqn == null) {
            return null;
        }
        return fqn;
    }
}

