/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.OptionId;
import com.intellij.application.options.OptionsApplicabilityFilter;
import com.intellij.application.options.editor.ErrorHighlightingPanel;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class EditorOptionsPanel {
    private JPanel myBehaviourPanel;
    private JCheckBox myCbHighlightBraces;
    private static final String STRIP_CHANGED = ApplicationBundle.message((String)"combobox.strip.modified.lines", (Object[])new Object[0]);
    private static final String STRIP_ALL = ApplicationBundle.message((String)"combobox.strip.all", (Object[])new Object[0]);
    private static final String STRIP_NONE = ApplicationBundle.message((String)"combobox.strip.none", (Object[])new Object[0]);
    private JComboBox myStripTrailingSpacesCombo;
    private JCheckBox myCbVirtualSpace;
    private JCheckBox myCbCaretInsideTabs;
    private JTextField myRecentFilesLimitField;
    private JCheckBox myCbHighlightScope;
    private JTextField myClipboardContentLimitTextField;
    private JCheckBox myCbSmoothScrolling;
    private JCheckBox myCbVirtualPageAtBottom;
    private JCheckBox myCbEnableDnD;
    private JCheckBox myCbEnableWheelFontChange;
    private JCheckBox myCbHonorCamelHumpsWhenSelectingByClicking;
    private JPanel myHighlightSettingsPanel;
    private JRadioButton myRbPreferScrolling;
    private JRadioButton myRbPreferMovingCaret;
    private JCheckBox myCbRenameLocalVariablesInplace;
    private JCheckBox myCbHighlightIdentifierUnderCaret;
    private JCheckBox myCbEnsureBlankLineBeforeCheckBox;
    private JCheckBox myShowReformatCodeDialogCheckBox;
    private JCheckBox myShowOptimizeImportsDialogCheckBox;
    private final ErrorHighlightingPanel myErrorHighlightingPanel;
    private final MyConfigurable myConfigurable;

    public EditorOptionsPanel() {
        this.$$$setupUI$$$();
        this.myErrorHighlightingPanel = new ErrorHighlightingPanel();
        if (SystemInfo.isMac) {
            this.myCbEnableWheelFontChange.setText(ApplicationBundle.message((String)"checkbox.enable.ctrl.mousewheel.changes.font.size.macos", (Object[])new Object[0]));
        }
        this.myStripTrailingSpacesCombo.addItem(STRIP_CHANGED);
        this.myStripTrailingSpacesCombo.addItem(STRIP_ALL);
        this.myStripTrailingSpacesCombo.addItem(STRIP_NONE);
        this.myHighlightSettingsPanel.setLayout(new BorderLayout());
        this.myHighlightSettingsPanel.add((Component)this.myErrorHighlightingPanel.getPanel(), "Center");
        this.myCbRenameLocalVariablesInplace.setVisible(OptionsApplicabilityFilter.isApplicable(OptionId.RENAME_IN_PLACE));
        this.myConfigurable = new MyConfigurable();
    }

    public void reset() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        UISettings uiSettings = UISettings.getInstance();
        this.myCbSmoothScrolling.setSelected(editorSettings.isSmoothScrolling());
        this.myCbHighlightBraces.setSelected(codeInsightSettings.HIGHLIGHT_BRACES);
        this.myCbHighlightScope.setSelected(codeInsightSettings.HIGHLIGHT_SCOPE);
        this.myCbHighlightIdentifierUnderCaret.setSelected(codeInsightSettings.HIGHLIGHT_IDENTIFIER_UNDER_CARET);
        this.myCbVirtualSpace.setSelected(editorSettings.isVirtualSpace());
        this.myCbCaretInsideTabs.setSelected(editorSettings.isCaretInsideTabs());
        this.myCbVirtualPageAtBottom.setSelected(editorSettings.isAdditionalPageAtBottom());
        this.myClipboardContentLimitTextField.setText(Integer.toString(uiSettings.MAX_CLIPBOARD_CONTENTS));
        String stripTrailingSpaces = editorSettings.getStripTrailingSpaces();
        if ("None".equals(stripTrailingSpaces)) {
            this.myStripTrailingSpacesCombo.setSelectedItem(STRIP_NONE);
        } else if ("Changed".equals(stripTrailingSpaces)) {
            this.myStripTrailingSpacesCombo.setSelectedItem(STRIP_CHANGED);
        } else if ("Whole".equals(stripTrailingSpaces)) {
            this.myStripTrailingSpacesCombo.setSelectedItem(STRIP_ALL);
        }
        this.myCbEnsureBlankLineBeforeCheckBox.setSelected(editorSettings.isEnsureNewLineAtEOF());
        this.myCbEnableDnD.setSelected(editorSettings.isDndEnabled());
        this.myCbEnableWheelFontChange.setSelected(editorSettings.isWheelFontChangeEnabled());
        this.myCbHonorCamelHumpsWhenSelectingByClicking.setSelected(editorSettings.isMouseClickSelectionHonorsCamelWords());
        this.myRbPreferMovingCaret.setSelected(editorSettings.isRefrainFromScrolling());
        this.myRbPreferScrolling.setSelected(!editorSettings.isRefrainFromScrolling());
        this.myRecentFilesLimitField.setText(Integer.toString(uiSettings.RECENT_FILES_LIMIT));
        this.myCbRenameLocalVariablesInplace.setSelected(editorSettings.isVariableInplaceRenameEnabled());
        this.myShowReformatCodeDialogCheckBox.setSelected(editorSettings.getOptions().SHOW_REFORMAT_DIALOG);
        this.myShowOptimizeImportsDialogCheckBox.setSelected(editorSettings.getOptions().SHOW_OPIMIZE_IMPORTS_DIALOG);
        this.myErrorHighlightingPanel.reset();
    }

    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        UISettings uiSettings = UISettings.getInstance();
        editorSettings.setSmoothScrolling(this.myCbSmoothScrolling.isSelected());
        codeInsightSettings.HIGHLIGHT_BRACES = this.myCbHighlightBraces.isSelected();
        codeInsightSettings.HIGHLIGHT_SCOPE = this.myCbHighlightScope.isSelected();
        codeInsightSettings.HIGHLIGHT_IDENTIFIER_UNDER_CARET = this.myCbHighlightIdentifierUnderCaret.isSelected();
        EditorOptionsPanel.clearAllIdentifierHighlighters();
        editorSettings.setVirtualSpace(this.myCbVirtualSpace.isSelected());
        editorSettings.setCaretInsideTabs(this.myCbCaretInsideTabs.isSelected());
        editorSettings.setAdditionalPageAtBottom(this.myCbVirtualPageAtBottom.isSelected());
        boolean uiSettingsChanged = false;
        int maxClipboardContents = this.getMaxClipboardContents();
        if (uiSettings.MAX_CLIPBOARD_CONTENTS != maxClipboardContents) {
            uiSettings.MAX_CLIPBOARD_CONTENTS = maxClipboardContents;
            uiSettingsChanged = true;
        }
        if (uiSettingsChanged) {
            uiSettings.fireUISettingsChanged();
        }
        if (STRIP_NONE.equals(this.myStripTrailingSpacesCombo.getSelectedItem())) {
            editorSettings.setStripTrailingSpaces("None");
        } else if (STRIP_CHANGED.equals(this.myStripTrailingSpacesCombo.getSelectedItem())) {
            editorSettings.setStripTrailingSpaces("Changed");
        } else {
            editorSettings.setStripTrailingSpaces("Whole");
        }
        editorSettings.setEnsureNewLineAtEOF(this.myCbEnsureBlankLineBeforeCheckBox.isSelected());
        editorSettings.setDndEnabled(this.myCbEnableDnD.isSelected());
        editorSettings.setWheelFontChangeEnabled(this.myCbEnableWheelFontChange.isSelected());
        editorSettings.setMouseClickSelectionHonorsCamelWords(this.myCbHonorCamelHumpsWhenSelectingByClicking.isSelected());
        editorSettings.setRefrainFromScrolling(this.myRbPreferMovingCaret.isSelected());
        editorSettings.setVariableInplaceRenameEnabled(this.myCbRenameLocalVariablesInplace.isSelected());
        editorSettings.getOptions().SHOW_REFORMAT_DIALOG = this.myShowReformatCodeDialogCheckBox.isSelected();
        editorSettings.getOptions().SHOW_OPIMIZE_IMPORTS_DIALOG = this.myShowOptimizeImportsDialogCheckBox.isSelected();
        EditorOptionsPanel.reinitAllEditors();
        String temp = this.myRecentFilesLimitField.getText();
        if (temp.trim().length() > 0) {
            try {
                int newRecentFilesLimit = Integer.parseInt(temp);
                if (newRecentFilesLimit > 0 && uiSettings.RECENT_FILES_LIMIT != newRecentFilesLimit) {
                    uiSettings.RECENT_FILES_LIMIT = newRecentFilesLimit;
                    uiSettingsChanged = true;
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (uiSettingsChanged) {
            uiSettings.fireUISettingsChanged();
        }
        this.myErrorHighlightingPanel.apply();
        EditorOptionsPanel.restartDaemons();
    }

    public static void restartDaemons() {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project).settingsChanged();
        }
    }

    private static void clearAllIdentifierHighlighters() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                IdentifierHighlighterPass.clearMyHighlights(document, project);
            }
        }
    }

    public static void reinitAllEditors() {
        Editor[] editors;
        for (Editor editor : editors = EditorFactory.getInstance().getAllEditors()) {
            ((EditorEx)editor).reinitSettings();
        }
    }

    public void disposeUIResources() {
        this.myErrorHighlightingPanel.disposeUIResources();
    }

    private int getMaxClipboardContents() {
        int maxClipboardContents = -1;
        try {
            maxClipboardContents = Integer.parseInt(this.myClipboardContentLimitTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (maxClipboardContents <= 0) {
            maxClipboardContents = 1;
        }
        return maxClipboardContents;
    }

    public boolean isModified() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        UISettings uiSettings = UISettings.getInstance();
        boolean isModified = EditorOptionsPanel.isModified(this.myCbSmoothScrolling, editorSettings.isSmoothScrolling());
        isModified |= EditorOptionsPanel.isModified(this.myCbHighlightBraces, codeInsightSettings.HIGHLIGHT_BRACES);
        isModified |= EditorOptionsPanel.isModified(this.myCbHighlightScope, codeInsightSettings.HIGHLIGHT_SCOPE);
        isModified |= EditorOptionsPanel.isModified(this.myCbHighlightIdentifierUnderCaret, codeInsightSettings.HIGHLIGHT_IDENTIFIER_UNDER_CARET);
        isModified |= EditorOptionsPanel.isModified(this.myCbVirtualSpace, editorSettings.isVirtualSpace());
        isModified |= EditorOptionsPanel.isModified(this.myCbCaretInsideTabs, editorSettings.isCaretInsideTabs());
        isModified |= EditorOptionsPanel.isModified(this.myCbVirtualPageAtBottom, editorSettings.isAdditionalPageAtBottom());
        isModified |= this.getMaxClipboardContents() != uiSettings.MAX_CLIPBOARD_CONTENTS;
        isModified |= !this.getStripTrailingSpacesValue().equals(editorSettings.getStripTrailingSpaces());
        isModified |= EditorOptionsPanel.isModified(this.myCbEnsureBlankLineBeforeCheckBox, editorSettings.isEnsureNewLineAtEOF());
        isModified |= EditorOptionsPanel.isModified(this.myCbEnableDnD, editorSettings.isDndEnabled());
        isModified |= EditorOptionsPanel.isModified(this.myCbEnableWheelFontChange, editorSettings.isWheelFontChangeEnabled());
        isModified |= EditorOptionsPanel.isModified(this.myCbHonorCamelHumpsWhenSelectingByClicking, editorSettings.isMouseClickSelectionHonorsCamelWords());
        isModified |= this.myRbPreferMovingCaret.isSelected() != editorSettings.isRefrainFromScrolling();
        isModified |= EditorOptionsPanel.isModified(this.myRecentFilesLimitField, UISettings.getInstance().RECENT_FILES_LIMIT);
        isModified |= EditorOptionsPanel.isModified(this.myCbRenameLocalVariablesInplace, editorSettings.isVariableInplaceRenameEnabled());
        isModified |= EditorOptionsPanel.isModified(this.myShowReformatCodeDialogCheckBox, editorSettings.getOptions().SHOW_REFORMAT_DIALOG);
        isModified |= EditorOptionsPanel.isModified(this.myShowOptimizeImportsDialogCheckBox, editorSettings.getOptions().SHOW_OPIMIZE_IMPORTS_DIALOG);
        return isModified |= this.myErrorHighlightingPanel.isModified();
    }

    private static boolean isModified(JToggleButton checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(JTextField textField, int value) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String getStripTrailingSpacesValue() {
        Object selectedItem = this.myStripTrailingSpacesCombo.getSelectedItem();
        if (STRIP_NONE.equals(selectedItem)) {
            return "None";
        }
        if (STRIP_CHANGED.equals(selectedItem)) {
            return "Changed";
        }
        return "Whole";
    }

    public JComponent getComponent() {
        return this.myBehaviourPanel;
    }

    public Configurable getConfigurable() {
        return this.myConfigurable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JComboBox jComboBox;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JCheckBox jCheckBox12;
        JCheckBox jCheckBox13;
        JCheckBox jCheckBox14;
        JPanel jPanel2;
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.myBehaviourPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("messages/ApplicationBundle").getString("tab.editor.settings.behavior"), null, jPanel2, null);
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(334, 14), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(334, 106), null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.advanced.mouse.usages"), 0, 0, null, null));
        this.myCbHonorCamelHumpsWhenSelectingByClicking = jCheckBox14 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox14, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.honor.camelhumps.words.settings.on.double.click"));
        jPanel3.add((Component)jCheckBox14, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(328, 22), null));
        this.myCbEnableDnD = jCheckBox13 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox13, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.enable.drag.n.drop.functionality.in.editor"));
        jPanel3.add((Component)jCheckBox13, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(328, 22), null));
        this.myCbEnableWheelFontChange = jCheckBox12 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox12, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.enable.ctrl.mousewheel.changes.font.size"));
        jPanel3.add((Component)jCheckBox12, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(328, 22), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 1, 3, 0, 0, null, new Dimension(240, 45), null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.virtual.space"), 0, 0, null, null));
        this.myCbVirtualPageAtBottom = jCheckBox11 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.virtual.space.at.file.bottom"));
        jPanel4.add((Component)jCheckBox11, new GridConstraints(2, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myCbCaretInsideTabs = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.allow.placement.of.caret.inside.tabs"));
        jPanel4.add((Component)jCheckBox10, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbVirtualSpace = jCheckBox9 = new JCheckBox();
        jCheckBox9.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.allow.placement.of.caret.after.end.of.line"));
        jPanel4.add((Component)jCheckBox9, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(334, 106), null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Scrolling", 0, 0, null, null));
        this.myRbPreferScrolling = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Prefer scrolling editor canvas to keep caret line centered");
        jPanel5.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRbPreferMovingCaret = jRadioButton = new JRadioButton();
        jRadioButton.setText("Prefer moving caret line to minimize editor scrolling");
        jPanel5.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbSmoothScrolling = jCheckBox8 = new JCheckBox();
        jCheckBox8.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smooth.scrolling"));
        jPanel5.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(1, 1, 1, 1, 1, 3, 3, 0, null, new Dimension(215, 26), null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.brace.highlighting"), 0, 0, null, null));
        this.myCbHighlightScope = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.highlight.current.scope"));
        jPanel6.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbHighlightBraces = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.highlight.matched.brace"));
        jPanel6.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbHighlightIdentifierUnderCaret = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Highlight usages of element at caret");
        jPanel6.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 10, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(334, 80), null));
        this.myStripTrailingSpacesCombo = jComboBox = new JComboBox();
        jPanel7.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(42, 22), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.strip.trailing.spaces.on.save"));
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(248, 14), null));
        this.myCbRenameLocalVariablesInplace = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.rename.local.variables.inplace"));
        jPanel7.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(248, 22), null));
        this.myCbEnsureBlankLineBeforeCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Ensure blank line before end of file on Save");
        jCheckBox3.setMnemonic('B');
        jCheckBox3.setDisplayedMnemonicIndex(7);
        jPanel7.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(248, 14), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel8, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(null, "Formatting", 0, 0, null, null));
        this.myShowOptimizeImportsDialogCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show \"Optimize Imports\" dialog");
        jPanel8.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowReformatCodeDialogCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show \"Reformat Code\" dialog ");
        jPanel8.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel9, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(334, 75), null));
        jPanel9.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.limits"), 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.maximum.number.of.contents.to.keep.in.clipboard"));
        jPanel9.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 1, 0, 3, null, new Dimension(247, 14), null));
        this.myClipboardContentLimitTextField = jTextField2 = new JTextField();
        jTextField2.setText("5");
        jPanel9.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 9, 0, 6, 0, null, new Dimension(35, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.recent.files.limit"));
        jPanel9.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(247, 14), null));
        this.myRecentFilesLimitField = jTextField = new JTextField();
        jTextField.setText("10");
        jPanel9.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(35, -1), null));
        this.myHighlightSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public class MyConfigurable
    implements SearchableConfigurable {
        public String getId() {
            return "Editor.Behavior";
        }

        public Runnable enableSearch(String option) {
            return null;
        }

        public String getDisplayName() {
            return ApplicationBundle.message((String)"tab.editor.settings.behavior", (Object[])new Object[0]);
        }

        public Icon getIcon() {
            return null;
        }

        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            return EditorOptionsPanel.this.myBehaviourPanel;
        }

        public boolean isModified() {
            return EditorOptionsPanel.this.isModified();
        }

        public void apply() throws ConfigurationException {
            EditorOptionsPanel.this.apply();
        }

        public void reset() {
            EditorOptionsPanel.this.reset();
        }

        public void disposeUIResources() {
            EditorOptionsPanel.this.disposeUIResources();
        }
    }
}

