/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.SyntaxHighlighterColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CodeStyleImportsPanel
extends JPanel {
    private JCheckBox myCbUseFQClassNames;
    private JCheckBox myCbUseFQClassNamesInJavaDoc;
    private JCheckBox myCbUseSingleClassImports;
    private JCheckBox myCbInsertInnerClassImports;
    private JTextField myClassCountField;
    private JTextField myNamesCountField;
    private final PackageEntryTable myImportLayoutList;
    private final PackageEntryTable myPackageList;
    private Table myImportLayoutTable;
    private JButton myMoveUpButton;
    private JButton myMoveDownButton;
    private JButton myRemovePackageFromImportLayoutButton;
    private JButton myRemovePackageFromPackagesButton;
    private Table myPackageTable;
    private final CodeStyleSettings mySettings;
    private JRadioButton myJspImportCommaSeparated;
    private JRadioButton myJspOneImportPerDirective;
    private JPanel myGeneralPanel;
    private JPanel myJSPPanel;
    private JPanel myPackagesPanel;
    private JPanel myImportsLayoutPanel;
    private JPanel myWholePanel;
    private JCheckBox myCbLayoutStaticImportsSeparately;

    public CodeStyleImportsPanel(CodeStyleSettings settings) {
        this.$$$setupUI$$$();
        this.myImportLayoutList = new PackageEntryTable();
        this.myPackageList = new PackageEntryTable();
        this.mySettings = settings;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 4));
        this.add((Component)this.myWholePanel, "Center");
        this.myGeneralPanel.add((Component)this.createGeneralOptionsPanel(), "Center");
        this.myJSPPanel.add((Component)this.createJspImportLayoutPanel(), "Center");
        this.myImportsLayoutPanel.add((Component)this.createImportLayoutPanel(), "North");
        this.myPackagesPanel.add((Component)this.createPackagesPanel(), "North");
    }

    private JPanel createJspImportLayoutPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.myJspImportCommaSeparated = new JRadioButton(ApplicationBundle.message((String)"radio.prefer.comma.separated.import.list", (Object[])new Object[0]));
        this.myJspOneImportPerDirective = new JRadioButton(ApplicationBundle.message((String)"radio.prefer.one.import.statement.per.page.directive", (Object[])new Object[0]));
        buttonGroup.add(this.myJspImportCommaSeparated);
        buttonGroup.add(this.myJspOneImportPerDirective);
        JPanel btnPanel = new JPanel(new BorderLayout());
        btnPanel.add((Component)this.myJspImportCommaSeparated, "North");
        btnPanel.add((Component)this.myJspOneImportPerDirective, "Center");
        final MultiLineLabel commaSeparatedLabel = new MultiLineLabel("<% page import=\"com.company.Boo, \n                 com.company.Far\"%>");
        final MultiLineLabel oneImportPerDirectiveLabel = new MultiLineLabel("<% page import=\"com.company.Boo\"%>\n<% page import=\"com.company.Far\"%>");
        final JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.preview", (Object[])new Object[0])));
        JPanel resultPanel = new JPanel(new BorderLayout());
        resultPanel.add((Component)btnPanel, "North");
        resultPanel.add((Component)labelPanel, "Center");
        resultPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.jsp.imports.layout", (Object[])new Object[0])));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isComma = CodeStyleImportsPanel.this.myJspImportCommaSeparated.isSelected();
                labelPanel.removeAll();
                labelPanel.add((Component)(isComma ? commaSeparatedLabel : oneImportPerDirectiveLabel), "Center");
                labelPanel.repaint();
                labelPanel.revalidate();
            }
        };
        this.myJspImportCommaSeparated.addActionListener(actionListener);
        this.myJspOneImportPerDirective.addActionListener(actionListener);
        return resultPanel;
    }

    private JPanel createGeneralOptionsPanel() {
        OptionGroup group = new OptionGroup(ApplicationBundle.message((String)"title.general", (Object[])new Object[0]));
        this.myCbUseSingleClassImports = new JCheckBox(ApplicationBundle.message((String)"checkbox.use.single.class.import", (Object[])new Object[0]));
        group.add((JComponent)this.myCbUseSingleClassImports);
        this.myCbUseFQClassNames = new JCheckBox(ApplicationBundle.message((String)"checkbox.use.fully.qualified.class.names", (Object[])new Object[0]));
        group.add((JComponent)this.myCbUseFQClassNames);
        this.myCbInsertInnerClassImports = new JCheckBox(ApplicationBundle.message((String)"checkbox.insert.imports.for.inner.classes", (Object[])new Object[0]));
        group.add((JComponent)this.myCbInsertInnerClassImports);
        this.myCbUseFQClassNamesInJavaDoc = new JCheckBox(ApplicationBundle.message((String)"checkbox.use.fully.qualified.class.names.in.javadoc", (Object[])new Object[0]));
        group.add((JComponent)this.myCbUseFQClassNamesInJavaDoc);
        this.myClassCountField = new JTextField(3);
        this.myNamesCountField = new JTextField(3);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.class.count.to.use.import.with.star", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.myClassCountField, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 1, 0, 0), 0, 0));
        panel.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.names.count.to.use.static.import.with.star", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)this.myNamesCountField, new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 1, 0, 0), 0, 0));
        group.add((JComponent)panel);
        return group.createPanel();
    }

    private JPanel createPackagesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.packages.to.use.import.with", (Object[])new Object[0])));
        panel.add((Component)this.createPackagesTable(), "Center");
        panel.add((Component)this.createPackagesButtonsPanel(), "East");
        panel.setPreferredSize(new Dimension(-1, 200));
        return panel;
    }

    private JPanel createImportLayoutPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.import.layout", (Object[])new Object[0])));
        this.myCbLayoutStaticImportsSeparately = new JCheckBox("Layout static imports separately");
        this.myCbLayoutStaticImportsSeparately.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CodeStyleImportsPanel.this.areStaticImportsEnabled()) {
                    boolean found = false;
                    for (int i = CodeStyleImportsPanel.this.myImportLayoutList.getEntryCount() - 1; i >= 0; --i) {
                        PackageEntry entry = CodeStyleImportsPanel.this.myImportLayoutList.getEntryAt(i);
                        if (entry != PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        int index = CodeStyleImportsPanel.this.myImportLayoutList.getEntryCount();
                        if (index != 0 && CodeStyleImportsPanel.this.myImportLayoutList.getEntryAt(index - 1) != PackageEntry.BLANK_LINE_ENTRY) {
                            CodeStyleImportsPanel.this.myImportLayoutList.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                        }
                        CodeStyleImportsPanel.this.myImportLayoutList.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
                    }
                } else {
                    for (int i = CodeStyleImportsPanel.this.myImportLayoutList.getEntryCount() - 1; i >= 0; --i) {
                        PackageEntry entry = CodeStyleImportsPanel.this.myImportLayoutList.getEntryAt(i);
                        if (!entry.isStatic()) continue;
                        CodeStyleImportsPanel.this.myImportLayoutList.removeEntryAt(i);
                    }
                }
                CodeStyleImportsPanel.this.refreshTable(CodeStyleImportsPanel.this.myImportLayoutTable, CodeStyleImportsPanel.this.myImportLayoutList);
                CodeStyleImportsPanel.this.refreshTable(CodeStyleImportsPanel.this.myPackageTable, CodeStyleImportsPanel.this.myPackageList);
            }
        });
        panel.add((Component)this.myCbLayoutStaticImportsSeparately, "North");
        panel.add((Component)this.createImportLayoutTable(), "Center");
        panel.add((Component)this.createImportLayoutButtonsPanel(), "East");
        panel.setPreferredSize(new Dimension(-1, 200));
        return panel;
    }

    private void refreshTable(Table table, PackageEntryTable packageTable) {
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        table.createDefaultColumnsFromModel();
        model.fireTableDataChanged();
        this.resizeColumns(packageTable, table);
    }

    private boolean areStaticImportsEnabled() {
        return this.myCbLayoutStaticImportsSeparately.isSelected();
    }

    private JPanel createImportLayoutButtonsPanel() {
        JPanel tableButtonsPanel = new JPanel();
        tableButtonsPanel.setLayout(new BoxLayout(tableButtonsPanel, 1));
        JButton addPackageToImportLayoutButton = new JButton(ApplicationBundle.message((String)"button.add.package", (Object[])new Object[0]));
        tableButtonsPanel.add(addPackageToImportLayoutButton);
        addPackageToImportLayoutButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, addPackageToImportLayoutButton.getMaximumSize().height));
        JButton addBlankLineButton = new JButton(ApplicationBundle.message((String)"button.add.blank", (Object[])new Object[0]));
        tableButtonsPanel.add(addBlankLineButton);
        addBlankLineButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, addBlankLineButton.getMaximumSize().height));
        this.myMoveUpButton = new JButton(ApplicationBundle.message((String)"button.move.up", (Object[])new Object[0]));
        tableButtonsPanel.add(this.myMoveUpButton);
        this.myMoveUpButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.myMoveUpButton.getMaximumSize().height));
        this.myMoveDownButton = new JButton(ApplicationBundle.message((String)"button.move.down", (Object[])new Object[0]));
        tableButtonsPanel.add(this.myMoveDownButton);
        this.myMoveDownButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.myMoveDownButton.getMaximumSize().height));
        this.myRemovePackageFromImportLayoutButton = new JButton(ApplicationBundle.message((String)"button.remove", (Object[])new Object[0]));
        tableButtonsPanel.add(this.myRemovePackageFromImportLayoutButton);
        this.myRemovePackageFromImportLayoutButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.myRemovePackageFromImportLayoutButton.getMaximumSize().height));
        addPackageToImportLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleImportsPanel.this.addPackageToImportLayouts();
            }
        });
        addBlankLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleImportsPanel.this.addBlankLine();
            }
        });
        this.myRemovePackageFromImportLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleImportsPanel.this.removeEntryFromImportLayouts();
            }
        });
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleImportsPanel.this.moveRowUp();
            }
        });
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleImportsPanel.this.moveRowDown();
            }
        });
        return tableButtonsPanel;
    }

    private JPanel createPackagesButtonsPanel() {
        JPanel tableButtonsPanel = new JPanel();
        tableButtonsPanel.setLayout(new BoxLayout(tableButtonsPanel, 1));
        JButton addPackageToPackagesButton = new JButton(ApplicationBundle.message((String)"button.add.package.p", (Object[])new Object[0]));
        tableButtonsPanel.add(addPackageToPackagesButton);
        addPackageToPackagesButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, addPackageToPackagesButton.getMaximumSize().height));
        this.myRemovePackageFromPackagesButton = new JButton(ApplicationBundle.message((String)"button.remove.r", (Object[])new Object[0]));
        tableButtonsPanel.add(this.myRemovePackageFromPackagesButton);
        this.myRemovePackageFromPackagesButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.myRemovePackageFromPackagesButton.getMaximumSize().height));
        addPackageToPackagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleImportsPanel.this.addPackageToPackages();
            }
        });
        this.myRemovePackageFromPackagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeStyleImportsPanel.this.removeEntryFromPackages();
            }
        });
        return tableButtonsPanel;
    }

    private void addPackageToImportLayouts() {
        int selected = this.myImportLayoutTable.getSelectedRow() + 1;
        if (selected < 0) {
            selected = this.myImportLayoutList.getEntryCount();
        }
        PackageEntry entry = new PackageEntry(false, "", true);
        this.myImportLayoutList.insertEntryAt(entry, selected);
        CodeStyleImportsPanel.refreshTableModel(selected, this.myImportLayoutTable);
    }

    private static void refreshTableModel(int selectedRow, Table table) {
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        model.fireTableRowsInserted(selectedRow, selectedRow);
        table.setRowSelectionInterval(selectedRow, selectedRow);
        TableUtil.editCellAt((JTable)table, (int)selectedRow, (int)0);
        Component editorComp = table.getEditorComponent();
        if (editorComp != null) {
            editorComp.requestFocus();
        }
    }

    private void addPackageToPackages() {
        int selected = this.myPackageTable.getSelectedRow() + 1;
        if (selected < 0) {
            selected = this.myPackageList.getEntryCount();
        }
        PackageEntry entry = new PackageEntry(false, "", true);
        this.myPackageList.insertEntryAt(entry, selected);
        CodeStyleImportsPanel.refreshTableModel(selected, this.myPackageTable);
    }

    private void addBlankLine() {
        int selected = this.myImportLayoutTable.getSelectedRow() + 1;
        if (selected < 0) {
            selected = this.myImportLayoutList.getEntryCount();
        }
        this.myImportLayoutList.insertEntryAt(PackageEntry.BLANK_LINE_ENTRY, selected);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsInserted(selected, selected);
        this.myImportLayoutTable.setRowSelectionInterval(selected, selected);
    }

    private void removeEntryFromImportLayouts() {
        int selected = this.myImportLayoutTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        PackageEntry entry = this.myImportLayoutList.getEntryAt(selected);
        if (entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY || entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY) {
            return;
        }
        TableUtil.stopEditing((JTable)this.myImportLayoutTable);
        this.myImportLayoutList.removeEntryAt(selected);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsDeleted(selected, selected);
        if (selected >= this.myImportLayoutList.getEntryCount()) {
            --selected;
        }
        if (selected >= 0) {
            this.myImportLayoutTable.setRowSelectionInterval(selected, selected);
        }
    }

    private void removeEntryFromPackages() {
        int selected = this.myPackageTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        TableUtil.stopEditing((JTable)this.myPackageTable);
        this.myPackageList.removeEntryAt(selected);
        AbstractTableModel model = (AbstractTableModel)this.myPackageTable.getModel();
        model.fireTableRowsDeleted(selected, selected);
        if (selected >= this.myPackageList.getEntryCount()) {
            --selected;
        }
        if (selected >= 0) {
            this.myPackageTable.setRowSelectionInterval(selected, selected);
        }
    }

    private void moveRowUp() {
        int selected = this.myImportLayoutTable.getSelectedRow();
        if (selected < 1) {
            return;
        }
        TableUtil.stopEditing((JTable)this.myImportLayoutTable);
        PackageEntry entry = this.myImportLayoutList.getEntryAt(selected);
        PackageEntry previousEntry = this.myImportLayoutList.getEntryAt(selected - 1);
        this.myImportLayoutList.setEntryAt(previousEntry, selected);
        this.myImportLayoutList.setEntryAt(entry, selected - 1);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsUpdated(selected - 1, selected);
        this.myImportLayoutTable.setRowSelectionInterval(selected - 1, selected - 1);
    }

    private void moveRowDown() {
        int selected = this.myImportLayoutTable.getSelectedRow();
        if (selected >= this.myImportLayoutList.getEntryCount() - 1) {
            return;
        }
        TableUtil.stopEditing((JTable)this.myImportLayoutTable);
        PackageEntry entry = this.myImportLayoutList.getEntryAt(selected);
        PackageEntry nextEntry = this.myImportLayoutList.getEntryAt(selected + 1);
        this.myImportLayoutList.setEntryAt(nextEntry, selected);
        this.myImportLayoutList.setEntryAt(entry, selected + 1);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsUpdated(selected, selected + 1);
        this.myImportLayoutTable.setRowSelectionInterval(selected + 1, selected + 1);
    }

    private JComponent createPackagesTable() {
        this.myPackageTable = this.createTableForPackageEntries(this.myPackageList);
        return ScrollPaneFactory.createScrollPane((JComponent)this.myPackageTable);
    }

    private Table createTableForPackageEntries(final PackageEntryTable packageTable) {
        final String[] names = new String[]{ApplicationBundle.message((String)"listbox.import.package", (Object[])new Object[0]), ApplicationBundle.message((String)"listbox.import.with.subpackages", (Object[])new Object[0])};
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return names.length + (CodeStyleImportsPanel.this.areStaticImportsEnabled() ? 1 : 0);
            }

            @Override
            public int getRowCount() {
                return packageTable.getEntryCount();
            }

            @Override
            public Object getValueAt(int row, int col) {
                PackageEntry entry = packageTable.getEntryAt(row);
                if (entry == null || !this.isCellEditable(row, col)) {
                    return null;
                }
                if ((col += CodeStyleImportsPanel.this.areStaticImportsEnabled() ? 0 : 1) == 0) {
                    return entry.isStatic();
                }
                if (col == 1) {
                    return entry.getPackageName();
                }
                if (col == 2) {
                    return entry.isWithSubpackages() ? Boolean.TRUE : Boolean.FALSE;
                }
                throw new IllegalArgumentException(String.valueOf(col));
            }

            @Override
            public String getColumnName(int column) {
                if (CodeStyleImportsPanel.this.areStaticImportsEnabled() && column == 0) {
                    return "Static";
                }
                return names[column -= CodeStyleImportsPanel.this.areStaticImportsEnabled() ? 1 : 0];
            }

            public Class getColumnClass(int col) {
                if ((col += CodeStyleImportsPanel.this.areStaticImportsEnabled() ? 0 : 1) == 0) {
                    return Boolean.class;
                }
                if (col == 1) {
                    return String.class;
                }
                if (col == 2) {
                    return Boolean.class;
                }
                throw new IllegalArgumentException(String.valueOf(col));
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                PackageEntry packageEntry = packageTable.getEntryAt(row);
                return !packageEntry.isSpecial();
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                PackageEntry packageEntry = packageTable.getEntryAt(row);
                if ((col += CodeStyleImportsPanel.this.areStaticImportsEnabled() ? 0 : 1) == 0) {
                    PackageEntry newPackageEntry = new PackageEntry(((Boolean)aValue).booleanValue(), packageEntry.getPackageName(), packageEntry.isWithSubpackages());
                    packageTable.setEntryAt(newPackageEntry, row);
                } else if (col == 1) {
                    PackageEntry newPackageEntry = new PackageEntry(packageEntry.isStatic(), ((String)aValue).trim(), packageEntry.isWithSubpackages());
                    packageTable.setEntryAt(newPackageEntry, row);
                } else if (col == 2) {
                    PackageEntry newPackageEntry = new PackageEntry(packageEntry.isStatic(), packageEntry.getPackageName(), ((Boolean)aValue).booleanValue());
                    packageTable.setEntryAt(newPackageEntry, row);
                } else {
                    throw new IllegalArgumentException(String.valueOf(col));
                }
            }
        };
        final Table result = new Table((TableModel)dataModel);
        result.getSelectionModel().setSelectionMode(0);
        this.resizeColumns(packageTable, result);
        TableCellEditor editor = result.getDefaultEditor(String.class);
        if (editor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(1);
        }
        TableCellEditor beditor = result.getDefaultEditor(Boolean.class);
        beditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                if (CodeStyleImportsPanel.this.areStaticImportsEnabled()) {
                    result.repaint();
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        result.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CodeStyleImportsPanel.this.updateButtons();
            }
        });
        return result;
    }

    private void resizeColumns(final PackageEntryTable packageTable, Table result) {
        ColoredTableCellRenderer packageRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                PackageEntry entry = packageTable.getEntryAt(row);
                if (entry == PackageEntry.BLANK_LINE_ENTRY) {
                    this.append("                                               <blank line>", SimpleTextAttributes.LINK_ATTRIBUTES);
                } else {
                    TextAttributes attributes = SyntaxHighlighterColors.KEYWORD.getDefaultAttributes();
                    this.append("import", SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                    if (entry.isStatic()) {
                        this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.append("static", SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                    }
                    this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY || entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) {
                        this.append("all other imports", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        this.append(entry.getPackageName() + ".*", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            }
        };
        if (this.areStaticImportsEnabled()) {
            CodeStyleImportsPanel.fixColumnWidthToHeader(result, 0);
            CodeStyleImportsPanel.fixColumnWidthToHeader(result, 2);
            result.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)packageRenderer);
            result.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
            result.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        } else {
            CodeStyleImportsPanel.fixColumnWidthToHeader(result, 1);
            result.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)packageRenderer);
            result.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        }
    }

    private static void fixColumnWidthToHeader(Table result, int columnIdx) {
        TableColumn column = result.getColumnModel().getColumn(columnIdx);
        int width = result.getTableHeader().getFontMetrics(result.getTableHeader().getFont()).stringWidth(result.getColumnName(columnIdx)) + 6;
        column.setMinWidth(width);
        column.setMaxWidth(width);
    }

    private void updateButtons() {
        int selectedImport = this.myImportLayoutTable.getSelectedRow();
        this.myMoveUpButton.setEnabled(selectedImport >= 1);
        this.myMoveDownButton.setEnabled(selectedImport < this.myImportLayoutTable.getRowCount() - 1);
        PackageEntry entry = selectedImport < 0 ? null : this.myImportLayoutList.getEntryAt(selectedImport);
        boolean canRemove = entry != null && entry != PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY && entry != PackageEntry.ALL_OTHER_IMPORTS_ENTRY;
        this.myRemovePackageFromImportLayoutButton.setEnabled(canRemove);
        int selectedPackage = this.myPackageTable.getSelectedRow();
        this.myRemovePackageFromPackagesButton.setEnabled(selectedPackage >= 0);
    }

    private JComponent createImportLayoutTable() {
        this.myImportLayoutTable = this.createTableForPackageEntries(this.myImportLayoutList);
        return ScrollPaneFactory.createScrollPane((JComponent)this.myImportLayoutTable);
    }

    public void reset() {
        this.myCbUseFQClassNames.setSelected(this.mySettings.USE_FQ_CLASS_NAMES);
        this.myCbUseFQClassNamesInJavaDoc.setSelected(this.mySettings.USE_FQ_CLASS_NAMES_IN_JAVADOC);
        this.myCbUseSingleClassImports.setSelected(this.mySettings.USE_SINGLE_CLASS_IMPORTS);
        this.myCbInsertInnerClassImports.setSelected(this.mySettings.INSERT_INNER_CLASS_IMPORTS);
        this.myClassCountField.setText(Integer.toString(this.mySettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND));
        this.myNamesCountField.setText(Integer.toString(this.mySettings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND));
        this.myImportLayoutList.copyFrom(this.mySettings.IMPORT_LAYOUT_TABLE);
        this.myPackageList.copyFrom(this.mySettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        this.myCbLayoutStaticImportsSeparately.setSelected(this.mySettings.LAYOUT_STATIC_IMPORTS_SEPARATELY);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableDataChanged();
        model = (AbstractTableModel)this.myPackageTable.getModel();
        model.fireTableDataChanged();
        if (this.myImportLayoutTable.getRowCount() > 0) {
            this.myImportLayoutTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.myPackageTable.getRowCount() > 0) {
            this.myPackageTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (this.mySettings.JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST) {
            this.myJspImportCommaSeparated.doClick();
        } else {
            this.myJspOneImportPerDirective.doClick();
        }
        this.updateButtons();
    }

    public void apply() {
        this.stopTableEditing();
        this.mySettings.LAYOUT_STATIC_IMPORTS_SEPARATELY = this.areStaticImportsEnabled();
        this.mySettings.USE_FQ_CLASS_NAMES = this.myCbUseFQClassNames.isSelected();
        this.mySettings.USE_FQ_CLASS_NAMES_IN_JAVADOC = this.myCbUseFQClassNamesInJavaDoc.isSelected();
        this.mySettings.USE_SINGLE_CLASS_IMPORTS = this.myCbUseSingleClassImports.isSelected();
        this.mySettings.INSERT_INNER_CLASS_IMPORTS = this.myCbInsertInnerClassImports.isSelected();
        try {
            this.mySettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = Integer.parseInt(this.myClassCountField.getText());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.mySettings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = Integer.parseInt(this.myNamesCountField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.myImportLayoutList.removeEmptyPackages();
        this.mySettings.IMPORT_LAYOUT_TABLE.copyFrom(this.myImportLayoutList);
        this.myPackageList.removeEmptyPackages();
        this.mySettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(this.myPackageList);
        this.mySettings.JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST = this.myJspImportCommaSeparated.isSelected();
    }

    private void stopTableEditing() {
        TableUtil.stopEditing((JTable)this.myImportLayoutTable);
        TableUtil.stopEditing((JTable)this.myPackageTable);
    }

    public boolean isModified() {
        boolean isModified = CodeStyleImportsPanel.isModified(this.myCbLayoutStaticImportsSeparately, this.mySettings.LAYOUT_STATIC_IMPORTS_SEPARATELY);
        isModified |= CodeStyleImportsPanel.isModified(this.myCbUseFQClassNames, this.mySettings.USE_FQ_CLASS_NAMES);
        isModified |= CodeStyleImportsPanel.isModified(this.myCbUseFQClassNamesInJavaDoc, this.mySettings.USE_FQ_CLASS_NAMES_IN_JAVADOC);
        isModified |= CodeStyleImportsPanel.isModified(this.myCbUseSingleClassImports, this.mySettings.USE_SINGLE_CLASS_IMPORTS);
        isModified |= CodeStyleImportsPanel.isModified(this.myCbInsertInnerClassImports, this.mySettings.INSERT_INNER_CLASS_IMPORTS);
        isModified |= CodeStyleImportsPanel.isModified(this.myClassCountField, this.mySettings.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND);
        isModified |= CodeStyleImportsPanel.isModified(this.myNamesCountField, this.mySettings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND);
        isModified |= CodeStyleImportsPanel.isModified(this.myImportLayoutList, this.mySettings.IMPORT_LAYOUT_TABLE);
        isModified |= CodeStyleImportsPanel.isModified(this.myPackageList, this.mySettings.PACKAGES_TO_USE_IMPORT_ON_DEMAND);
        return isModified |= this.mySettings.JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST != this.myJspImportCommaSeparated.isSelected();
    }

    private static boolean isModified(JTextField textField, int value) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(PackageEntryTable list, PackageEntryTable table) {
        if (list.getEntryCount() != table.getEntryCount()) {
            return true;
        }
        for (int i = 0; i < list.getEntryCount(); ++i) {
            PackageEntry entry2;
            PackageEntry entry1 = list.getEntryAt(i);
            if (entry1.equals((Object)(entry2 = table.getEntryAt(i)))) continue;
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myWholePanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        this.myGeneralPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        jPanel5.add((Component)jPanel4, gridBagConstraints);
        this.myJSPPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        jPanel5.add((Component)jPanel3, gridBagConstraints2);
        this.myPackagesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.fill = 1;
        jPanel5.add((Component)jPanel2, gridBagConstraints3);
        this.myImportsLayoutPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.fill = 1;
        jPanel5.add((Component)jPanel, gridBagConstraints4);
        JPanel jPanel6 = new JPanel();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.fill = 3;
        jPanel5.add((Component)jPanel6, gridBagConstraints5);
        JPanel jPanel7 = new JPanel();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.fill = 2;
        jPanel5.add((Component)jPanel7, gridBagConstraints6);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

