/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.ListUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class CodeStyleGenerationConfigurable
implements Configurable {
    JPanel myPanel;
    private JTextField myFieldPrefixField;
    private JTextField myStaticFieldPrefixField;
    private JTextField myParameterPrefixField;
    private JTextField myLocalVariablePrefixField;
    private JTextField myFieldSuffixField;
    private JTextField myStaticFieldSuffixField;
    private JTextField myParameterSuffixField;
    private JTextField myLocalVariableSuffixField;
    private JCheckBox myCbPreferLongerNames;
    private JCheckBox myCbLineCommentAtFirstColumn;
    private JCheckBox myCbBlockCommentAtFirstColumn;
    private final MembersOrderList myMembersOrderList;
    private JScrollPane myMembersListScroll;
    private JButton myMoveUpButton;
    private JButton myMoveDownButton;
    private final CodeStyleSettings mySettings;
    private JCheckBox myCbGenerateFinalParameters;
    private JCheckBox myCbGenerateFinalLocals;
    private JCheckBox myCbUseExternalAnnotations;
    private JCheckBox myInsertOverrideAnnotationCheckBox;

    public CodeStyleGenerationConfigurable(CodeStyleSettings settings) {
        this.mySettings = settings;
        this.$$$setupUI$$$();
        this.myMembersOrderList = new MembersOrderList();
    }

    public JComponent createComponent() {
        this.myMembersListScroll.getViewport().add(this.myMembersOrderList);
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.moveSelectedItemsUp((JList)CodeStyleGenerationConfigurable.this.myMembersOrderList);
            }
        });
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.moveSelectedItemsDown((JList)CodeStyleGenerationConfigurable.this.myMembersOrderList);
            }
        });
        return this.myPanel;
    }

    public void disposeUIResources() {
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.code.generation", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.globalcodestyle.codegen";
    }

    public Icon getIcon() {
        return StdFileTypes.JAVA.getIcon();
    }

    public void reset() {
        this.myCbPreferLongerNames.setSelected(this.mySettings.PREFER_LONGER_NAMES);
        this.myFieldPrefixField.setText(this.mySettings.FIELD_NAME_PREFIX);
        this.myStaticFieldPrefixField.setText(this.mySettings.STATIC_FIELD_NAME_PREFIX);
        this.myParameterPrefixField.setText(this.mySettings.PARAMETER_NAME_PREFIX);
        this.myLocalVariablePrefixField.setText(this.mySettings.LOCAL_VARIABLE_NAME_PREFIX);
        this.myFieldSuffixField.setText(this.mySettings.FIELD_NAME_SUFFIX);
        this.myStaticFieldSuffixField.setText(this.mySettings.STATIC_FIELD_NAME_SUFFIX);
        this.myParameterSuffixField.setText(this.mySettings.PARAMETER_NAME_SUFFIX);
        this.myLocalVariableSuffixField.setText(this.mySettings.LOCAL_VARIABLE_NAME_SUFFIX);
        this.myCbLineCommentAtFirstColumn.setSelected(this.mySettings.LINE_COMMENT_AT_FIRST_COLUMN);
        this.myCbBlockCommentAtFirstColumn.setSelected(this.mySettings.BLOCK_COMMENT_AT_FIRST_COLUMN);
        this.myCbGenerateFinalLocals.setSelected(this.mySettings.GENERATE_FINAL_LOCALS);
        this.myCbGenerateFinalParameters.setSelected(this.mySettings.GENERATE_FINAL_PARAMETERS);
        this.myMembersOrderList.reset(this.mySettings);
        this.myCbUseExternalAnnotations.setSelected(this.mySettings.USE_EXTERNAL_ANNOTATIONS);
        this.myInsertOverrideAnnotationCheckBox.setSelected(this.mySettings.INSERT_OVERRIDE_ANNOTATION);
    }

    public void apply() {
        this.mySettings.PREFER_LONGER_NAMES = this.myCbPreferLongerNames.isSelected();
        this.mySettings.FIELD_NAME_PREFIX = this.myFieldPrefixField.getText().trim();
        this.mySettings.STATIC_FIELD_NAME_PREFIX = this.myStaticFieldPrefixField.getText().trim();
        this.mySettings.PARAMETER_NAME_PREFIX = this.myParameterPrefixField.getText().trim();
        this.mySettings.LOCAL_VARIABLE_NAME_PREFIX = this.myLocalVariablePrefixField.getText().trim();
        this.mySettings.FIELD_NAME_SUFFIX = this.myFieldSuffixField.getText().trim();
        this.mySettings.STATIC_FIELD_NAME_SUFFIX = this.myStaticFieldSuffixField.getText().trim();
        this.mySettings.PARAMETER_NAME_SUFFIX = this.myParameterSuffixField.getText().trim();
        this.mySettings.LOCAL_VARIABLE_NAME_SUFFIX = this.myLocalVariableSuffixField.getText().trim();
        this.mySettings.LINE_COMMENT_AT_FIRST_COLUMN = this.myCbLineCommentAtFirstColumn.isSelected();
        this.mySettings.BLOCK_COMMENT_AT_FIRST_COLUMN = this.myCbBlockCommentAtFirstColumn.isSelected();
        this.mySettings.GENERATE_FINAL_LOCALS = this.myCbGenerateFinalLocals.isSelected();
        this.mySettings.GENERATE_FINAL_PARAMETERS = this.myCbGenerateFinalParameters.isSelected();
        this.mySettings.USE_EXTERNAL_ANNOTATIONS = this.myCbUseExternalAnnotations.isSelected();
        this.mySettings.INSERT_OVERRIDE_ANNOTATION = this.myInsertOverrideAnnotationCheckBox.isSelected();
        this.myMembersOrderList.apply(this.mySettings);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project).settingsChanged();
        }
    }

    public boolean isModified() {
        boolean isModified = CodeStyleGenerationConfigurable.isModified(this.myCbPreferLongerNames, this.mySettings.PREFER_LONGER_NAMES);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myFieldPrefixField, this.mySettings.FIELD_NAME_PREFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myStaticFieldPrefixField, this.mySettings.STATIC_FIELD_NAME_PREFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myParameterPrefixField, this.mySettings.PARAMETER_NAME_PREFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myLocalVariablePrefixField, this.mySettings.LOCAL_VARIABLE_NAME_PREFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myFieldSuffixField, this.mySettings.FIELD_NAME_SUFFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myStaticFieldSuffixField, this.mySettings.STATIC_FIELD_NAME_SUFFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myParameterSuffixField, this.mySettings.PARAMETER_NAME_SUFFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myLocalVariableSuffixField, this.mySettings.LOCAL_VARIABLE_NAME_SUFFIX);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myCbLineCommentAtFirstColumn, this.mySettings.LINE_COMMENT_AT_FIRST_COLUMN);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myCbBlockCommentAtFirstColumn, this.mySettings.BLOCK_COMMENT_AT_FIRST_COLUMN);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myCbGenerateFinalLocals, this.mySettings.GENERATE_FINAL_LOCALS);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myCbGenerateFinalParameters, this.mySettings.GENERATE_FINAL_PARAMETERS);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myCbUseExternalAnnotations, this.mySettings.USE_EXTERNAL_ANNOTATIONS);
        isModified |= CodeStyleGenerationConfigurable.isModified(this.myInsertOverrideAnnotationCheckBox, this.mySettings.INSERT_OVERRIDE_ANNOTATION);
        return isModified |= this.myMembersOrderList.isModified(this.mySettings);
    }

    private static boolean isModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(JTextField textField, String value) {
        return !textField.getText().trim().equals(value);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JScrollPane jScrollPane;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JTextField jTextField7;
        JTextField jTextField8;
        JCheckBox jCheckBox7;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(5, 5, 5, 5), -1, 10, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.naming"), 0, 0, null, null));
        this.myCbPreferLongerNames = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.prefer.longer.names"));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 2, 1, 1, 3, 0, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.parameter"));
        jPanel3.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.static.field"));
        jPanel3.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.field"));
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.local.variable"));
        jPanel3.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myFieldPrefixField = jTextField8 = new JTextField();
        jTextField8.setText("");
        jPanel3.add((Component)jTextField8, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myStaticFieldPrefixField = jTextField7 = new JTextField();
        jPanel3.add((Component)jTextField7, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myParameterPrefixField = jTextField6 = new JTextField();
        jPanel3.add((Component)jTextField6, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myLocalVariablePrefixField = jTextField5 = new JTextField();
        jPanel3.add((Component)jTextField5, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myFieldSuffixField = jTextField4 = new JTextField();
        jPanel3.add((Component)jTextField4, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myStaticFieldSuffixField = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myParameterSuffixField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(3, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myLocalVariableSuffixField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(4, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.name.suffix"));
        jPanel3.add((Component)jLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.name.prefix"));
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(5, 5, 5, 5), 5, 0, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 1, 4, 1, 1, 3, 3, 0, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.order.of.members"), 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 3, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myMoveUpButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.move.up"));
        jPanel5.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, new Dimension(90, -1), null, null));
        this.myMoveDownButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.move.down"));
        jPanel5.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, new Dimension(90, -1), null, null));
        this.myMembersListScroll = jScrollPane = new JScrollPane();
        jPanel4.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.naming.comment.code"), 0, 0, null, null));
        this.myCbLineCommentAtFirstColumn = jCheckBox6 = new JCheckBox();
        jCheckBox6.setMargin(new Insets(5, 10, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.line.comment.at.first.column"));
        jCheckBox6.setLabel(ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.line.comment.at.first.column"));
        jPanel6.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbBlockCommentAtFirstColumn = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 10, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.block.comment.at.first.column"));
        jCheckBox5.setLabel(ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.block.comment.at.first.column"));
        jPanel6.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.naming.final.modifier"), 0, 0, null, null));
        this.myCbGenerateFinalLocals = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(5, 10, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.make.generated.local.variables.final"));
        jPanel7.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbGenerateFinalParameters = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(5, 10, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.make.generated.parameters.final"));
        jPanel7.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbUseExternalAnnotations = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("use.external.annotations"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myInsertOverrideAnnotationCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("insert.override.annotation"));
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MembersOrderList
    extends JList {
        private static final String FIELDS = ApplicationBundle.message((String)"listbox.members.order.fields", (Object[])new Object[0]);
        private static final String METHODS = ApplicationBundle.message((String)"listbox.members.order.methods", (Object[])new Object[0]);
        private static final String CONSTRUCTORS = ApplicationBundle.message((String)"listbox.members.order.constructors", (Object[])new Object[0]);
        private static final String INNER_CLASSES = ApplicationBundle.message((String)"listbox.members.order.inner.classes", (Object[])new Object[0]);
        private final DefaultListModel myModel = new DefaultListModel();

        public MembersOrderList() {
            this.setModel(this.myModel);
            this.setVisibleRowCount(4);
        }

        public void reset(CodeStyleSettings settings) {
            String[] strings;
            this.myModel.removeAllElements();
            for (String string : strings = MembersOrderList.getStrings(settings)) {
                this.myModel.addElement(string);
            }
            this.setSelectedIndex(0);
        }

        private static String[] getStrings(final CodeStyleSettings settings) {
            String[] strings = new String[]{FIELDS, METHODS, CONSTRUCTORS, INNER_CLASSES};
            Arrays.sort(strings, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int weight1 = this.getWeight(o1);
                    int weight2 = this.getWeight(o2);
                    return weight1 - weight2;
                }

                private int getWeight(String o) {
                    if (FIELDS.equals(o)) {
                        return settings.FIELDS_ORDER_WEIGHT;
                    }
                    if (METHODS.equals(o)) {
                        return settings.METHODS_ORDER_WEIGHT;
                    }
                    if (CONSTRUCTORS.equals(o)) {
                        return settings.CONSTRUCTORS_ORDER_WEIGHT;
                    }
                    if (INNER_CLASSES.equals(o)) {
                        return settings.INNER_CLASSES_ORDER_WEIGHT;
                    }
                    throw new IllegalArgumentException("unexpected " + o);
                }
            });
            return strings;
        }

        public void apply(CodeStyleSettings settings) {
            for (int i = 0; i < this.myModel.size(); ++i) {
                Object o = this.myModel.getElementAt(i);
                int weight = i + 1;
                if (FIELDS.equals(o)) {
                    settings.FIELDS_ORDER_WEIGHT = weight;
                    continue;
                }
                if (METHODS.equals(o)) {
                    settings.METHODS_ORDER_WEIGHT = weight;
                    continue;
                }
                if (CONSTRUCTORS.equals(o)) {
                    settings.CONSTRUCTORS_ORDER_WEIGHT = weight;
                    continue;
                }
                if (INNER_CLASSES.equals(o)) {
                    settings.INNER_CLASSES_ORDER_WEIGHT = weight;
                    continue;
                }
                throw new IllegalArgumentException("unexpected " + o);
            }
        }

        public boolean isModified(CodeStyleSettings settings) {
            Object[] oldStrings = MembersOrderList.getStrings(settings);
            Object[] newStrings = new String[this.myModel.size()];
            for (int i = 0; i < newStrings.length; ++i) {
                newStrings[i] = (String)this.myModel.getElementAt(i);
            }
            return !Arrays.equals(newStrings, oldStrings);
        }
    }
}

