/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class JavaAnalysisScope
extends AnalysisScope {
    public static final int PACKAGE = 5;

    public JavaAnalysisScope(PsiPackage pack, Module module) {
        super(pack.getProject());
        this.myModule = module;
        this.myElement = pack;
        this.myType = 5;
    }

    public JavaAnalysisScope(PsiJavaFile psiFile) {
        super((PsiFile)psiFile);
    }

    public AnalysisScope[] getNarrowedComplementaryScope(Project defaultProject) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)defaultProject).getFileIndex();
        HashSet modules = new HashSet();
        if (this.myType == 3) {
            if (this.myElement instanceof PsiJavaFile && !JspPsiUtil.isInJspFile((PsiElement)this.myElement)) {
                PsiDirectory psiDirectory;
                PsiJavaFile psiJavaFile = (PsiJavaFile)this.myElement;
                PsiClass[] classes = psiJavaFile.getClasses();
                boolean onlyPackLocalClasses = true;
                for (PsiClass aClass : classes) {
                    if (!aClass.hasModifierProperty("public")) continue;
                    onlyPackLocalClasses = false;
                }
                if (onlyPackLocalClasses && (psiDirectory = psiJavaFile.getContainingDirectory()) != null) {
                    return new AnalysisScope[]{new JavaAnalysisScope(JavaDirectoryService.getInstance().getPackage(psiDirectory), null)};
                }
            }
        } else if (this.myType == 5) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = ((PsiPackage)this.myElement).getDirectories()) {
                modules.addAll(JavaAnalysisScope.getAllInterestingModules((ProjectFileIndex)fileIndex, (VirtualFile)directory.getVirtualFile()));
            }
            return JavaAnalysisScope.collectScopes((Project)defaultProject, modules);
        }
        return super.getNarrowedComplementaryScope(defaultProject);
    }

    public String getShortenName() {
        if (this.myType == 5) {
            return AnalysisScopeBundle.message((String)"scope.package", (Object[])new Object[]{((PsiPackage)this.myElement).getQualifiedName()});
        }
        return super.getShortenName();
    }

    public String getDisplayName() {
        if (this.myType == 5) {
            return AnalysisScopeBundle.message((String)"scope.package", (Object[])new Object[]{((PsiPackage)this.myElement).getQualifiedName()});
        }
        return super.getDisplayName();
    }

    protected void initFilesSet() {
        if (this.myType == 5) {
            this.myFilesSet = new HashSet();
            this.accept(this.createFileSearcher());
            return;
        }
        super.initFilesSet();
    }

    protected void accept(PsiElementVisitor visitor, boolean needReadAction) {
        if (this.myElement instanceof PsiPackage) {
            final PsiPackage pack = (PsiPackage)this.myElement;
            final HashSet dirs = new HashSet();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    dirs.addAll(Arrays.asList(pack.getDirectories(GlobalSearchScope.projectScope((Project)JavaAnalysisScope.this.myElement.getProject()))));
                }
            });
            for (PsiDirectory dir : dirs) {
                this.accept(dir, visitor, needReadAction);
            }
        } else {
            super.accept(visitor, needReadAction);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SearchScope toSearchScope() {
        SearchScope searchScope;
        if (this.myType == 5) {
            searchScope = new PackageScope((PsiPackage)this.myElement, true, true);
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/analysis/JavaAnalysisScope.toSearchScope must not return null");
            return searchScope;
        }
        searchScope = super.toSearchScope();
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method com/intellij/analysis/JavaAnalysisScope.toSearchScope must not return null");
    }
}

