/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public abstract class FileSetTestCase
extends TestSuite {
    private final File[] myFiles;
    protected Project myProject;

    public FileSetTestCase(String path) {
        File f = new File(path);
        if (f.isDirectory()) {
            this.myFiles = f.listFiles();
        } else if (f.exists()) {
            this.myFiles = new File[]{f};
        } else {
            throw new IllegalArgumentException("invalid path: " + path);
        }
        this.addAllTests();
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void addAllTests() {
        for (File file : this.myFiles) {
            if (!file.isFile()) continue;
            this.addFileTest(file);
        }
    }

    public abstract String transform(String var1, String[] var2) throws Exception;

    protected FileSetTestCase(File[] files) {
        this.myFiles = files;
        this.addAllTests();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void addFileTest(File file) {
        if (!StringUtil.startsWithChar((CharSequence)file.getName(), (char)'_') && !"CVS".equals(file.getName())) {
            ActualTest t = new ActualTest(file);
            this.addTest((Test)t);
        }
    }

    protected String getDelimiter() {
        return "---";
    }

    private class ActualTest
    extends LightPlatformTestCase {
        private final File myTestFile;

        public ActualTest(File testFile) {
            this.myTestFile = testFile;
        }

        @Override
        protected void setUp() throws Exception {
            super.setUp();
            FileSetTestCase.this.setUp();
        }

        @Override
        protected void tearDown() throws Exception {
            FileSetTestCase.this.tearDown();
            super.tearDown();
        }

        public int countTestCases() {
            return 1;
        }

        protected void runTest() throws Throwable {
            int separatorIndex;
            String content = new String(FileUtil.loadFileText((File)this.myTestFile));
            ActualTest.assertNotNull((Object)content);
            ArrayList<String> input = new ArrayList<String>();
            content = StringUtil.replace((String)content, (String)"\r", (String)"");
            while ((separatorIndex = content.indexOf(FileSetTestCase.this.getDelimiter())) >= 0) {
                input.add(content.substring(0, separatorIndex));
                content = content.substring(separatorIndex);
                while (StringUtil.startsWithChar((CharSequence)content, (char)'-') || StringUtil.startsWithChar((CharSequence)content, (char)'\n')) {
                    content = content.substring(1);
                }
            }
            String result = content;
            ActualTest.assertTrue((String)"No data found in source file", (input.size() > 0 ? 1 : 0) != 0);
            while (StringUtil.startsWithChar((CharSequence)result, (char)'-') || StringUtil.startsWithChar((CharSequence)result, (char)'\n') || StringUtil.startsWithChar((CharSequence)result, (char)'\r')) {
                result = result.substring(1);
            }
            FileSetTestCase.this.myProject = ActualTest.getProject();
            String testName = this.myTestFile.getName();
            int dotIdx = testName.indexOf(46);
            if (dotIdx >= 0) {
                testName = testName.substring(0, dotIdx);
            }
            String transformed = StringUtil.replace((String)FileSetTestCase.this.transform(testName, ArrayUtil.toStringArray(input)), (String)"\r", (String)"");
            result = StringUtil.replace((String)result, (String)"\r", (String)"");
            ActualTest.assertEquals((String)result.trim(), (String)transformed.trim());
        }

        public String toString() {
            return this.myTestFile.getAbsolutePath() + " ";
        }

        @Override
        protected void resetAllFields() {
        }

        public String getName() {
            return this.myTestFile.getAbsolutePath();
        }
    }
}

