/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClassFinder {
    private final List<String> classNameList = new ArrayList<String>();
    private final int startPackageName;

    public ClassFinder(File classPathRoot, String packageRoot) throws IOException {
        this.startPackageName = classPathRoot.getAbsolutePath().length() + 1;
        String directoryOffset = packageRoot.replace('.', File.separatorChar);
        this.findAndStoreTestClasses(new File(classPathRoot, directoryOffset));
    }

    private String computeClassName(File file) {
        String absPath = file.getAbsolutePath();
        if (absPath.endsWith("Test.class")) {
            String packageBase = absPath.substring(this.startPackageName, absPath.length() - ".class".length());
            return packageBase.replace(File.separatorChar, '.');
        }
        return null;
    }

    private void findAndStoreTestClasses(File current) throws IOException {
        if (current.isDirectory()) {
            for (File file : current.listFiles()) {
                this.findAndStoreTestClasses(file);
            }
        } else {
            String className = this.computeClassName(current);
            if (className != null) {
                this.classNameList.add(className);
            }
        }
    }

    public Collection<String> getClasses() {
        return this.classNameList;
    }
}

