/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.GridChangeUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.actions.DeleteAction;
import com.intellij.uiDesigner.actions.GroupRowsColumnsAction;
import com.intellij.uiDesigner.actions.InsertAfterAction;
import com.intellij.uiDesigner.actions.InsertBeforeAction;
import com.intellij.uiDesigner.actions.SplitAction;
import com.intellij.uiDesigner.actions.UngroupRowsColumnsAction;
import com.intellij.uiDesigner.compiler.FormLayoutUtils;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FormFirstComponentInsertLocation;
import com.intellij.uiDesigner.designSurface.GridInsertLocation;
import com.intellij.uiDesigner.designSurface.GridInsertMode;
import com.intellij.uiDesigner.designSurface.NoDropLocation;
import com.intellij.uiDesigner.lw.FormLayoutSerializer;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractInsetsProperty;
import com.intellij.uiDesigner.propertyInspector.properties.AlignPropertyProvider;
import com.intellij.uiDesigner.propertyInspector.properties.HorzAlignProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VertAlignProperty;
import com.intellij.uiDesigner.radComponents.CustomPropertiesPanel;
import com.intellij.uiDesigner.radComponents.FormLayoutColumnProperties;
import com.intellij.uiDesigner.radComponents.RadAbstractGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import com.intellij.util.ArrayUtil;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadFormLayoutManager
extends RadAbstractGridLayoutManager
implements AlignPropertyProvider {
    private FormLayoutColumnProperties myPropertiesPanel;
    private final Map<RadComponent, MyPropertyChangeListener> myListenerMap = new HashMap<RadComponent, MyPropertyChangeListener>();
    @NonNls
    private static final String ENCODED_FORMSPEC_GROW = "d:grow";
    private static final Size DEFAULT_NOGROW_SIZE = new BoundedSize((Size)Sizes.DEFAULT, (Size)new ConstantSize(4, ConstantSize.PIXEL), null);

    @Override
    @Nullable
    public String getName() {
        return "FormLayout";
    }

    @Override
    @Nullable
    public LayoutManager createLayout() {
        return new FormLayout(ENCODED_FORMSPEC_GROW, ENCODED_FORMSPEC_GROW);
    }

    @Override
    protected void changeLayoutFromGrid(RadContainer container, List<RadComponent> contents, List<Boolean> canRowsGrow, List<Boolean> canColumnsGrow) {
        int i;
        int rowCount = canRowsGrow.size();
        int columnCount = canColumnsGrow.size();
        int rowCountWithGaps = rowCount == 0 ? 0 : rowCount * 2 - 1;
        int columnCountWithGaps = columnCount == 0 ? 0 : columnCount * 2 - 1;
        RowSpec[] rowSpecs = new RowSpec[rowCountWithGaps];
        ColumnSpec[] colSpecs = new ColumnSpec[columnCountWithGaps];
        for (i = 0; i < rowCount; ++i) {
            RowSpec rowSpec = rowSpecs[i * 2] = canRowsGrow.get(i) != false ? new RowSpec(ENCODED_FORMSPEC_GROW) : new RowSpec(DEFAULT_NOGROW_SIZE);
            if (i * 2 + 1 >= rowSpecs.length) continue;
            rowSpecs[i * 2 + 1] = FormFactory.RELATED_GAP_ROWSPEC;
        }
        for (i = 0; i < columnCount; ++i) {
            ColumnSpec columnSpec = colSpecs[i * 2] = canColumnsGrow.get(i) != false ? new ColumnSpec(ENCODED_FORMSPEC_GROW) : new ColumnSpec(DEFAULT_NOGROW_SIZE);
            if (i * 2 + 1 >= colSpecs.length) continue;
            colSpecs[i * 2 + 1] = FormFactory.RELATED_GAP_COLSPEC;
        }
        container.setLayoutManager(this, (LayoutManager)new FormLayout(colSpecs, rowSpecs));
    }

    @Override
    protected void changeLayoutFromIndexed(RadContainer container, List<RadComponent> components) {
        int maxSizePolicy = 0;
        for (RadComponent c : components) {
            maxSizePolicy = Math.max(maxSizePolicy, c.getConstraints().getHSizePolicy());
        }
        ColumnSpec[] colSpecs = new ColumnSpec[components.size() * 2 - 1];
        for (int i = 0; i < components.size(); ++i) {
            ColumnSpec columnSpec = colSpecs[i * 2] = components.get(i).getConstraints().getHSizePolicy() == maxSizePolicy ? new ColumnSpec(ENCODED_FORMSPEC_GROW) : FormFactory.DEFAULT_COLSPEC;
            if (i * 2 + 1 >= colSpecs.length) continue;
            colSpecs[i * 2 + 1] = FormFactory.RELATED_GAP_COLSPEC;
        }
        container.setLayoutManager(this, (LayoutManager)new FormLayout(colSpecs, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLayout(XmlWriter writer, RadContainer radContainer) {
        int i;
        FormLayout layout = (FormLayout)radContainer.getLayout();
        for (i = 1; i <= layout.getRowCount(); ++i) {
            RowSpec rowSpec = layout.getRowSpec(i);
            writer.startElement("rowspec");
            try {
                writer.addAttribute("value", FormLayoutUtils.getEncodedSpec((FormSpec)rowSpec));
                continue;
            }
            finally {
                writer.endElement();
            }
        }
        for (i = 1; i <= layout.getColumnCount(); ++i) {
            ColumnSpec columnSpec = layout.getColumnSpec(i);
            writer.startElement("colspec");
            try {
                writer.addAttribute("value", FormLayoutUtils.getEncodedSpec((FormSpec)columnSpec));
                continue;
            }
            finally {
                writer.endElement();
            }
        }
        RadFormLayoutManager.writeGroups(writer, "rowgroup", layout.getRowGroups());
        RadFormLayoutManager.writeGroups(writer, "colgroup", layout.getColumnGroups());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeGroups(XmlWriter writer, String elementName, int[][] groups) {
        for (int[] group : groups) {
            writer.startElement(elementName);
            try {
                for (int member : group) {
                    writer.startElement("member");
                    writer.addAttribute("index", member);
                    writer.endElement();
                }
            }
            finally {
                writer.endElement();
            }
        }
    }

    @Override
    public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
        MyPropertyChangeListener listener = new MyPropertyChangeListener(component);
        this.myListenerMap.put(component, listener);
        component.addPropertyChangeListener(listener);
        CellConstraints cc = RadFormLayoutManager.gridToCellConstraints(component);
        if (component.getCustomLayoutConstraints() instanceof CellConstraints) {
            CellConstraints customCellConstraints = (CellConstraints)component.getCustomLayoutConstraints();
            cc.insets = customCellConstraints.insets;
        }
        component.setCustomLayoutConstraints(cc);
        container.getDelegee().add(component.getDelegee(), cc, index);
    }

    @Override
    public void removeComponentFromContainer(RadContainer container, RadComponent component) {
        MyPropertyChangeListener listener = this.myListenerMap.get(component);
        if (listener != null) {
            component.removePropertyChangeListener(listener);
            this.myListenerMap.remove(component);
        }
        super.removeComponentFromContainer(container, component);
    }

    private static CellConstraints gridToCellConstraints(RadComponent component) {
        CellConstraints.Alignment vAlign;
        GridConstraints gc = component.getConstraints();
        CellConstraints.Alignment hAlign = (gc.getHSizePolicy() & 4) != 0 ? CellConstraints.FILL : CellConstraints.DEFAULT;
        CellConstraints.Alignment alignment = vAlign = (gc.getVSizePolicy() & 4) != 0 ? CellConstraints.FILL : CellConstraints.DEFAULT;
        if (component.getCustomLayoutConstraints() instanceof CellConstraints) {
            CellConstraints cc = (CellConstraints)component.getCustomLayoutConstraints();
            hAlign = cc.hAlign;
            vAlign = cc.vAlign;
        }
        return new CellConstraints(gc.getColumn() + 1, gc.getRow() + 1, gc.getColSpan(), gc.getRowSpan(), hAlign, vAlign);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeChildConstraints(XmlWriter writer, RadComponent child) {
        RadFormLayoutManager.writeGridConstraints(writer, child);
        if (child.getCustomLayoutConstraints() instanceof CellConstraints) {
            CellConstraints cc = (CellConstraints)child.getCustomLayoutConstraints();
            writer.startElement("forms");
            try {
                if (!cc.insets.equals(new Insets(0, 0, 0, 0))) {
                    writer.addAttribute("top", cc.insets.top);
                    writer.addAttribute("left", cc.insets.left);
                    writer.addAttribute("bottom", cc.insets.bottom);
                    writer.addAttribute("right", cc.insets.right);
                }
                if (cc.hAlign != CellConstraints.DEFAULT) {
                    writer.addAttribute("defaultalign-horz", false);
                }
                if (cc.vAlign != CellConstraints.DEFAULT) {
                    writer.addAttribute("defaultalign-vert", false);
                }
            }
            finally {
                writer.endElement();
            }
        }
    }

    private static FormLayout getFormLayout(RadContainer container) {
        return (FormLayout)container.getLayout();
    }

    @Override
    public int getGridRowCount(RadContainer container) {
        return RadFormLayoutManager.getFormLayout(container).getRowCount();
    }

    @Override
    public int getGridColumnCount(RadContainer container) {
        return RadFormLayoutManager.getFormLayout(container).getColumnCount();
    }

    @Override
    public int[] getGridCellCoords(RadContainer container, boolean isRow) {
        FormLayout.LayoutInfo layoutInfo = RadFormLayoutManager.getFormLayout(container).getLayoutInfo((Container)container.getDelegee());
        int[] origins = isRow ? layoutInfo.rowOrigins : layoutInfo.columnOrigins;
        int[] result = new int[origins.length - 1];
        System.arraycopy(origins, 0, result, 0, result.length);
        return result;
    }

    @Override
    public int[] getGridCellSizes(RadContainer container, boolean isRow) {
        FormLayout.LayoutInfo layoutInfo = RadFormLayoutManager.getFormLayout(container).getLayoutInfo((Container)container.getDelegee());
        int[] origins = isRow ? layoutInfo.rowOrigins : layoutInfo.columnOrigins;
        int[] result = new int[origins.length - 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = origins[i + 1] - origins[i];
        }
        return result;
    }

    @Override
    public int[] getHorizontalGridLines(RadContainer container) {
        FormLayout.LayoutInfo layoutInfo = RadFormLayoutManager.getFormLayout(container).getLayoutInfo((Container)container.getDelegee());
        return layoutInfo.rowOrigins;
    }

    @Override
    public int[] getVerticalGridLines(RadContainer container) {
        FormLayout.LayoutInfo layoutInfo = RadFormLayoutManager.getFormLayout(container).getLayoutInfo((Container)container.getDelegee());
        return layoutInfo.columnOrigins;
    }

    @Override
    public int getGridRowAt(RadContainer container, int y) {
        FormLayout.LayoutInfo layoutInfo = RadFormLayoutManager.getFormLayout(container).getLayoutInfo((Container)container.getDelegee());
        return RadFormLayoutManager.findCell(layoutInfo.rowOrigins, y);
    }

    @Override
    public int getGridColumnAt(RadContainer container, int x) {
        FormLayout.LayoutInfo layoutInfo = RadFormLayoutManager.getFormLayout(container).getLayoutInfo((Container)container.getDelegee());
        return RadFormLayoutManager.findCell(layoutInfo.columnOrigins, x);
    }

    private static int findCell(int[] origins, int coord) {
        for (int i = 0; i < origins.length - 1; ++i) {
            if (coord < origins[i] || coord >= origins[i + 1]) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ComponentDropLocation getDropLocation(@NotNull RadContainer container, @Nullable Point location) {
        ComponentDropLocation componentDropLocation;
        if (container == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/radComponents/RadFormLayoutManager.getDropLocation must not be null");
        }
        FormLayout formLayout = RadFormLayoutManager.getFormLayout(container);
        if ((formLayout.getRowCount() == 0 || formLayout.getColumnCount() == 0) && location != null) {
            Rectangle rc = new Rectangle(new Point(), container.getDelegee().getSize());
            componentDropLocation = new FormFirstComponentInsertLocation(container, location, rc);
            if (componentDropLocation == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/radComponents/RadFormLayoutManager.getDropLocation must not return null");
            return componentDropLocation;
        }
        FormLayout.LayoutInfo layoutInfo = formLayout.getLayoutInfo((Container)container.getDelegee());
        if (location != null && location.x > layoutInfo.getWidth()) {
            int row = RadFormLayoutManager.findCell(layoutInfo.rowOrigins, location.y);
            if (!(row == -1 ? (componentDropLocation = NoDropLocation.INSTANCE) != null : (componentDropLocation = new GridInsertLocation(container, row, this.getGridColumnCount(container) - 1, GridInsertMode.ColumnAfter)) != null)) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/radComponents/RadFormLayoutManager.getDropLocation must not return null");
            return componentDropLocation;
        }
        if (location != null && location.y > layoutInfo.getHeight()) {
            int column = RadFormLayoutManager.findCell(layoutInfo.columnOrigins, location.x);
            if (!(column == -1 ? (componentDropLocation = NoDropLocation.INSTANCE) != null : (componentDropLocation = new GridInsertLocation(container, this.getGridRowCount(container) - 1, column, GridInsertMode.RowAfter)) != null)) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/radComponents/RadFormLayoutManager.getDropLocation must not return null");
            return componentDropLocation;
        }
        if (container.getGridRowCount() == 1 && container.getGridColumnCount() == 1 && RadFormLayoutManager.getComponentAtGrid(container, 0, 0) == null) {
            Rectangle rc = this.getGridCellRangeRect(container, 0, 0, 0, 0);
            if (!(location == null ? (componentDropLocation = new FormFirstComponentInsertLocation(container, rc, 0, 0)) != null : (componentDropLocation = new FormFirstComponentInsertLocation(container, location, rc)) != null)) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/radComponents/RadFormLayoutManager.getDropLocation must not return null");
            return componentDropLocation;
        }
        componentDropLocation = super.getDropLocation(container, location);
        if (componentDropLocation != null) return componentDropLocation;
        throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/radComponents/RadFormLayoutManager.getDropLocation must not return null");
    }

    @Override
    public CustomPropertiesPanel getRowColumnPropertiesPanel(RadContainer container, boolean isRow, int[] selectedIndices) {
        if (this.myPropertiesPanel == null) {
            this.myPropertiesPanel = new FormLayoutColumnProperties();
        }
        this.myPropertiesPanel.showProperties(container, isRow, selectedIndices);
        return this.myPropertiesPanel;
    }

    @Override
    public ActionGroup getCaptionActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new InsertBeforeAction());
        group.add((AnAction)new InsertAfterAction());
        group.add((AnAction)new SplitAction());
        group.add((AnAction)new DeleteAction());
        group.add((AnAction)new GroupRowsColumnsAction());
        group.add((AnAction)new UngroupRowsColumnsAction());
        return group;
    }

    @Override
    public boolean canCellGrow(RadContainer container, boolean isRow, int index) {
        FormLayout layout = (FormLayout)container.getLayout();
        RowSpec spec = isRow ? layout.getRowSpec(index + 1) : layout.getColumnSpec(index + 1);
        return spec.getResizeWeight() > 0.01;
    }

    @Override
    public void setChildDragging(RadComponent child, boolean dragging) {
    }

    @Override
    public void paintCaptionDecoration(RadContainer container, boolean isRow, int index, Graphics2D g2d, Rectangle rc) {
        if (this.isGapCell(container, isRow, index)) {
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        if (this.canCellGrow(container, isRow, index)) {
            RadFormLayoutManager.drawGrowMarker(isRow, g2d, rc);
        }
        FormLayout layout = (FormLayout)container.getLayout();
        int[][] groups = isRow ? layout.getRowGroups() : layout.getColumnGroups();
        boolean haveTopLeft = false;
        boolean haveTopRight = false;
        boolean haveTopLine = false;
        boolean haveBottomLeft = false;
        boolean haveBottomRight = false;
        boolean haveBottomLine = false;
        boolean inGroup = false;
        for (int i = 0; i < groups.length; ++i) {
            int minMember = Integer.MAX_VALUE;
            int maxMember = -1;
            for (int member : groups[i]) {
                minMember = Math.min(member - 1, minMember);
                maxMember = Math.max(member - 1, maxMember);
                inGroup = inGroup || member - 1 == index;
            }
            if (minMember > index || index > maxMember) continue;
            if (i % 2 == 0) {
                haveTopLeft = haveTopLeft || index > minMember;
                haveTopRight = haveTopRight || index < maxMember;
                haveTopLine = haveTopLine || inGroup;
                continue;
            }
            haveBottomLeft = haveBottomLeft || index > minMember;
            haveBottomRight = haveBottomRight || index < maxMember;
            haveBottomLine = haveBottomLine || inGroup;
        }
        g2d.setColor(Color.BLUE);
        RadFormLayoutManager.drawGroupLine(rc, isRow, g2d, true, haveTopLeft, haveTopRight, haveTopLine);
        RadFormLayoutManager.drawGroupLine(rc, isRow, g2d, false, haveBottomLeft, haveBottomRight, haveBottomLine);
    }

    private static void drawGroupLine(Rectangle rc, boolean isRow, Graphics2D g2d, boolean isTop, boolean haveLeft, boolean haveRight, boolean haveLine) {
        int maxX = (int)rc.getMaxX();
        int maxY = (int)rc.getMaxY();
        Point linePos = isTop ? new Point(rc.x + 1, rc.y + 1) : new Point(rc.x + 3, rc.y + 3);
        Point markerPos = new Point(rc.x + 6, rc.y + 6);
        int midX = (int)rc.getCenterX();
        int midY = (int)rc.getCenterY();
        if (haveLine) {
            if (isRow) {
                g2d.drawLine(linePos.x, midY, markerPos.x, midY);
            } else {
                g2d.drawLine(midX, linePos.y, midX, markerPos.y);
            }
        }
        if (haveLeft) {
            if (isRow) {
                g2d.drawLine(linePos.x, rc.y, linePos.x, midY);
            } else {
                g2d.drawLine(rc.x, linePos.y, midX, linePos.y);
            }
        }
        if (haveRight) {
            if (isRow) {
                g2d.drawLine(linePos.x, midY, linePos.x, maxY);
            } else {
                g2d.drawLine(midX, linePos.y, maxX, linePos.y);
            }
        }
    }

    @Override
    public Property[] getContainerProperties(Project project) {
        return Property.EMPTY_ARRAY;
    }

    @Override
    public Property[] getComponentProperties(Project project, RadComponent component) {
        return new Property[]{HorzAlignProperty.getInstance(project), VertAlignProperty.getInstance(project), new ComponentInsetsProperty()};
    }

    @Override
    public int insertGridCells(RadContainer grid, int cellIndex, boolean isRow, boolean isBefore, boolean grow) {
        Object formSpec = isRow ? (grow ? new RowSpec(ENCODED_FORMSPEC_GROW) : new RowSpec(DEFAULT_NOGROW_SIZE)) : (grow ? new ColumnSpec(ENCODED_FORMSPEC_GROW) : new ColumnSpec(DEFAULT_NOGROW_SIZE));
        this.insertGridCells(grid, cellIndex, isRow, isBefore, (FormSpec)formSpec);
        return this.getGridCellCount(grid, isRow) == 1 ? 1 : 2;
    }

    @Override
    public void copyGridCells(RadContainer source, RadContainer destination, boolean isRow, int cellIndex, int cellCount, int targetIndex) {
        FormLayout sourceLayout = RadFormLayoutManager.getFormLayout(source);
        FormLayout destinationLayout = RadFormLayoutManager.getFormLayout(destination);
        if (isRow) {
            RadFormLayoutManager.insertOrAppendRow(destinationLayout, targetIndex + 1, FormFactory.RELATED_GAP_ROWSPEC);
        } else {
            RadFormLayoutManager.insertOrAppendColumn(destinationLayout, targetIndex + 1, FormFactory.RELATED_GAP_COLSPEC);
        }
        if (++targetIndex < cellIndex) {
            ++cellIndex;
        }
        RadFormLayoutManager.copyFormSpecs(sourceLayout, destinationLayout, isRow, cellIndex, cellCount, targetIndex);
        RadFormLayoutManager.updateGridConstraintsFromCellConstraints(destination);
    }

    private static void copyFormSpecs(FormLayout sourceLayout, FormLayout destinationLayout, boolean isRow, int cellIndex, int cellCount, int targetIndex) {
        for (int i = 0; i < cellCount; ++i) {
            if (isRow) {
                RowSpec rowSpec = sourceLayout.getRowSpec(cellIndex + 1);
                RadFormLayoutManager.insertOrAppendRow(destinationLayout, targetIndex + 1, rowSpec);
            } else {
                ColumnSpec colSpec = sourceLayout.getColumnSpec(cellIndex + 1);
                RadFormLayoutManager.insertOrAppendColumn(destinationLayout, targetIndex + 1, colSpec);
            }
            cellIndex += targetIndex < cellIndex && sourceLayout == destinationLayout ? 2 : 1;
            ++targetIndex;
        }
    }

    @Override
    public void copyGridSection(RadContainer source, RadContainer destination, Rectangle rc) {
        FormLayout destinationLayout = new FormLayout();
        destination.setLayout((LayoutManager)destinationLayout);
        RadFormLayoutManager.copyFormSpecs(RadFormLayoutManager.getFormLayout(source), destinationLayout, true, rc.y, rc.height, 0);
        RadFormLayoutManager.copyFormSpecs(RadFormLayoutManager.getFormLayout(source), destinationLayout, false, rc.x, rc.width, 0);
    }

    @Override
    public int getGapCellCount() {
        return 1;
    }

    @Override
    public int getGapCellSize(RadContainer container, boolean isRow) {
        Size size;
        Size size2 = size = isRow ? FormFactory.RELATED_GAP_ROWSPEC.getSize() : FormFactory.RELATED_GAP_COLSPEC.getSize();
        if (size instanceof ConstantSize) {
            return ((ConstantSize)size).getPixelSize((Component)container.getDelegee());
        }
        return 0;
    }

    @Override
    public boolean isGapCell(RadContainer grid, boolean isRow, int cellIndex) {
        GridChangeUtil.CellStatus status;
        if (cellIndex < 0 || cellIndex >= this.getGridCellCount(grid, isRow)) {
            return false;
        }
        return cellIndex % 2 == 1 && ((status = GridChangeUtil.canDeleteCell(grid, cellIndex, isRow)) == GridChangeUtil.CellStatus.Empty || status == GridChangeUtil.CellStatus.Redundant);
    }

    @Override
    public int getCellIndexBase() {
        return 1;
    }

    private int insertGridCells(RadContainer grid, int cellIndex, boolean isRow, boolean isBefore, FormSpec formSpec) {
        int index;
        FormLayout formLayout = (FormLayout)grid.getLayout();
        int n = index = isBefore ? cellIndex + 1 : cellIndex + 2;
        if (isRow) {
            if (this.getGridCellCount(grid, true) > 0) {
                RadFormLayoutManager.insertOrAppendRow(formLayout, index, FormFactory.RELATED_GAP_ROWSPEC);
                if (!isBefore) {
                    ++index;
                }
            }
            RadFormLayoutManager.insertOrAppendRow(formLayout, index, (RowSpec)formSpec);
        } else {
            if (this.getGridCellCount(grid, false) > 0) {
                RadFormLayoutManager.insertOrAppendColumn(formLayout, index, FormFactory.RELATED_GAP_COLSPEC);
                if (!isBefore) {
                    ++index;
                }
            }
            RadFormLayoutManager.insertOrAppendColumn(formLayout, index, (ColumnSpec)formSpec);
        }
        RadFormLayoutManager.updateGridConstraintsFromCellConstraints(grid);
        return index - 1;
    }

    private static void insertOrAppendRow(FormLayout formLayout, int index, RowSpec rowSpec) {
        if (index == formLayout.getRowCount() + 1) {
            formLayout.appendRow(rowSpec);
        } else {
            formLayout.insertRow(index, rowSpec);
        }
    }

    private static void insertOrAppendColumn(FormLayout formLayout, int index, ColumnSpec columnSpec) {
        if (index == formLayout.getColumnCount() + 1) {
            formLayout.appendColumn(columnSpec);
        } else {
            formLayout.insertColumn(index, columnSpec);
        }
    }

    @Override
    public int deleteGridCells(RadContainer grid, int cellIndex, boolean isRow) {
        int result = 1;
        FormLayout formLayout = (FormLayout)grid.getLayout();
        this.adjustDeletedCellOrigins(grid, cellIndex, isRow);
        if (isRow) {
            int[][] groupIndices = formLayout.getRowGroups();
            groupIndices = RadFormLayoutManager.removeDeletedCell(groupIndices, cellIndex + 1);
            formLayout.setRowGroups(groupIndices);
            formLayout.removeRow(cellIndex + 1);
            RadFormLayoutManager.updateGridConstraintsFromCellConstraints(grid);
            if (formLayout.getRowCount() > 0 && formLayout.getRowCount() % 2 == 0) {
                int gapRowIndex;
                int n = gapRowIndex = cellIndex >= grid.getGridRowCount() ? cellIndex - 1 : cellIndex;
                if (GridChangeUtil.isRowEmpty(grid, gapRowIndex)) {
                    formLayout.removeRow(gapRowIndex + 1);
                    RadFormLayoutManager.updateGridConstraintsFromCellConstraints(grid);
                    ++result;
                }
            }
        } else {
            int[][] groupIndices = formLayout.getColumnGroups();
            groupIndices = RadFormLayoutManager.removeDeletedCell(groupIndices, cellIndex + 1);
            formLayout.setColumnGroups(groupIndices);
            formLayout.removeColumn(cellIndex + 1);
            RadFormLayoutManager.updateGridConstraintsFromCellConstraints(grid);
            if (formLayout.getColumnCount() > 0 && formLayout.getColumnCount() % 2 == 0) {
                int gapColumnIndex;
                int n = gapColumnIndex = cellIndex >= grid.getGridColumnCount() ? cellIndex - 1 : cellIndex;
                if (GridChangeUtil.isColumnEmpty(grid, gapColumnIndex)) {
                    formLayout.removeColumn(gapColumnIndex + 1);
                    RadFormLayoutManager.updateGridConstraintsFromCellConstraints(grid);
                    ++result;
                }
            }
        }
        return result;
    }

    private void adjustDeletedCellOrigins(RadContainer grid, int cellIndex, boolean isRow) {
        int gapCellDelta = this.isGapCell(grid, isRow, cellIndex + 1) ? 2 : 1;
        for (RadComponent component : grid.getComponents()) {
            GridConstraints gc = component.getConstraints();
            if (gc.getCell(isRow) != cellIndex) continue;
            int span = gc.getSpan(isRow);
            if (span > gapCellDelta) {
                gc.setCell(isRow, cellIndex + gapCellDelta);
                gc.setSpan(isRow, span - gapCellDelta);
                RadFormLayoutManager.updateConstraints(component);
                continue;
            }
            throw new IllegalArgumentException("Attempt to delete grid row/column which contains origins of 1-span components");
        }
    }

    private static int[][] removeDeletedCell(int[][] groupIndices, int deletedIndex) {
        for (int i = 0; i < groupIndices.length; ++i) {
            for (int j = 0; j < groupIndices[i].length; ++j) {
                int[][] newIndices;
                if (groupIndices[i][j] != deletedIndex) continue;
                if (groupIndices[i].length <= 2) {
                    int newI;
                    newIndices = new int[groupIndices.length - 1][];
                    for (newI = 0; newI < i; ++newI) {
                        newIndices[newI] = new int[groupIndices[newI].length];
                        System.arraycopy(groupIndices[newI], 0, newIndices[newI], 0, groupIndices[newI].length);
                    }
                    for (newI = i + 1; newI < groupIndices.length; ++newI) {
                        newIndices[newI - 1] = new int[groupIndices[newI].length];
                        System.arraycopy(groupIndices[newI], 0, newIndices[newI - 1], 0, groupIndices[newI].length);
                    }
                } else {
                    newIndices = new int[groupIndices.length][];
                    for (int newI = 0; newI < groupIndices.length; ++newI) {
                        if (newI == i) {
                            newIndices[newI] = new int[groupIndices[newI].length - 1];
                            System.arraycopy(groupIndices[newI], 0, newIndices[newI], 0, j);
                            System.arraycopy(groupIndices[newI], j + 1, newIndices[newI], j, groupIndices[i].length - j - 1);
                            continue;
                        }
                        newIndices[newI] = new int[groupIndices[newI].length];
                        System.arraycopy(groupIndices[newI], 0, newIndices[newI], 0, groupIndices[i].length);
                    }
                }
                return newIndices;
            }
        }
        return groupIndices;
    }

    @Override
    @Nullable
    public String getCellResizeTooltip(RadContainer container, boolean isRow, int cell, int newSize) {
        String size = RadFormLayoutManager.getUpdatedSize(container, isRow, cell, newSize).toString();
        return isRow ? UIDesignerBundle.message("tooltip.resize.row", cell + this.getCellIndexBase(), size) : UIDesignerBundle.message("tooltip.resize.column", cell + this.getCellIndexBase(), size);
    }

    @Override
    public void processCellResized(RadContainer container, boolean isRow, int cell, int newSize) {
        RowSpec newSpec;
        FormLayout formLayout = (FormLayout)container.getLayout();
        ConstantSize updatedSize = RadFormLayoutManager.getUpdatedSize(container, isRow, cell, newSize);
        if (isRow) {
            RowSpec rowSpec = formLayout.getRowSpec(cell + 1);
            newSpec = new RowSpec(rowSpec.getDefaultAlignment(), (Size)updatedSize, rowSpec.getResizeWeight());
        } else {
            ColumnSpec colSpec = formLayout.getColumnSpec(cell + 1);
            newSpec = new ColumnSpec(colSpec.getDefaultAlignment(), (Size)updatedSize, colSpec.getResizeWeight());
        }
        RadFormLayoutManager.setSpec(formLayout, (FormSpec)newSpec, cell + 1, isRow);
        RadFormLayoutManager.resizeSameGroupCells(cell, formLayout, (FormSpec)newSpec, isRow);
    }

    private static void resizeSameGroupCells(int cell, FormLayout formLayout, FormSpec newSpec, boolean isRow) {
        int[][] groups;
        for (int[] group : groups = isRow ? formLayout.getRowGroups() : formLayout.getColumnGroups()) {
            boolean foundGroup = false;
            for (int groupCell : group) {
                if (groupCell != cell + 1) continue;
                foundGroup = true;
                break;
            }
            if (!foundGroup) continue;
            for (int groupCell : group) {
                RadFormLayoutManager.setSpec(formLayout, newSpec, groupCell, isRow);
            }
            break;
        }
    }

    private static void setSpec(FormLayout formLayout, FormSpec newSpec, int cell, boolean isRow) {
        if (isRow) {
            formLayout.setRowSpec(cell, (RowSpec)newSpec);
        } else {
            formLayout.setColumnSpec(cell, (ColumnSpec)newSpec);
        }
    }

    private static ConstantSize getUpdatedSize(RadContainer container, boolean isRow, int cell, int newPx) {
        FormLayout formLayout = (FormLayout)container.getLayout();
        if (isRow) {
            return RadFormLayoutManager.scaleSize((FormSpec)formLayout.getRowSpec(cell + 1), container, newPx);
        }
        return RadFormLayoutManager.scaleSize((FormSpec)formLayout.getColumnSpec(cell + 1), container, newPx);
    }

    private static ConstantSize scaleSize(FormSpec rowSpec, RadContainer container, int newPx) {
        if (rowSpec.getSize() instanceof ConstantSize) {
            ConstantSize oldSize = (ConstantSize)rowSpec.getSize();
            int oldPx = oldSize.getPixelSize((Component)container.getDelegee());
            double newValue = Math.round(oldSize.getValue() * (double)newPx / (double)oldPx * 10.0) / 10L;
            return new ConstantSize(newValue, oldSize.getUnit());
        }
        return new ConstantSize(newPx, ConstantSize.PIXEL);
    }

    @Override
    public void processCellsMoved(RadContainer container, boolean isRow, int[] cellsToMove, int targetCell) {
        for (int i = 0; i < cellsToMove.length; ++i) {
            int sourceCell = cellsToMove[i];
            this.moveCells(container, isRow, sourceCell, targetCell);
            if (sourceCell < targetCell) {
                int j = i + 1;
                while (j < cellsToMove.length) {
                    int n = j++;
                    cellsToMove[n] = cellsToMove[n] - 2;
                }
                continue;
            }
            targetCell += 2;
        }
    }

    private void moveCells(RadContainer container, boolean isRow, int cell, int targetCell) {
        if (targetCell >= cell && targetCell <= cell + 2) {
            return;
        }
        FormLayout layout = (FormLayout)container.getLayout();
        ArrayList<RadComponent> componentsToMove = new ArrayList<RadComponent>();
        RowSpec oldSpec = isRow ? layout.getRowSpec(cell + 1) : layout.getColumnSpec(cell + 1);
        for (RadComponent c : container.getComponents()) {
            if (c.getConstraints().getCell(isRow) != cell) continue;
            componentsToMove.add(c);
            container.removeComponent(c);
        }
        int count = this.deleteGridCells(container, cell, isRow);
        int insertCell = targetCell > cell ? targetCell - count - 1 : targetCell;
        boolean isBefore = targetCell < cell;
        int newIndex = this.insertGridCells(container, insertCell, isRow, isBefore, (FormSpec)oldSpec);
        for (RadComponent c : componentsToMove) {
            c.getConstraints().setCell(isRow, newIndex);
            container.addComponent(c);
        }
    }

    private static void updateGridConstraintsFromCellConstraints(RadContainer grid) {
        FormLayout layout = (FormLayout)grid.getLayout();
        for (RadComponent c : grid.getComponents()) {
            CellConstraints cc = layout.getConstraints((Component)c.getDelegee());
            GridConstraints gc = c.getConstraints();
            RadFormLayoutManager.copyCellToGridConstraints(gc, cc);
        }
    }

    private static void copyCellToGridConstraints(GridConstraints gc, CellConstraints cc) {
        gc.setColumn(cc.gridX - 1);
        gc.setRow(cc.gridY - 1);
        gc.setColSpan(cc.gridWidth);
        gc.setRowSpan(cc.gridHeight);
    }

    @Override
    public int getAlignment(RadComponent component, boolean horizontal) {
        CellConstraints.Alignment al;
        CellConstraints cc = (CellConstraints)component.getCustomLayoutConstraints();
        CellConstraints.Alignment alignment = al = horizontal ? cc.hAlign : cc.vAlign;
        if (al == CellConstraints.DEFAULT) {
            FormLayout formLayout = (FormLayout)component.getParent().getLayout();
            Object formSpec = horizontal ? formLayout.getColumnSpec(component.getConstraints().getColumn() + 1) : formLayout.getRowSpec(component.getConstraints().getRow() + 1);
            FormSpec.DefaultAlignment defaultAlignment = formSpec.getDefaultAlignment();
            if (defaultAlignment.equals(RowSpec.FILL)) {
                return 3;
            }
            if (defaultAlignment.equals(RowSpec.TOP) || defaultAlignment.equals(ColumnSpec.LEFT)) {
                return 0;
            }
            if (defaultAlignment.equals(RowSpec.CENTER)) {
                return 1;
            }
            return 2;
        }
        return Utils.alignFromConstraints((GridConstraints)component.getConstraints(), (boolean)horizontal);
    }

    @Override
    public void setAlignment(RadComponent component, boolean horizontal, int alignment) {
        CellConstraints cc = (CellConstraints)component.getCustomLayoutConstraints();
        if (horizontal) {
            cc.hAlign = FormLayoutSerializer.ourHorizontalAlignments[alignment];
        } else {
            cc.vAlign = FormLayoutSerializer.ourVerticalAlignments[alignment];
        }
        RadFormLayoutManager.updateConstraints(component);
    }

    @Override
    public void resetAlignment(RadComponent component, boolean horizontal) {
        CellConstraints cc = (CellConstraints)component.getCustomLayoutConstraints();
        if (horizontal) {
            cc.hAlign = CellConstraints.DEFAULT;
        } else {
            cc.vAlign = CellConstraints.DEFAULT;
        }
        RadFormLayoutManager.updateConstraints(component);
    }

    @Override
    public boolean isAlignmentModified(RadComponent component, boolean horizontal) {
        CellConstraints cc = (CellConstraints)component.getCustomLayoutConstraints();
        CellConstraints.Alignment al = horizontal ? cc.hAlign : cc.vAlign;
        return al != CellConstraints.DEFAULT;
    }

    private static void updateConstraints(RadComponent component) {
        FormLayout layout = (FormLayout)component.getParent().getLayout();
        layout.setConstraints((Component)component.getDelegee(), RadFormLayoutManager.gridToCellConstraints(component));
        component.getParent().revalidate();
    }

    @Override
    public int getMinCellCount() {
        return 0;
    }

    @Override
    public void createSnapshotLayout(SnapshotContext context, JComponent parent, RadContainer container, LayoutManager layout) {
        int[][] columnGroups;
        int[][] rowGroups;
        ColumnSpec[] colSpecs;
        RowSpec[] rowSpecs;
        try {
            int i;
            Method method = layout.getClass().getMethod("getRowCount", ArrayUtil.EMPTY_CLASS_ARRAY);
            int rowCount = (Integer)method.invoke((Object)layout, ArrayUtil.EMPTY_OBJECT_ARRAY);
            method = layout.getClass().getMethod("getColumnCount", ArrayUtil.EMPTY_CLASS_ARRAY);
            int columnCount = (Integer)method.invoke((Object)layout, ArrayUtil.EMPTY_OBJECT_ARRAY);
            rowSpecs = new RowSpec[rowCount];
            colSpecs = new ColumnSpec[columnCount];
            method = layout.getClass().getMethod("getRowSpec", Integer.TYPE);
            for (i = 0; i < rowCount; ++i) {
                rowSpecs[i] = (RowSpec)RadFormLayoutManager.createSerializedCopy(method.invoke((Object)layout, i + 1));
            }
            method = layout.getClass().getMethod("getColumnSpec", Integer.TYPE);
            for (i = 0; i < columnCount; ++i) {
                colSpecs[i] = (ColumnSpec)RadFormLayoutManager.createSerializedCopy(method.invoke((Object)layout, i + 1));
            }
            method = layout.getClass().getMethod("getRowGroups", ArrayUtil.EMPTY_CLASS_ARRAY);
            rowGroups = (int[][])method.invoke((Object)layout, new Object[0]);
            method = layout.getClass().getMethod("getColumnGroups", ArrayUtil.EMPTY_CLASS_ARRAY);
            columnGroups = (int[][])method.invoke((Object)layout, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        FormLayout formLayout = new FormLayout(colSpecs, rowSpecs);
        formLayout.setRowGroups(rowGroups);
        formLayout.setColumnGroups(columnGroups);
        container.setLayout((LayoutManager)formLayout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object createSerializedCopy(Object original) {
        Object copy;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(baos);
            try {
                os.writeObject(original);
            }
            finally {
                os.close();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream is = new ObjectInputStream(bais);
            try {
                copy = is.readObject();
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return copy;
    }

    @Override
    public void addSnapshotComponent(JComponent parent, JComponent child, RadContainer container, RadComponent component) {
        CellConstraints cc;
        try {
            LayoutManager layout = parent.getLayout();
            Method method = layout.getClass().getMethod("getConstraints", Component.class);
            cc = (CellConstraints)RadFormLayoutManager.createSerializedCopy(method.invoke((Object)layout, child));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        RadFormLayoutManager.copyCellToGridConstraints(component.getConstraints(), cc);
        component.setCustomLayoutConstraints(cc);
        container.addComponent(component);
    }

    private static class ComponentInsetsProperty
    extends AbstractInsetsProperty<RadComponent> {
        public ComponentInsetsProperty() {
            super(null, "Insets");
        }

        @Override
        public Insets getValue(RadComponent component) {
            if (component.getCustomLayoutConstraints() instanceof CellConstraints) {
                CellConstraints cellConstraints = (CellConstraints)component.getCustomLayoutConstraints();
                return cellConstraints.insets;
            }
            return new Insets(0, 0, 0, 0);
        }

        @Override
        protected void setValueImpl(RadComponent component, Insets value) throws Exception {
            if (component.getCustomLayoutConstraints() instanceof CellConstraints) {
                CellConstraints cellConstraints = (CellConstraints)component.getCustomLayoutConstraints();
                cellConstraints.insets = value;
                FormLayout layout = (FormLayout)component.getParent().getLayout();
                CellConstraints cc = (CellConstraints)layout.getConstraints((Component)component.getDelegee()).clone();
                cc.insets = value;
                layout.setConstraints((Component)component.getDelegee(), cc);
            }
        }
    }

    private static class MyPropertyChangeListener
    implements PropertyChangeListener {
        private final RadComponent myComponent;

        public MyPropertyChangeListener(RadComponent component) {
            this.myComponent = component;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("constraints")) {
                RadFormLayoutManager.updateConstraints(this.myComponent);
            }
        }
    }
}

