/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.properties.IndentProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IncreaseIndentAction
extends AbstractGuiEditorAction {
    private final IndentProperty myIndentProperty = new IndentProperty();

    public IncreaseIndentAction() {
        super(true);
    }

    @Override
    protected void actionPerformed(GuiEditor editor, List<RadComponent> selection, AnActionEvent e) {
        for (RadComponent c : selection) {
            int indent = this.myIndentProperty.getValue(c);
            this.myIndentProperty.setValueEx(c, this.adjustIndent(indent));
        }
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/actions/IncreaseIndentAction.update must not be null");
        }
        e.getPresentation().setVisible(this.canAdjustIndent(selection));
    }

    private boolean canAdjustIndent(ArrayList<RadComponent> selection) {
        for (RadComponent c : selection) {
            if (!this.canAdjustIndent(c)) continue;
            return true;
        }
        return false;
    }

    protected int adjustIndent(int indent) {
        return indent + 1;
    }

    protected boolean canAdjustIndent(RadComponent component) {
        return component.getParent().getLayout() instanceof GridLayoutManager;
    }
}

