/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCreateFormAction
extends CreateElementActionBase
implements DumbAware {
    public AbstractCreateFormAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
            if (view != null) {
                PsiDirectory[] dirs;
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                for (PsiDirectory dir : dirs = view.getDirectories()) {
                    if (!projectFileIndex.isInSourceContent(dir.getVirtualFile()) || JavaDirectoryService.getInstance().getPackage(dir) == null) continue;
                    return;
                }
            }
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }
    }

    protected String createFormBody(@Nullable String fullQualifiedClassName, @NonNls String formName, String layoutManager) throws IncorrectOperationException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(formName);
        StringBuffer buffer = new StringBuffer();
        try {
            int ch;
            while ((ch = inputStream.read()) != -1) {
                buffer.append((char)ch);
            }
        }
        catch (IOException e) {
            throw new IncorrectOperationException(UIDesignerBundle.message("error.cannot.read", formName), (Exception)e);
        }
        String s = buffer.toString();
        s = fullQualifiedClassName != null ? StringUtil.replace((String)s, (String)"$CLASS$", (String)fullQualifiedClassName) : StringUtil.replace((String)s, (String)"bind-to-class=\"$CLASS$\"", (String)"");
        s = StringUtil.replace((String)s, (String)"$LAYOUT$", (String)layoutManager);
        return StringUtil.convertLineSeparators((String)s);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return UIDesignerBundle.message("progress.creating.class", JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName(), newName);
    }
}

