/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.ui.CvsTabbedWindowComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ui.ErrorTreeView;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CvsTabbedWindow {
    private final Project myProject;
    private Editor myOutput = null;
    private ErrorTreeView myErrorsView;
    private boolean myIsInitialized;
    private boolean myIsDisposed;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.ui.CvsTabbedWindow");
    private ContentManager myContentManager;

    public CvsTabbedWindow(Project project) {
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                if (CvsTabbedWindow.this.myOutput != null) {
                    EditorFactory.getInstance().releaseEditor(CvsTabbedWindow.this.myOutput);
                    CvsTabbedWindow.this.myOutput = null;
                }
                if (CvsTabbedWindow.this.myErrorsView != null) {
                    CvsTabbedWindow.this.myErrorsView.dispose();
                    CvsTabbedWindow.this.myErrorsView = null;
                }
                LOG.assertTrue(!CvsTabbedWindow.this.myIsDisposed);
                try {
                    if (!CvsTabbedWindow.this.myIsInitialized) {
                        return;
                    }
                    ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)CvsTabbedWindow.this.myProject);
                    toolWindowManager.unregisterToolWindow(ToolWindowId.CVS);
                }
                finally {
                    CvsTabbedWindow.this.myIsDisposed = true;
                }
            }
        });
    }

    private void initialize() {
        if (this.myIsInitialized) {
            return;
        }
        this.myIsInitialized = true;
        this.myIsDisposed = false;
        this.myContentManager = ContentFactory.SERVICE.getInstance().createContentManager(true, this.myProject);
        this.myContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(ContentManagerEvent event) {
                JComponent removedComponent;
                JComponent component = event.getContent().getComponent();
                JComponent jComponent = removedComponent = component instanceof CvsTabbedWindowComponent ? ((CvsTabbedWindowComponent)component).getComponent() : component;
                if (removedComponent == CvsTabbedWindow.this.myErrorsView) {
                    CvsTabbedWindow.this.myErrorsView.dispose();
                    CvsTabbedWindow.this.myErrorsView = null;
                } else if (CvsTabbedWindow.this.myOutput != null && removedComponent == CvsTabbedWindow.this.myOutput.getComponent()) {
                    EditorFactory.getInstance().releaseEditor(CvsTabbedWindow.this.myOutput);
                    CvsTabbedWindow.this.myOutput = null;
                }
            }
        });
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.CVS, this.myContentManager.getComponent(), ToolWindowAnchor.BOTTOM);
        toolWindow.setIcon(IconLoader.getIcon((String)"/_cvs/cvs.png"));
        toolWindow.installWatcher(this.myContentManager);
    }

    public static CvsTabbedWindow getInstance(Project project) {
        return (CvsTabbedWindow)ServiceManager.getService((Project)project, CvsTabbedWindow.class);
    }

    private int getComponentAt(int i, boolean select) {
        if (select) {
            this.getContentManager().setSelectedContent(this.getContentManager().getContent(i));
        }
        return i;
    }

    public int addTab(String s, JComponent component, boolean selectTab, boolean replaceContent, boolean lockable, boolean addDefaultToolbar, @Nullable ActionGroup toolbarActions, @NonNls String helpId) {
        int existing = this.getComponentNumNamed(s);
        if (existing != -1) {
            Content existingContent = this.getContentManager().getContent(existing);
            JComponent existingComponent = existingContent.getComponent();
            if (existingComponent instanceof DeactivateListener) {
                ((DeactivateListener)((Object)existingComponent)).deactivated();
            }
            if (!replaceContent) {
                this.getContentManager().setSelectedContent(existingContent);
                return existing;
            }
            if (!existingContent.isPinned()) {
                this.getContentManager().removeContent(existingContent, true);
                existingContent.release();
            }
        }
        CvsTabbedWindowComponent newComponent = new CvsTabbedWindowComponent(component, addDefaultToolbar, toolbarActions, this.getContentManager(), helpId);
        Content content = ContentFactory.SERVICE.getInstance().createContent(newComponent.getShownComponent(), s, lockable);
        newComponent.setContent(content);
        this.getContentManager().addContent(content);
        return this.getComponentAt(this.getContentManager().getContentCount() - 1, selectTab);
    }

    private int getComponentNumNamed(String s) {
        for (int i = 0; i < this.getContentManager().getContentCount(); ++i) {
            if (!s.equals(this.getContentManager().getContent(i).getDisplayName())) continue;
            return i;
        }
        return -1;
    }

    public Editor addOutput(Editor output) {
        LOG.assertTrue(this.myOutput == null);
        if (this.myOutput == null) {
            this.addTab(CvsBundle.message((String)"tab.title.cvs.output", (Object[])new Object[0]), output.getComponent(), false, false, false, true, null, "cvs.cvsOutput");
            this.myOutput = output;
        }
        return this.myOutput;
    }

    public ErrorTreeView addErrorsTreeView(ErrorTreeView view) {
        if (this.myErrorsView == null) {
            this.addTab(CvsBundle.message((String)"tab.title.errors", (Object[])new Object[0]), view.getComponent(), true, false, true, false, null, "cvs.errors");
            this.myErrorsView = view;
        }
        return this.myErrorsView;
    }

    public void hideErrors() {
    }

    public void ensureVisible(Project project) {
        ToolWindow toolWindow;
        if (project == null) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        if (toolWindowManager != null && (toolWindow = toolWindowManager.getToolWindow(ToolWindowId.CVS)) != null) {
            toolWindow.activate(null, false);
        }
    }

    public ContentManager getContentManager() {
        this.initialize();
        return this.myContentManager;
    }

    public Editor getOutput() {
        return this.myOutput;
    }

    public static interface DeactivateListener {
        public void deactivated();
    }
}

