/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.ui;

import com.intellij.CvsBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

public class SelectTagDialog
extends DialogWrapper {
    private final Collection<JList> myLists = new ArrayList<JList>();
    private final JPanel myPanel = new JPanel(new GridLayout(1, 0, 4, 8));
    public static final String EXISTING_REVISIONS = CvsBundle.message((String)"label.existing.revisions", (Object[])new Object[0]);
    public static final String EXISTING_TAGS = CvsBundle.message((String)"label.existing.tags", (Object[])new Object[0]);

    public SelectTagDialog(Collection<String> tags, Collection<String> revisions) {
        super(true);
        if (tags.isEmpty()) {
            this.createList(CvsBundle.message((String)"dialog.title.select.revision", (Object[])new Object[0]), revisions, EXISTING_REVISIONS);
        } else if (revisions.isEmpty()) {
            this.createList(CvsBundle.message((String)"operation.name.select.tag", (Object[])new Object[0]), tags, EXISTING_TAGS);
        } else {
            this.createList(CvsBundle.message((String)"dialog.title.select.revision.or.tag", (Object[])new Object[0]), revisions, EXISTING_REVISIONS);
            this.createList(CvsBundle.message((String)"dialog.title.select.revision.or.tag", (Object[])new Object[0]), tags, EXISTING_TAGS);
        }
        this.setOkEnabled();
        this.init();
    }

    private void createList(String title, Collection<String> data, String listDescription) {
        this.setTitle(title);
        final JList list = new JList();
        this.myLists.add(list);
        list.setSelectionMode(0);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (list.getSelectedValue() != null) {
                    SelectTagDialog.this.cancelOtherSelections(list);
                }
                SelectTagDialog.this.setOkEnabled();
            }
        });
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1 && SelectTagDialog.this.isOKActionEnabled()) {
                    SelectTagDialog.this.doOKAction();
                }
            }
        });
        SelectTagDialog.fillList(data, list);
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)new JLabel(listDescription, 2), "North");
        panel.add((Component)ScrollPaneFactory.createScrollPane(list), "Center");
        this.myPanel.add(panel);
    }

    private void cancelOtherSelections(JList list) {
        for (JList jlist : this.myLists) {
            if (jlist == list) continue;
            jlist.getSelectionModel().clearSelection();
        }
    }

    private void setOkEnabled() {
        this.setOKActionEnabled(this.hasSelection());
    }

    private boolean hasSelection() {
        for (JList list : this.myLists) {
            if (list.getSelectedValue() == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getTag() {
        for (JList list : this.myLists) {
            Object selectedValue = list.getSelectedValue();
            if (selectedValue == null) continue;
            return selectedValue.toString();
        }
        return null;
    }

    private static void fillList(Collection<String> tags, JList list) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        list.setModel(model);
        for (String tag : tags) {
            model.addElement(tag);
        }
        if (!tags.isEmpty()) {
            list.getSelectionModel().addSelectionInterval(0, 0);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }
}

