/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsIgnore;

import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.cvsIgnore.IgnoredFilesInfo;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;

public class IgnoredFilesInfoImpl
implements IgnoredFilesInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsIgnore.IgnoredFilesInfoImpl");
    private static final SimpleStringPattern[] PREDEFINED_PATTERNS = new SimpleStringPattern[]{new SimpleStringPattern("RCS"), new SimpleStringPattern("SCCS"), new SimpleStringPattern("CVS"), new SimpleStringPattern("CVS.adm"), new SimpleStringPattern("RCSLOG"), new SimpleStringPattern("cvslog.*"), new SimpleStringPattern("tags"), new SimpleStringPattern("TAGS"), new SimpleStringPattern(".make.state"), new SimpleStringPattern(".nse_depinfo"), new SimpleStringPattern("*~"), new SimpleStringPattern("#*"), new SimpleStringPattern(".#*"), new SimpleStringPattern(",*"), new SimpleStringPattern("_$*"), new SimpleStringPattern("*$"), new SimpleStringPattern("*.old"), new SimpleStringPattern("*.bak"), new SimpleStringPattern("*.BAK"), new SimpleStringPattern("*.orig"), new SimpleStringPattern("*.rej"), new SimpleStringPattern(".del-*"), new SimpleStringPattern("*.a"), new SimpleStringPattern("*.olb"), new SimpleStringPattern("*.o"), new SimpleStringPattern("*.obj"), new SimpleStringPattern("*.so"), new SimpleStringPattern("*.exe"), new SimpleStringPattern("*.Z"), new SimpleStringPattern("*.elc"), new SimpleStringPattern("*.ln"), new SimpleStringPattern("core")};
    public static IgnoredFilesInfo EMPTY_FILTER = new IgnoredFilesInfoImpl(){

        @Override
        public boolean shouldBeIgnored(String fileName) {
            if (1.checkPatterns(CvsEntriesManager.getInstance().getUserdIgnores().getPatterns(), fileName)) {
                return true;
            }
            return 1.checkPatterns(PREDEFINED_PATTERNS, fileName);
        }
    };
    private List myPatterns = null;

    public static IgnoredFilesInfo createForFile(File file) {
        if (!file.isFile()) {
            return EMPTY_FILTER;
        }
        return new IgnoredFilesInfoImpl(file);
    }

    private IgnoredFilesInfoImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getPattensFor(File cvsIgnoreFile) {
        ArrayList<SimpleStringPattern> result = new ArrayList<SimpleStringPattern>();
        if (!cvsIgnoreFile.exists()) {
            return result;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(cvsIgnoreFile)));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(line, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        result.add(new SimpleStringPattern(stringTokenizer.nextToken()));
                    }
                }
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    private IgnoredFilesInfoImpl(File cvsIgnoreFile) {
        this.myPatterns = IgnoredFilesInfoImpl.getPattensFor(cvsIgnoreFile);
    }

    @Override
    public boolean shouldBeIgnored(String fileName) {
        if (EMPTY_FILTER.shouldBeIgnored(fileName)) {
            return true;
        }
        return IgnoredFilesInfoImpl.checkPatterns(this.myPatterns, fileName);
    }

    protected static boolean checkPatterns(List patterns, String fileName) {
        for (SimpleStringPattern simpleStringPattern : patterns) {
            if (!simpleStringPattern.doesMatch(fileName)) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkPatterns(SimpleStringPattern[] patterns, String fileName) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!patterns[i].doesMatch(fileName)) continue;
            return true;
        }
        return false;
    }
}

