/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.connections.CvsMethod;
import com.intellij.cvsSupport2.connections.CvsRootData;
import com.intellij.openapi.ui.InputException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class CvsRootFieldByFieldConfigurationPanel {
    private JComboBox myMethods;
    private JTextField myUser;
    private JTextField myHost;
    private JTextField myPort;
    private JTextField myRepository;
    private JPanel myPanel;
    private JSeparator mySeparator;

    public CvsRootFieldByFieldConfigurationPanel() {
        this.$$$setupUI$$$();
    }

    public void updateFrom(CvsRootData config) {
        this.myMethods.removeAllItems();
        for (int i = 0; i < CvsMethod.AVAILABLE_METHODS.length; ++i) {
            this.myMethods.addItem(CvsMethod.AVAILABLE_METHODS[i]);
        }
        this.myMethods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CvsMethod cvsMethod = (CvsMethod)CvsRootFieldByFieldConfigurationPanel.this.myMethods.getSelectedItem();
                CvsRootFieldByFieldConfigurationPanel.this.myUser.setEnabled(cvsMethod.hasUserValue());
                CvsRootFieldByFieldConfigurationPanel.this.myHost.setEnabled(cvsMethod.hasHostValue());
                CvsRootFieldByFieldConfigurationPanel.this.myPort.setEnabled(cvsMethod.hasPortValue());
            }
        });
        CvsMethod method = config.METHOD;
        this.myMethods.setSelectedItem(method);
        this.myUser.setText(config.USER);
        this.myHost.setText(config.HOST);
        if (config.PORT > 0) {
            this.myPort.setText(String.valueOf(config.PORT));
        }
        this.myRepository.setText(config.REPOSITORY);
    }

    public String getSettings() {
        String port = this.myPort.getText().trim();
        if (port.length() > 0) {
            try {
                int intPort = Integer.parseInt(port);
                if (intPort <= 0) {
                    throw new InputException(CvsBundle.message((String)"error.message.invalid.port.value", (Object[])new Object[]{port}), (JComponent)this.myPort);
                }
            }
            catch (NumberFormatException ex) {
                throw new InputException(CvsBundle.message((String)"error.message.invalid.port.value", (Object[])new Object[]{port}), (JComponent)this.myPort);
            }
        }
        CvsMethod cvsMethod = (CvsMethod)this.myMethods.getSelectedItem();
        String user = this.checkedField(this.myUser, CvsBundle.message((String)"configure.root.field.name.user", (Object[])new Object[0]), cvsMethod.hasUserValue());
        String host = this.checkedField(this.myHost, CvsBundle.message((String)"configure.root.field.name.host", (Object[])new Object[0]), cvsMethod.hasHostValue());
        String repository = this.checkedField(this.myRepository, CvsBundle.message((String)"configure.root.field.name.repository", (Object[])new Object[0]), true);
        return CvsRootConfiguration.createStringRepresentationOn(cvsMethod, user, host, port, repository);
    }

    private String checkedField(JTextField field, String name, boolean checkParameters) {
        String value = field.getText().trim();
        if (checkParameters && value.length() == 0) {
            throw new InputException(CvsBundle.message((String)"error.message.value.cannot.be.empty", (Object[])new Object[]{name}), (JComponent)field);
        }
        return value;
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSeparator jSeparator;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(5, 5, 5, 5), -1, 5, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myMethods = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.method"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.user"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myUser = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.host"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myHost = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(2, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.repository"));
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myRepository = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(3, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.port"));
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myPort = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), null));
        this.mySeparator = jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(1, 0, 1, 1, 2, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

