/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.cvsContext;

import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.cvsContext.CachedCvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsDataKeys;
import com.intellij.cvsSupport2.actions.cvsContext.CvsLightweightFile;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddedFileInfo;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class CvsContextWrapper
implements CvsContext {
    private final VcsContext myVcsContext;
    private final DataContext myContext;

    private CvsContextWrapper(AnActionEvent actionEvent, VcsContext vcsContext) {
        this.myContext = actionEvent.getDataContext();
        this.myVcsContext = vcsContext;
    }

    public static CvsContext createCachedInstance(AnActionEvent event) {
        return new CachedCvsContext(new CvsContextWrapper(event, VcsContextFactory.SERVICE.getInstance().createCachedContextOn(event)));
    }

    public static CvsContext createInstance(AnActionEvent event) {
        return new CvsContextWrapper(event, VcsContextFactory.SERVICE.getInstance().createContextOn(event));
    }

    @Override
    public boolean cvsIsActive() {
        Project project = this.getProject();
        if (project == null) {
            return false;
        }
        return ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)CvsVcs2.getInstance(project), this.getSelectedFiles());
    }

    @Override
    public Collection<String> getDeletedFileNames() {
        return (Collection)CvsDataKeys.DELETED_FILE_NAMES.getData(this.myContext);
    }

    @Override
    public String getFileToRestore() {
        return (String)CvsDataKeys.FILE_TO_RESTORE.getData(this.myContext);
    }

    @Override
    public File getSomeSelectedFile() {
        File[] selectedIOFiles = this.getSelectedIOFiles();
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        if (selectedFiles == null || selectedFiles.length == 0) {
            return this.myVcsContext.getSelectedIOFile();
        }
        if (selectedIOFiles == null || selectedIOFiles.length == 0) {
            return CvsVfsUtil.getFileFor(this.getSelectedFile());
        }
        return selectedIOFiles[0];
    }

    @Override
    public CvsLightweightFile getCvsLightweightFile() {
        return (CvsLightweightFile)CvsDataKeys.CVS_LIGHT_FILE.getData(this.myContext);
    }

    @Override
    public CvsLightweightFile[] getSelectedLightweightFiles() {
        CvsLightweightFile[] files = (CvsLightweightFile[])CvsDataKeys.CVS_LIGHT_FILES.getData(this.myContext);
        if (files != null && files.length > 0) {
            return files;
        }
        CvsLightweightFile file = this.getCvsLightweightFile();
        if (file != null) {
            return new CvsLightweightFile[]{file};
        }
        return null;
    }

    @Override
    public CvsEnvironment getEnvironment() {
        return (CvsEnvironment)CvsDataKeys.CVS_ENVIRONMENT.getData(this.myContext);
    }

    @Override
    public Collection<AddedFileInfo> getAllFilesToAdd() {
        return (Collection)CvsDataKeys.FILES_TO_ADD.getData(this.myContext);
    }

    public Project getProject() {
        return this.myVcsContext.getProject();
    }

    public VirtualFile getSelectedFile() {
        return this.myVcsContext.getSelectedFile();
    }

    public VirtualFile[] getSelectedFiles() {
        return this.myVcsContext.getSelectedFiles();
    }

    public Editor getEditor() {
        return this.myVcsContext.getEditor();
    }

    public Collection<VirtualFile> getSelectedFilesCollection() {
        return this.myVcsContext.getSelectedFilesCollection();
    }

    public File[] getSelectedIOFiles() {
        return this.myVcsContext.getSelectedIOFiles();
    }

    public int getModifiers() {
        return this.myVcsContext.getModifiers();
    }

    public Refreshable getRefreshableDialog() {
        return this.myVcsContext.getRefreshableDialog();
    }

    public String getPlace() {
        return this.myVcsContext.getPlace();
    }

    public File getSelectedIOFile() {
        return this.myVcsContext.getSelectedIOFile();
    }

    public FilePath[] getSelectedFilePaths() {
        return this.myVcsContext.getSelectedFilePaths();
    }

    public FilePath getSelectedFilePath() {
        return this.myVcsContext.getSelectedFilePath();
    }

    @Nullable
    public ChangeList[] getSelectedChangeLists() {
        return this.myVcsContext.getSelectedChangeLists();
    }

    @Nullable
    public Change[] getSelectedChanges() {
        return this.myVcsContext.getSelectedChanges();
    }
}

