/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.ActionOnSelectedElement;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.ui.Options;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.util.ui.OptionsDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemoveLocallyFileOrDirectoryAction
extends ActionOnSelectedElement {
    private final Options myOptions;

    private RemoveLocallyFileOrDirectoryAction(Options options) {
        super(false);
        this.myOptions = options;
    }

    public static RemoveLocallyFileOrDirectoryAction createAutomaticallyAction() {
        return new RemoveLocallyFileOrDirectoryAction(Options.ON_FILE_REMOVING);
    }

    public RemoveLocallyFileOrDirectoryAction() {
        this(Options.REMOVE_ACTION);
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        Project project = context.getProject();
        boolean showDialog = this.myOptions.isToBeShown(project) || OptionsDialog.shiftIsPressed((int)context.getModifiers());
        return RemoveLocallyFileOrDirectoryAction.getCvsHandler(project, this.getFilesToRemove(context), showDialog);
    }

    public static CvsHandler getDefaultHandler(Project project, Collection<File> files) {
        return RemoveLocallyFileOrDirectoryAction.getCvsHandler(project, files, true);
    }

    private static CvsHandler getCvsHandler(Project project, Collection<File> filesToRemove, boolean showDialog) {
        AbstractVcsHelper vcsHelper;
        ArrayList<File> files = new ArrayList<File>();
        for (File file : filesToRemove) {
            if (CvsUtil.fileIsLocallyAdded(file)) {
                CvsUtil.removeEntryFor(file);
                continue;
            }
            files.add(file);
        }
        if (files.isEmpty()) {
            return CvsHandler.NULL;
        }
        Collection<Object> filesToBeRemoved = RemoveLocallyFileOrDirectoryAction.filesToFilePaths(files);
        if (showDialog && ((filesToBeRemoved = (vcsHelper = AbstractVcsHelper.getInstance((Project)project)).selectFilePathsToProcess(RemoveLocallyFileOrDirectoryAction.filesToFilePaths(files), CvsBundle.message((String)"dialog.title.delete.files.from.cvs", (Object[])new Object[0]), null, CvsBundle.message((String)"dialog.title.delete.file.from.cvs", (Object[])new Object[0]), CvsBundle.message((String)"confirmation.text.delete.file.from.cvs", (Object[])new Object[0]), CvsVcs2.getInstance(project).getRemoveConfirmation())) == null || filesToBeRemoved.isEmpty())) {
            return CvsHandler.NULL;
        }
        return CommandCvsHandler.createRemoveFilesHandler(project, ChangesUtil.filePathsToFiles(filesToBeRemoved));
    }

    private static List<FilePath> filesToFilePaths(ArrayList<File> files) {
        ArrayList<FilePath> result = new ArrayList<FilePath>();
        for (File f : files) {
            result.add(VcsContextFactory.SERVICE.getInstance().createFilePathOnDeleted(f, false));
        }
        return result;
    }

    protected Collection<File> getFilesToRemove(CvsContext context) {
        Collection<String> deletedFileNames = context.getDeletedFileNames();
        ArrayList<File> result = new ArrayList<File>();
        for (String deletedFileName : deletedFileNames) {
            result.add(new File(deletedFileName));
        }
        return result;
    }

    @Override
    protected String getTitle(VcsContext context) {
        return CvsBundle.message((String)"operation.name.mark.as.deleted", (Object[])new Object[0]);
    }
}

