/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvsExecution.ModalityContextImpl;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.PostCvsActivity;
import com.intellij.cvsSupport2.cvsoperations.cvsErrors.ErrorProcessor;
import com.intellij.cvsSupport2.cvsoperations.cvsLog.LocalPathIndifferentLogOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesAdapter;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.Revision;

public abstract class StickyHeadGetter {
    protected final String myStickyData;

    protected StickyHeadGetter(String stickyData) {
        this.myStickyData = stickyData;
    }

    @Nullable
    private static String getTagStart(String currentRevision) {
        int[] subRevisions = new CvsRevisionNumber(currentRevision).getSubRevisions();
        if (subRevisions == null || subRevisions.length < 2) {
            return null;
        }
        int[] top = new int[subRevisions.length - 1];
        System.arraycopy(subRevisions, 0, top, 0, subRevisions.length - 1);
        return StringUtil.join((int[])top, (String)".");
    }

    public abstract String getHead(VirtualFile var1, String var2);

    @Nullable
    protected String getBranchHeadRevision(VirtualFile parent, String name, Convertor<CvsRevisionNumber, Boolean> chooser) {
        LocalPathIndifferentLogOperation operation = new LocalPathIndifferentLogOperation(new File(parent.getPath(), name));
        final Ref logSuccess = new Ref((Object)Boolean.TRUE);
        ModalityContext context = ModalityContextImpl.NON_MODAL;
        CvsExecutionEnvironment cvsExecutionEnvironment = new CvsExecutionEnvironment(new CvsMessagesAdapter(), CvsExecutionEnvironment.DUMMY_STOPPER, new ErrorProcessor(){

            @Override
            public void addError(VcsException ex) {
                logSuccess.set((Object)Boolean.FALSE);
            }

            @Override
            public void addWarning(VcsException ex) {
            }

            @Override
            public List getErrors() {
                return null;
            }
        }, context, PostCvsActivity.DEAF);
        try {
            operation.execute(cvsExecutionEnvironment);
        }
        catch (VcsException e) {
        }
        catch (CommandAbortedException e) {
            // empty catch block
        }
        if (Boolean.TRUE.equals(logSuccess.get())) {
            return this.extractRevision(operation, chooser);
        }
        return null;
    }

    @Nullable
    protected String extractRevision(LocalPathIndifferentLogOperation operation, Convertor<CvsRevisionNumber, Boolean> chooser) {
        Collection<CvsRevisionNumber> numberCollection = operation.getAllRevisions();
        if (numberCollection == null) {
            return null;
        }
        for (CvsRevisionNumber revisionNumber : numberCollection) {
            String stringPresentation = revisionNumber.asString();
            if (!((Boolean)chooser.convert((Object)revisionNumber)).booleanValue()) continue;
            return stringPresentation;
        }
        return null;
    }

    public static class MyStickyDateGetter
    extends StickyHeadGetter {
        private final Date myStickyDate;
        private String myTagStart;

        public MyStickyDateGetter(String stickyData, Date stickyDate, String currentRevision) {
            super(stickyData);
            this.myStickyDate = stickyDate;
            this.myTagStart = StickyHeadGetter.getTagStart(currentRevision);
        }

        @Override
        public String getHead(VirtualFile parent, String name) {
            if (this.myTagStart == null) {
                return this.myStickyData;
            }
            return this.getBranchHeadRevision(parent, name, null);
        }

        @Override
        protected String extractRevision(LocalPathIndifferentLogOperation operation, Convertor<CvsRevisionNumber, Boolean> chooser) {
            List<LogInformation> informations = operation.getLogInformationList();
            for (LogInformation information : informations) {
                List revisionList = information.getRevisionList();
                for (Revision revision : revisionList) {
                    if (!revision.getNumber().startsWith(this.myTagStart) || Comparing.compare((Comparable)revision.getDate(), (Comparable)this.myStickyDate) > 0) continue;
                    return revision.getNumber();
                }
            }
            return this.myStickyData;
        }
    }

    public static class MyStickyTagGetter
    extends StickyHeadGetter {
        public MyStickyTagGetter(String stickyData) {
            super(stickyData);
        }

        @Override
        public String getHead(VirtualFile parent, String name) {
            return this.myStickyData;
        }
    }

    public static class MyStickyBranchHeadGetter
    extends StickyHeadGetter {
        public MyStickyBranchHeadGetter(String headRevision) {
            super(headRevision);
        }

        @Override
        public String getHead(VirtualFile parent, String name) {
            final String branchRoot = StickyHeadGetter.getTagStart(this.myStickyData);
            if (branchRoot == null) {
                return this.myStickyData;
            }
            return this.getBranchHeadRevision(parent, name, new Convertor<CvsRevisionNumber, Boolean>(){

                public Boolean convert(CvsRevisionNumber o) {
                    return o.asString().startsWith(branchRoot);
                }
            });
        }
    }
}

