/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import java.util.Set;

public class DeclarationUtils {
    private DeclarationUtils() {
    }

    public static void calculateVariablesDeclared(PsiStatement statement, Set<String> variablesDeclaredAtTopLevel, Set<String> variablesDeclaredAtLowerLevels, boolean isTopLevel) {
        if (statement == null) {
            return;
        }
        if (!(statement instanceof PsiBreakStatement || statement instanceof PsiExpressionStatement || statement instanceof PsiContinueStatement || statement instanceof PsiThrowStatement || statement instanceof PsiExpressionListStatement || statement instanceof PsiAssertStatement || statement instanceof PsiReturnStatement)) {
            if (statement instanceof PsiDeclarationStatement) {
                PsiElement[] elements;
                PsiDeclarationStatement declStatement = (PsiDeclarationStatement)statement;
                for (PsiElement element : elements = declStatement.getDeclaredElements()) {
                    PsiVariable var = (PsiVariable)element;
                    String varName = var.getName();
                    if (isTopLevel) {
                        variablesDeclaredAtTopLevel.add(varName);
                        continue;
                    }
                    variablesDeclaredAtLowerLevels.add(varName);
                }
            } else if (statement instanceof PsiForStatement) {
                PsiForStatement loopStatement = (PsiForStatement)statement;
                PsiStatement initialization = loopStatement.getInitialization();
                DeclarationUtils.calculateVariablesDeclared(initialization, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                PsiStatement update = loopStatement.getUpdate();
                DeclarationUtils.calculateVariablesDeclared(update, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                PsiStatement body = loopStatement.getBody();
                DeclarationUtils.calculateVariablesDeclared(body, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof PsiWhileStatement) {
                PsiWhileStatement loopStatement = (PsiWhileStatement)statement;
                PsiStatement body = loopStatement.getBody();
                DeclarationUtils.calculateVariablesDeclared(body, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement loopStatement = (PsiDoWhileStatement)statement;
                PsiStatement body = loopStatement.getBody();
                DeclarationUtils.calculateVariablesDeclared(body, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof PsiSynchronizedStatement) {
                PsiSynchronizedStatement syncStatement = (PsiSynchronizedStatement)statement;
                PsiCodeBlock body = syncStatement.getBody();
                DeclarationUtils.calculateVariablesDeclaredInCodeBlock(body, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)statement;
                PsiCodeBlock codeBlock = block.getCodeBlock();
                DeclarationUtils.calculateVariablesDeclaredInCodeBlock(codeBlock, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, isTopLevel);
            } else if (statement instanceof PsiLabeledStatement) {
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
                PsiStatement body = labeledStatement.getStatement();
                DeclarationUtils.calculateVariablesDeclared(body, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiStatement thenBranch = ifStatement.getThenBranch();
                DeclarationUtils.calculateVariablesDeclared(thenBranch, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                PsiStatement elseBranch = ifStatement.getElseBranch();
                DeclarationUtils.calculateVariablesDeclared(elseBranch, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            } else if (statement instanceof PsiTryStatement) {
                PsiCodeBlock[] catchBlocks;
                PsiTryStatement tryStatement = (PsiTryStatement)statement;
                PsiCodeBlock tryBlock = tryStatement.getTryBlock();
                DeclarationUtils.calculateVariablesDeclaredInCodeBlock(tryBlock, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                DeclarationUtils.calculateVariablesDeclaredInCodeBlock(tryBlock, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
                if (finallyBlock != null) {
                    DeclarationUtils.calculateVariablesDeclaredInCodeBlock(finallyBlock, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                }
                for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
                    DeclarationUtils.calculateVariablesDeclaredInCodeBlock(catchBlock, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
                }
            } else if (statement instanceof PsiSwitchStatement) {
                PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement;
                PsiCodeBlock body = switchStatement.getBody();
                DeclarationUtils.calculateVariablesDeclaredInCodeBlock(body, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, false);
            }
        }
    }

    private static void calculateVariablesDeclaredInCodeBlock(PsiCodeBlock block, Set<String> variablesDeclaredAtTopLevel, Set<String> variablesDeclaredAtLowerLevels, boolean isTopLevel) {
        PsiStatement[] statements;
        if (block == null) {
            return;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            DeclarationUtils.calculateVariablesDeclared(statement, variablesDeclaredAtTopLevel, variablesDeclaredAtLowerLevels, isTopLevel);
        }
    }
}

