/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean statementMayCompleteNormally(PsiStatement statement) {
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiReturnStatement || statement instanceof PsiThrowStatement) {
            return false;
        }
        if (statement instanceof PsiExpressionListStatement || statement instanceof PsiExpressionStatement || statement instanceof PsiEmptyStatement || statement instanceof PsiAssertStatement || statement instanceof PsiDeclarationStatement) {
            return true;
        }
        if (statement instanceof PsiForStatement) {
            PsiForStatement loopStatement = (PsiForStatement)statement;
            PsiExpression test = loopStatement.getCondition();
            return test != null && !ControlFlowUtils.isBooleanConstant(test, false) || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement);
        }
        if (statement instanceof PsiWhileStatement) {
            PsiWhileStatement loopStatement = (PsiWhileStatement)statement;
            PsiExpression test = loopStatement.getCondition();
            return !ControlFlowUtils.isBooleanConstant(test, true) || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement);
        }
        if (statement instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement loopStatement = (PsiDoWhileStatement)statement;
            PsiExpression test = loopStatement.getCondition();
            PsiStatement body = loopStatement.getBody();
            return ControlFlowUtils.statementMayCompleteNormally(body) && !ControlFlowUtils.isBooleanConstant(test, true) || ControlFlowUtils.statementIsBreakTarget((PsiStatement)loopStatement);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body = ((PsiSynchronizedStatement)statement).getBody();
            return ControlFlowUtils.codeBlockMayCompleteNormally(body);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement).getCodeBlock();
            return ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
        }
        if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
            PsiStatement body = labeledStatement.getStatement();
            return ControlFlowUtils.statementMayCompleteNormally(body) || ControlFlowUtils.statementIsBreakTarget(body);
        }
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return true;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            return elseBranch == null || ControlFlowUtils.statementMayCompleteNormally(elseBranch);
        }
        if (statement instanceof PsiTryStatement) {
            PsiCodeBlock[] catchBlocks;
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock != null && !ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
                return false;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (ControlFlowUtils.codeBlockMayCompleteNormally(tryBlock)) {
                return true;
            }
            for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
                if (!ControlFlowUtils.codeBlockMayCompleteNormally(catchBlock)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof PsiSwitchStatement) {
            int lastStatementIndex;
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement;
            if (ControlFlowUtils.statementIsBreakTarget((PsiStatement)switchStatement)) {
                return true;
            }
            PsiCodeBlock body = switchStatement.getBody();
            if (body == null) {
                return true;
            }
            PsiStatement[] statements = body.getStatements();
            int lastNonLabelOffset = -1;
            for (int i = lastStatementIndex = statements.length - 1; i >= 0; --i) {
                if (statements[i] instanceof PsiSwitchLabelStatement) continue;
                lastNonLabelOffset = i;
                break;
            }
            if (lastNonLabelOffset == -1) {
                return true;
            }
            if (lastNonLabelOffset == lastStatementIndex) {
                return ControlFlowUtils.statementMayCompleteNormally(statements[lastStatementIndex]);
            }
            return true;
        }
        return false;
    }

    private static boolean codeBlockMayCompleteNormally(PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return true;
        }
        for (PsiStatement statement : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) continue;
            return false;
        }
        return true;
    }

    private static boolean isBooleanConstant(PsiExpression test, boolean value) {
        if (!PsiUtil.isConstantExpression((PsiExpression)test)) {
            return false;
        }
        Boolean constantValue = (Boolean)ConstantExpressionUtil.computeCastTo((PsiExpression)test, (PsiType)PsiType.BOOLEAN);
        return constantValue != null && constantValue == value;
    }

    private static boolean statementIsBreakTarget(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        BreakTargetFinder breakFinder = new BreakTargetFinder(statement);
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    public static boolean statementContainsExitingBreak(PsiStatement statement) {
        if (statement == null) {
            return false;
        }
        ExitingBreakFinder breakFinder = new ExitingBreakFinder();
        statement.accept((PsiElementVisitor)breakFinder);
        return breakFinder.breakFound();
    }

    private static class ExitingBreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found = false;

        private ExitingBreakFinder() {
        }

        public boolean breakFound() {
            return this.m_found;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        public void visitBreakStatement(PsiBreakStatement statement) {
            if (statement.getLabelIdentifier() != null) {
                return;
            }
            this.m_found = true;
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        }

        public void visitForStatement(PsiForStatement statement) {
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
        }

        public void visitSwitchStatement(PsiSwitchStatement statement) {
        }
    }

    private static class BreakTargetFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found = false;
        private final PsiStatement m_target;

        private BreakTargetFinder(PsiStatement target) {
            this.m_target = target;
        }

        public boolean breakFound() {
            return this.m_found;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
        }

        public void visitBreakStatement(PsiBreakStatement statement) {
            super.visitBreakStatement(statement);
            PsiStatement exitedStatement = statement.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (exitedStatement.equals(this.m_target)) {
                this.m_found = true;
            }
        }
    }
}

