/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.psiutils.ComparisonUtils;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegated(PsiExpression exp) {
        PsiPrefixExpression prefixAncestor;
        PsiJavaToken sign;
        IElementType tokenType;
        PsiExpression ancestor = exp;
        while (ancestor.getParent() instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)ancestor.getParent();
        }
        return ancestor.getParent() instanceof PsiPrefixExpression && (tokenType = (sign = (prefixAncestor = (PsiPrefixExpression)ancestor.getParent()).getOperationSign()).getTokenType()).equals(JavaTokenType.EXCL);
    }

    @Nullable
    public static PsiExpression findNegation(PsiExpression exp) {
        PsiPrefixExpression prefixAncestor;
        PsiJavaToken sign;
        PsiExpression ancestor = exp;
        while (ancestor.getParent() instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)ancestor.getParent();
        }
        if (ancestor.getParent() instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((sign = (prefixAncestor = (PsiPrefixExpression)ancestor.getParent()).getOperationSign()).getTokenType())) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isNegation(PsiExpression exp) {
        if (!(exp instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)exp;
        PsiJavaToken sign = prefixExp.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        return tokenType.equals(JavaTokenType.EXCL);
    }

    @Nullable
    public static PsiExpression getNegated(PsiExpression exp) {
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)exp;
        PsiExpression operand = prefixExp.getOperand();
        if (operand == null) {
            return null;
        }
        return ParenthesesUtils.stripParentheses(operand);
    }

    public static boolean isBooleanLiteral(PsiExpression exp) {
        if (exp instanceof PsiLiteralExpression) {
            PsiLiteralExpression expression = (PsiLiteralExpression)exp;
            String text = expression.getText();
            return "true".equals(text) || "false".equals(text);
        }
        return false;
    }

    public static String getNegatedExpressionText(@Nullable PsiExpression condition) {
        if (condition == null) {
            return "";
        }
        if (condition instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
            PsiExpression expression = parenthesizedExpression.getExpression();
            return '(' + BoolUtils.getNegatedExpressionText(expression) + ')';
        }
        if (BoolUtils.isNegation(condition)) {
            PsiExpression negated = BoolUtils.getNegated(condition);
            if (negated == null) {
                return "";
            }
            return negated.getText();
        }
        if (ComparisonUtils.isComparison(condition)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiJavaToken sign = binaryExpression.getOperationSign();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return lhs.getText() + negatedComparison;
            }
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(condition) > 3) {
            return "!(" + condition.getText() + ')';
        }
        return '!' + condition.getText();
    }
}

