/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.ReplacePostfixExpressionWithOperatorAssignmentPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplacePostfixExpressionWithOperatorAssignmentIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
        PsiJavaToken sign = postfixExpression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        String replacementText = JavaTokenType.PLUSPLUS.equals(tokenType) ? "+=" : "-=";
        String signText = sign.getText();
        return IntentionPowerPackBundle.message("replace.some.operator.with.other.intention.name", signText, replacementText);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ReplacePostfixExpressionWithOperatorAssignmentPredicate replacePostfixExpressionWithOperatorAssignmentPredicate = new ReplacePostfixExpressionWithOperatorAssignmentPredicate();
        if (replacePostfixExpressionWithOperatorAssignmentPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/opassign/ReplacePostfixExpressionWithOperatorAssignmentIntention.getElementPredicate must not return null");
        }
        return replacePostfixExpressionWithOperatorAssignmentPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/opassign/ReplacePostfixExpressionWithOperatorAssignmentIntention.processIntention must not be null");
        }
        PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
        PsiExpression operand = postfixExpression.getOperand();
        String operandText = operand.getText();
        IElementType tokenType = postfixExpression.getOperationTokenType();
        if (JavaTokenType.PLUSPLUS.equals(tokenType)) {
            ReplacePostfixExpressionWithOperatorAssignmentIntention.replaceExpression(operandText + "+=1", (PsiExpression)postfixExpression);
        } else if (JavaTokenType.MINUSMINUS.equals(tokenType)) {
            ReplacePostfixExpressionWithOperatorAssignmentIntention.replaceExpression(operandText + "-=1", (PsiExpression)postfixExpression);
        }
    }
}

