/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.HashSet;
import java.util.Set;

class OperatorAssignmentPredicate
implements PsiElementPredicate {
    private static final Set<IElementType> OPERATOR_ASSIGNMENT_TOKENS = new HashSet<IElementType>();

    OperatorAssignmentPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        return OPERATOR_ASSIGNMENT_TOKENS.contains(tokenType);
    }

    static {
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.PLUSEQ);
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.MINUSEQ);
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.ASTERISKEQ);
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.PERCEQ);
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.DIVEQ);
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.ANDEQ);
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.OREQ);
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.XOREQ);
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.LTLTEQ);
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.GTGTEQ);
        OPERATOR_ASSIGNMENT_TOKENS.add(JavaTokenType.GTGTGTEQ);
    }
}

